/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.dataset;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.dataset.DataSet;
import org.alfresco.module.org_alfresco_module_rm.dataset.DataSetService;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.model.behaviour.RecordsManagementSearchBehaviour;
import org.alfresco.module.org_alfresco_module_rm.recordfolder.RecordFolderService;
import org.alfresco.module.org_alfresco_module_rm.role.FilePlanRoleService;
import org.alfresco.module.org_alfresco_module_rm.role.Role;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSetServiceImpl
implements DataSetService,
RecordsManagementModel {
    private static Log logger = LogFactory.getLog(DataSetServiceImpl.class);
    private Map<String, DataSet> dataSets = new HashMap<String, DataSet>();
    private static final StoreRef SPACES_STORE = new StoreRef("workspace", "SpacesStore");
    private static final String CHARSET_NAME = "UTF-8";
    private ImporterService importerService;
    private SearchService searchService;
    private NodeService nodeService;
    private FilePlanService filePlanService;
    private PermissionService permissionService;
    private AuthorityService authorityService;
    private FilePlanRoleService filePlanRoleService;
    private RecordsManagementSearchBehaviour recordsManagementSearchBehaviour;
    private DispositionService dispositionService;
    private RecordFolderService recordFolderService;

    public void setImporterService(ImporterService importerService) {
        this.importerService = importerService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setFilePlanRoleService(FilePlanRoleService filePlanRoleService) {
        this.filePlanRoleService = filePlanRoleService;
    }

    public void setRecordsManagementSearchBehaviour(RecordsManagementSearchBehaviour recordsManagementSearchBehaviour) {
        this.recordsManagementSearchBehaviour = recordsManagementSearchBehaviour;
    }

    public void setDispositionService(DispositionService dispositionService) {
        this.dispositionService = dispositionService;
    }

    public void setRecordFolderService(RecordFolderService recordFolderService) {
        this.recordFolderService = recordFolderService;
    }

    @Override
    public void register(DataSet dataSet) {
        ParameterCheck.mandatory((String)"dataSet", (Object)dataSet);
        this.dataSets.put(dataSet.getId(), dataSet);
    }

    @Override
    public Map<String, DataSet> getDataSets() {
        return this.dataSets;
    }

    @Override
    public Map<String, DataSet> getDataSets(NodeRef filePlan, boolean excludeLoaded) {
        ParameterCheck.mandatory((String)"filePlan", (Object)filePlan);
        ParameterCheck.mandatory((String)"excludeLoaded", (Object)excludeLoaded);
        HashMap<String, DataSet> dataSets = new HashMap<String, DataSet>(this.getDataSets());
        if (excludeLoaded) {
            dataSets.keySet().removeAll(this.getLoadedDataSets(filePlan).keySet());
        }
        return dataSets;
    }

    @Override
    public void loadDataSet(NodeRef filePlan, String dataSetId) {
        ParameterCheck.mandatory((String)"filePlan", (Object)filePlan);
        ParameterCheck.mandatoryString((String)"dataSetId", (String)dataSetId);
        DataSet dataSet = this.getDataSets().get(dataSetId);
        InputStream is = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream(dataSet.getPath());
            if (is == null) {
                throw new AlfrescoRuntimeException("The '" + dataSet.getLabel() + "' import file could not be found!");
            }
            InputStreamReader viewReader = new InputStreamReader(is, CHARSET_NAME);
            Location location = new Location(filePlan);
            this.importerService.importView((Reader)viewReader, location, null, null);
            this.patchLoadedData();
            this.setDataSetIdIntoFilePlan(dataSetId, filePlan);
        }
        catch (Exception ex) {
            throw new AlfrescoRuntimeException("Unexpected exception thrown. Please refer to the log files for details.", (Throwable)ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                    is = null;
                }
                catch (IOException ex) {
                    throw new AlfrescoRuntimeException("Failed to close the input stream!", (Throwable)ex);
                }
            }
        }
    }

    @Override
    public boolean existsDataSet(String dataSetId) {
        ParameterCheck.mandatoryString((String)"dataSetId", (String)dataSetId);
        return this.getDataSets().containsKey(dataSetId);
    }

    @Override
    public Map<String, DataSet> getLoadedDataSets(NodeRef filePlan) {
        ParameterCheck.mandatory((String)"filePlan", (Object)filePlan);
        HashMap<String, DataSet> availableDataSets = new HashMap<String, DataSet>(this.getDataSets());
        Serializable dataSetIds = this.nodeService.getProperty(filePlan, PROP_LOADED_DATA_SET_IDS);
        if (dataSetIds != null) {
            ArrayList loadedDataSetIds = (ArrayList)dataSetIds;
            Iterator iterator = availableDataSets.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String key = (String)entry.getKey();
                if (loadedDataSetIds.contains(key)) continue;
                iterator.remove();
            }
            return availableDataSets;
        }
        return new HashMap<String, DataSet>();
    }

    @Override
    public boolean isLoadedDataSet(NodeRef filePlan, String dataSetId) {
        ParameterCheck.mandatory((String)"filePlan", (Object)filePlan);
        ParameterCheck.mandatory((String)"dataSetId", (Object)dataSetId);
        return this.getLoadedDataSets(filePlan).containsKey(dataSetId);
    }

    private void patchLoadedData() {
        AuthenticationUtil.RunAsWork<Object> runAsWork = new AuthenticationUtil.RunAsWork<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doWork() {
                Set<NodeRef> rmRoots = DataSetServiceImpl.this.filePlanService.getFilePlans();
                logger.info((Object)("Bootstraping " + rmRoots.size() + " rm roots ..."));
                for (NodeRef rmRoot : rmRoots) {
                    String allRoleShortName;
                    String allRoleGroupName;
                    if (DataSetServiceImpl.this.permissionService.getInheritParentPermissions(rmRoot)) {
                        logger.info((Object)("Updating permissions for rm root: " + String.valueOf(rmRoot)));
                        DataSetServiceImpl.this.permissionService.setInheritParentPermissions(rmRoot, false);
                    }
                    if (DataSetServiceImpl.this.authorityService.authorityExists(allRoleGroupName = DataSetServiceImpl.this.authorityService.getName(AuthorityType.GROUP, allRoleShortName = "AllRoles" + rmRoot.getId()))) continue;
                    logger.info((Object)("Creating all roles group for root node: " + rmRoot.toString()));
                    String allRoles = DataSetServiceImpl.this.authorityService.createAuthority(AuthorityType.GROUP, allRoleShortName, "All Roles", new HashSet<String>(Arrays.asList("APP.RM")));
                    Set<Role> roles = DataSetServiceImpl.this.filePlanRoleService.getRoles(rmRoot);
                    for (Role role : roles) {
                        logger.info((Object)("   - adding role group " + role.getRoleGroupName() + " to all roles group"));
                        DataSetServiceImpl.this.authorityService.addAuthority(allRoles, role.getRoleGroupName());
                    }
                    DataSetServiceImpl.this.permissionService.setPermission(rmRoot, allRoles, "ReadRecords", true);
                }
                try (ResultSet rs = DataSetServiceImpl.this.searchService.query(SPACES_STORE, "fts-alfresco", "TYPE:\"rma:recordsManagementContainer\"");){
                    logger.info((Object)("Bootstraping " + rs.length() + " record containers ..."));
                    for (NodeRef container : rs.getNodeRefs()) {
                        String containerName = (String)((Object)DataSetServiceImpl.this.nodeService.getProperty(container, ContentModel.PROP_NAME));
                        if (!DataSetServiceImpl.this.permissionService.getInheritParentPermissions(container)) continue;
                        logger.info((Object)("Updating permissions for record container: " + containerName));
                        DataSetServiceImpl.this.permissionService.setInheritParentPermissions(container, false);
                    }
                }
                rs = DataSetServiceImpl.this.searchService.query(SPACES_STORE, "fts-alfresco", "TYPE:\"rma:recordFolder\"");
                try {
                    logger.info((Object)("Bootstraping " + rs.length() + " record folders ..."));
                    for (NodeRef recordFolder : rs.getNodeRefs()) {
                        DispositionSchedule ds;
                        String folderName = (String)((Object)DataSetServiceImpl.this.nodeService.getProperty(recordFolder, ContentModel.PROP_NAME));
                        if (DataSetServiceImpl.this.permissionService.getInheritParentPermissions(recordFolder)) {
                            logger.info((Object)("Updating permissions for record folder: " + folderName));
                            DataSetServiceImpl.this.permissionService.setInheritParentPermissions(recordFolder, false);
                        }
                        if (!DataSetServiceImpl.this.nodeService.hasAspect(recordFolder, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE) && (ds = DataSetServiceImpl.this.dispositionService.getDispositionSchedule(recordFolder)) != null) {
                            logger.info((Object)("Setting up bootstraped record folder: " + folderName));
                            DataSetServiceImpl.this.recordFolderService.setupRecordFolder(recordFolder);
                        }
                        logger.info((Object)("Setting up search aspect for record folder: " + folderName));
                        DataSetServiceImpl.this.recordsManagementSearchBehaviour.fixupSearchAspect(recordFolder);
                    }
                }
                finally {
                    rs.close();
                }
                return null;
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)runAsWork, (String)AuthenticationUtil.getAdminUserName());
    }

    private void setDataSetIdIntoFilePlan(String dataSetId, NodeRef filePlan) {
        ArrayList loadedDataSetIds;
        HashMap<QName, ArrayList> aspectProperties;
        Serializable dataSetIds = this.nodeService.getProperty(filePlan, PROP_LOADED_DATA_SET_IDS);
        if (dataSetIds == null) {
            aspectProperties = new HashMap<QName, ArrayList>(1);
            aspectProperties.put(PROP_LOADED_DATA_SET_IDS, new ArrayList());
            this.nodeService.addAspect(filePlan, ASPECT_LOADED_DATA_SET_ID, aspectProperties);
            loadedDataSetIds = (ArrayList)this.nodeService.getProperty(filePlan, PROP_LOADED_DATA_SET_IDS);
        } else {
            loadedDataSetIds = (ArrayList)dataSetIds;
        }
        loadedDataSetIds.add(dataSetId);
        aspectProperties = new HashMap(1);
        aspectProperties.put(PROP_LOADED_DATA_SET_IDS, loadedDataSetIds);
        this.nodeService.addAspect(filePlan, ASPECT_LOADED_DATA_SET_ID, aspectProperties);
    }
}

