/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.capability;

import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.capability.CapabilityService;
import org.alfresco.module.org_alfresco_module_rm.capability.Group;
import org.alfresco.module.org_alfresco_module_rm.capability.RMPermissionModel;
import org.alfresco.module.org_alfresco_module_rm.capability.RMSecurityCommon;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.security.RMMethodSecurityInterceptor;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.apache.commons.lang3.StringUtils;
import org.springframework.extensions.surf.util.I18NUtil;

public abstract class AbstractCapability
extends RMSecurityCommon
implements Capability,
RecordsManagementModel,
RMPermissionModel {
    protected CapabilityService capabilityService;
    protected String name;
    protected String title;
    protected String description;
    protected Group group;
    protected int index;
    protected boolean isPrivate = false;

    public void setCapabilityService(CapabilityService capabilityService) {
        this.capabilityService = capabilityService;
    }

    public void init() {
        this.capabilityService.registerCapability(this);
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        String title = this.title;
        if (StringUtils.isBlank((CharSequence)title) && StringUtils.isBlank((CharSequence)(title = I18NUtil.getMessage((String)("capability." + this.getName() + ".title"))))) {
            title = this.getName();
        }
        return title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDescriptionId(String descriptionId) {
        this.description = I18NUtil.getMessage((String)descriptionId);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isPrivate() {
        return this.isPrivate;
    }

    public void setPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    private AccessStatus translate(int vote) {
        switch (vote) {
            case 0: {
                return AccessStatus.UNDETERMINED;
            }
            case 1: {
                return AccessStatus.ALLOWED;
            }
            case -1: {
                return AccessStatus.DENIED;
            }
        }
        return AccessStatus.UNDETERMINED;
    }

    @Override
    public AccessStatus hasPermission(NodeRef nodeRef) {
        return this.translate(this.hasPermissionRaw(nodeRef));
    }

    @Override
    public int hasPermissionRaw(NodeRef nodeRef) {
        String prefix = "hasPermissionRaw" + this.getName();
        int result = this.getTransactionCache(prefix, nodeRef);
        if (result == -100) {
            result = this.checkRmRead(nodeRef) == -1 ? -1 : this.hasPermissionImpl(nodeRef);
            result = this.setTransactionCache(prefix, nodeRef, result);
        }
        RMMethodSecurityInterceptor.reportCapabilityStatus(this.getName(), result);
        return result;
    }

    protected int hasPermissionImpl(NodeRef nodeRef) {
        return this.evaluate(nodeRef);
    }

    @Override
    public int evaluate(NodeRef source, NodeRef target) {
        return 0;
    }

    @Override
    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractCapability other = (AbstractCapability)obj;
        return !(this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName()));
    }
}

