/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.audit.RecordsManagementAuditService;
import org.alfresco.module.org_alfresco_module_rm.audit.event.AuditEvent;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessControlEntry;
import org.alfresco.repo.security.permissions.AccessControlList;
import org.alfresco.repo.security.permissions.impl.ExtendedPermissionService;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl;
import org.alfresco.repo.security.permissions.processor.PermissionPostProcessor;
import org.alfresco.repo.security.permissions.processor.PermissionPreProcessor;
import org.alfresco.repo.security.permissions.processor.PermissionProcessorRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationEvent;

public class ExtendedPermissionServiceImpl
extends PermissionServiceImpl
implements ExtendedPermissionService {
    private static final String AUDIT_ENABLE_INHERIT_PERMISSION = "enable-inherit-permission";
    private static final String AUDIT_DISABLE_INHERIT_PERMISSION = "disable-inherit-permission";
    protected SimpleCache<Serializable, Set<String>> writersCache;
    protected List<String> configuredReadPermissions;
    protected List<String> configuredFilePermissions;
    private FilePlanService filePlanService;
    private PermissionProcessorRegistry permissionProcessorRegistry;
    private RecordsManagementAuditService recordsManagementAuditService;

    public void init() {
        super.init();
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                ExtendedPermissionServiceImpl.this.recordsManagementAuditService.registerAuditEvent(new AuditEvent(ExtendedPermissionServiceImpl.AUDIT_ENABLE_INHERIT_PERMISSION, "rm.audit.enable-inherit-permission"));
                ExtendedPermissionServiceImpl.this.recordsManagementAuditService.registerAuditEvent(new AuditEvent(ExtendedPermissionServiceImpl.AUDIT_DISABLE_INHERIT_PERMISSION, "rm.audit.disable-inherit-permission"));
                return null;
            }
        });
    }

    public FilePlanService getFilePlanService() {
        return this.filePlanService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setPermissionProcessorRegistry(PermissionProcessorRegistry permissionProcessorRegistry) {
        this.permissionProcessorRegistry = permissionProcessorRegistry;
    }

    public void setRecordsManagementAuditService(RecordsManagementAuditService recordsManagementAuditService) {
        this.recordsManagementAuditService = recordsManagementAuditService;
    }

    public void setAnyDenyDenies(boolean anyDenyDenies) {
        super.setAnyDenyDenies(anyDenyDenies);
        if (this.writersCache != null) {
            this.writersCache.clear();
        }
    }

    public void setWritersCache(SimpleCache<Serializable, Set<String>> writersCache) {
        this.writersCache = writersCache;
    }

    public void setConfiguredReadPermissions(String readMapping) {
        this.configuredReadPermissions = Arrays.asList(readMapping.split(","));
    }

    public void setConfiguredFilePermissions(String fileMapping) {
        this.configuredFilePermissions = Arrays.asList(fileMapping.split(","));
    }

    protected void onBootstrap(ApplicationEvent event) {
        super.onBootstrap(event);
        PropertyCheck.mandatory((Object)this, (String)"writersCache", this.writersCache);
    }

    public AccessStatus hasPermission(NodeRef nodeRef, String perm) {
        AccessStatus result = AccessStatus.UNDETERMINED;
        if (this.nodeService.exists(nodeRef)) {
            List<PermissionPreProcessor> preProcessors = this.permissionProcessorRegistry.getPermissionPreProcessors();
            for (PermissionPreProcessor preProcessor : preProcessors) {
                result = preProcessor.process(nodeRef, perm);
                if (!AccessStatus.DENIED.equals((Object)result)) continue;
                return result;
            }
            result = this.hasPermissionImpl(nodeRef, perm);
            List<PermissionPostProcessor> postProcessors = this.permissionProcessorRegistry.getPermissionPostProcessors();
            for (PermissionPostProcessor postProcessor : postProcessors) {
                result = postProcessor.process(result, nodeRef, perm, this.configuredReadPermissions, this.configuredFilePermissions);
            }
        }
        return result;
    }

    protected AccessStatus hasPermissionImpl(NodeRef nodeRef, String perm) {
        return super.hasPermission(nodeRef, perm);
    }

    protected AccessStatus canRead(Long aclId) {
        Set authorities = this.getAuthorisations();
        if (this.anyDenyDenies) {
            Set<String> aclReadersDenied = this.getReadersDenied(aclId);
            for (String auth : aclReadersDenied) {
                if (!authorities.contains(auth)) continue;
                return AccessStatus.DENIED;
            }
        }
        Set<String> aclReaders = this.getReaders(aclId);
        for (String auth : aclReaders) {
            if (!authorities.contains(auth)) continue;
            return AccessStatus.ALLOWED;
        }
        return AccessStatus.DENIED;
    }

    public Set<String> getReaders(Long aclId) {
        AccessControlList acl = this.aclDaoComponent.getAccessControlList(aclId);
        if (acl == null) {
            return Collections.emptySet();
        }
        Set<String> aclReaders = (Set<String>)this.readersCache.get((Serializable)acl.getProperties());
        if (aclReaders != null) {
            return aclReaders;
        }
        HashSet<String> assigned = new HashSet<String>();
        HashSet<String> readers = new HashSet<String>();
        for (AccessControlEntry ace : acl.getEntries()) {
            assigned.add(ace.getAuthority());
        }
        for (String authority : assigned) {
            PermissionServiceImpl.UnconditionalAclTest test = new PermissionServiceImpl.UnconditionalAclTest((PermissionServiceImpl)this, this.getPermissionReference("Read"));
            PermissionServiceImpl.UnconditionalAclTest rmTest = new PermissionServiceImpl.UnconditionalAclTest((PermissionServiceImpl)this, this.getPermissionReference("ReadRecords"));
            if (!test.evaluate(authority, aclId) && !rmTest.evaluate(authority, aclId)) continue;
            readers.add(authority);
        }
        aclReaders = Collections.unmodifiableSet(readers);
        this.readersCache.put((Serializable)acl.getProperties(), aclReaders);
        return aclReaders;
    }

    public Set<String> getReadersDenied(Long aclId) {
        AccessControlList acl = this.aclDaoComponent.getAccessControlList(aclId);
        if (acl == null) {
            return Collections.emptySet();
        }
        HashSet<String> denied = (HashSet<String>)this.readersDeniedCache.get((Serializable)aclId);
        if (denied != null) {
            return denied;
        }
        denied = new HashSet<String>();
        HashSet<String> assigned = new HashSet<String>();
        for (AccessControlEntry ace : acl.getEntries()) {
            assigned.add(ace.getAuthority());
        }
        for (String authority : assigned) {
            PermissionServiceImpl.UnconditionalDeniedAclTest test = new PermissionServiceImpl.UnconditionalDeniedAclTest((PermissionServiceImpl)this, this.getPermissionReference("Read"));
            PermissionServiceImpl.UnconditionalDeniedAclTest rmTest = new PermissionServiceImpl.UnconditionalDeniedAclTest((PermissionServiceImpl)this, this.getPermissionReference("ReadRecords"));
            if (!test.evaluate(authority, aclId) && !rmTest.evaluate(authority, aclId)) continue;
            denied.add(authority);
        }
        this.readersDeniedCache.put((Serializable)acl.getProperties(), denied);
        return denied;
    }

    @Override
    public Set<String> getWriters(Long aclId) {
        AccessControlList acl = this.aclDaoComponent.getAccessControlList(aclId);
        if (acl == null) {
            return Collections.emptySet();
        }
        Set<String> aclWriters = (Set<String>)this.writersCache.get((Serializable)acl.getProperties());
        if (aclWriters != null) {
            return aclWriters;
        }
        HashSet<String> assigned = new HashSet<String>();
        HashSet<String> readers = new HashSet<String>();
        for (AccessControlEntry ace : acl.getEntries()) {
            assigned.add(ace.getAuthority());
        }
        for (String authority : assigned) {
            PermissionServiceImpl.UnconditionalAclTest test = new PermissionServiceImpl.UnconditionalAclTest((PermissionServiceImpl)this, this.getPermissionReference("Write"));
            if (!test.evaluate(authority, aclId)) continue;
            readers.add(authority);
        }
        aclWriters = Collections.unmodifiableSet(readers);
        this.writersCache.put((Serializable)acl.getProperties(), aclWriters);
        return aclWriters;
    }

    public void setInheritParentPermissions(NodeRef nodeRef, boolean inheritParentPermissions) {
        String adminRole = this.getAdminRole(nodeRef);
        if (this.nodeService.hasAspect(nodeRef, RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT) && StringUtils.isNotBlank((CharSequence)adminRole) && !inheritParentPermissions) {
            this.setPermission(nodeRef, adminRole, "Filing", true);
        }
        if (inheritParentPermissions != super.getInheritParentPermissions(nodeRef)) {
            super.setInheritParentPermissions(nodeRef, inheritParentPermissions);
            String auditEvent = inheritParentPermissions ? AUDIT_ENABLE_INHERIT_PERMISSION : AUDIT_DISABLE_INHERIT_PERMISSION;
            this.recordsManagementAuditService.auditEvent(nodeRef, auditEvent);
        }
    }

    private String getAdminRole(NodeRef nodeRef) {
        String adminRole = null;
        NodeRef filePlan = this.getFilePlanService().getFilePlan(nodeRef);
        if (filePlan != null) {
            adminRole = this.authorityService.getName(AuthorityType.GROUP, "Administrator" + filePlan.getId());
        }
        return adminRole;
    }

    @Override
    public Pair<Set<String>, Set<String>> getReadersAndWriters(NodeRef nodeRef) {
        Long aclId = this.nodeService.getNodeAclId(nodeRef);
        Set<String> readers = this.getReaders(aclId);
        Set<String> writers = this.getWriters(aclId);
        HashSet<String> modifiedWrtiers = new HashSet<String>(writers);
        String owner = this.ownableService.getOwner(nodeRef);
        if (StringUtils.isNotBlank((CharSequence)owner) && !owner.equals("") && this.authorityService.authorityExists(owner)) {
            modifiedWrtiers.add(owner);
        }
        return new Pair(readers, modifiedWrtiers);
    }
}

