/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.system;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.notification.RecordsManagementNotificationHelper;
import org.alfresco.module.org_alfresco_module_rm.role.Role;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class NotificationServiceHelperSystemTest
extends BaseRMTestCase {
    private static final String NOTIFICATION_ROLE = "RecordsManager";
    private static final String EMAIL_ADDRESS = "roy.wetherall@alfreso.com";
    private RecordsManagementNotificationHelper notificationHelper;
    private NodeRef record;
    private List<NodeRef> records;
    private String userName;
    private NodeRef person;

    @Override
    protected void initServices() {
        super.initServices();
        this.notificationHelper = (RecordsManagementNotificationHelper)this.applicationContext.getBean("recordsManagementNotificationHelper");
    }

    @Override
    protected void setupTestData() {
        super.setupTestData();
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
                NotificationServiceHelperSystemTest.this.userName = GUID.generate();
                NotificationServiceHelperSystemTest.this.authenticationService.createAuthentication(NotificationServiceHelperSystemTest.this.userName, "".toCharArray());
                PropertyMap props = new PropertyMap();
                props.put((Object)ContentModel.PROP_USERNAME, (Object)NotificationServiceHelperSystemTest.this.userName);
                props.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"Test");
                props.put((Object)ContentModel.PROP_LASTNAME, (Object)"User");
                props.put((Object)ContentModel.PROP_EMAIL, (Object)NotificationServiceHelperSystemTest.EMAIL_ADDRESS);
                NotificationServiceHelperSystemTest.this.person = NotificationServiceHelperSystemTest.this.personService.createPerson((Map)props);
                Role role = NotificationServiceHelperSystemTest.this.filePlanRoleService.getRole(NotificationServiceHelperSystemTest.this.filePlan, NotificationServiceHelperSystemTest.NOTIFICATION_ROLE);
                TestCase.assertNotNull((String)"Notification role could not be retrieved", (Object)role);
                String roleGroup = role.getRoleGroupName();
                TestCase.assertNotNull((String)"Notification role group can not be null.", (Object)roleGroup);
                NotificationServiceHelperSystemTest.this.authorityService.addAuthority(roleGroup, NotificationServiceHelperSystemTest.this.userName);
                return null;
            }
        });
    }

    @Override
    protected void setupTestDataImpl() {
        super.setupTestDataImpl();
        this.record = this.utils.createRecord(this.rmFolder, "recordOne");
        NodeRef record2 = this.utils.createRecord(this.rmFolder, "recordTwo");
        NodeRef record3 = this.utils.createRecord(this.rmFolder, "recordThree");
        this.records = new ArrayList<NodeRef>(3);
        this.records.add(this.record);
        this.records.add(record2);
        this.records.add(record3);
    }

    @Override
    protected void tearDownImpl() {
        super.tearDownImpl();
        this.personService.deletePerson(this.person);
    }

    public void testSendDueForReviewNotification() {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                NotificationServiceHelperSystemTest.this.notificationHelper.recordsDueForReviewEmailNotification(NotificationServiceHelperSystemTest.this.records);
                return null;
            }
        });
    }

    public void testSendSupersededNotification() {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                NotificationServiceHelperSystemTest.this.notificationHelper.recordSupersededEmailNotification(NotificationServiceHelperSystemTest.this.record);
                return null;
            }
        });
    }
}

