/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.dod;

import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.dod5015.DOD5015Model;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.GUID;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class RM1194ExcludeDoDRecordTypesTest
extends BaseRMTestCase
implements DOD5015Model {
    @Override
    protected boolean isRMSiteTest() {
        return false;
    }

    public void testDODRecord() {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){
            String siteId;
            {
                this.siteId = GUID.generate();
            }

            public NodeRef run() throws Exception {
                RM1194ExcludeDoDRecordTypesTest.this.siteService.createSite("dodrmsite", this.siteId, "title", "description", SiteVisibility.PUBLIC, DOD5015Model.TYPE_DOD_5015_SITE);
                NodeRef filePlan = RM1194ExcludeDoDRecordTypesTest.this.siteService.getContainer(this.siteId, "documentlibrary");
                TestCase.assertNotNull((Object)filePlan);
                NodeRef recordCategory = RM1194ExcludeDoDRecordTypesTest.this.filePlanService.createRecordCategory(filePlan, "testOne");
                NodeRef recordFolder = RM1194ExcludeDoDRecordTypesTest.this.recordFolderService.createRecordFolder(recordCategory, "testOne");
                NodeRef record = RM1194ExcludeDoDRecordTypesTest.this.utils.createRecord(recordFolder, "testOne.txt", "Test One");
                return record;
            }

            public void test(NodeRef record) throws Exception {
                TestCase.assertNotNull((Object)record);
                Set aspects = RM1194ExcludeDoDRecordTypesTest.this.recordService.getRecordMetadataAspects(record);
                TestCase.assertNotNull((Object)aspects);
                TestCase.assertEquals((int)5, (int)aspects.size());
            }
        });
    }

    public void testVanillaRecord() {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){
            String siteId;
            {
                this.siteId = GUID.generate();
            }

            public NodeRef run() throws Exception {
                RM1194ExcludeDoDRecordTypesTest.this.siteService.createSite("rmsite", this.siteId, "title", "description", SiteVisibility.PUBLIC, RecordsManagementModel.TYPE_RM_SITE);
                NodeRef filePlan = RM1194ExcludeDoDRecordTypesTest.this.siteService.getContainer(this.siteId, "documentlibrary");
                TestCase.assertNotNull((Object)filePlan);
                NodeRef recordCategory = RM1194ExcludeDoDRecordTypesTest.this.filePlanService.createRecordCategory(filePlan, "testOne");
                NodeRef recordFolder = RM1194ExcludeDoDRecordTypesTest.this.recordFolderService.createRecordFolder(recordCategory, "testOne");
                NodeRef record = RM1194ExcludeDoDRecordTypesTest.this.utils.createRecord(recordFolder, "testOne.txt", "Test One");
                return record;
            }

            public void test(NodeRef record) throws Exception {
                TestCase.assertNotNull((Object)record);
                Set aspects = RM1194ExcludeDoDRecordTypesTest.this.recordService.getRecordMetadataAspects(record);
                TestCase.assertNotNull((Object)aspects);
                TestCase.assertEquals((int)2, (int)aspects.size());
            }
        });
    }
}

