/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.fileplans;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.util.RMParameterCheck;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.node.getchildren.FilterProp;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.rest.api.impl.Util;
import org.alfresco.rest.api.model.UserInfo;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.MultiPartRelationshipResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.alfresco.rm.rest.api.fileplans.FilePlanEntityResource;
import org.alfresco.rm.rest.api.impl.ApiNodesModelFactory;
import org.alfresco.rm.rest.api.impl.FilePlanComponentsApiUtils;
import org.alfresco.rm.rest.api.impl.SearchTypesFactory;
import org.alfresco.rm.rest.api.model.FilePlan;
import org.alfresco.rm.rest.api.model.RecordCategory;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.extensions.webscripts.servlet.FormData;

@RelationshipResource(name="categories", entityResource=FilePlanEntityResource.class, title="Category children of file plan")
public class FilePlanChildrenRelation
implements RelationshipResourceAction.Read<RecordCategory>,
RelationshipResourceAction.Create<RecordCategory>,
MultiPartRelationshipResourceAction.Create<RecordCategory>,
InitializingBean {
    public static final String RECORD_CATEGORY_TYPE = "rma:recordCategory";
    private FilePlanComponentsApiUtils apiUtils;
    private FileFolderService fileFolderService;
    private ApiNodesModelFactory nodesModelFactory;
    private SearchTypesFactory searchTypesFactory;
    private TransactionService transactionService;

    public void setApiUtils(FilePlanComponentsApiUtils apiUtils) {
        this.apiUtils = apiUtils;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setNodesModelFactory(ApiNodesModelFactory nodesModelFactory) {
        this.nodesModelFactory = nodesModelFactory;
    }

    public void setSearchTypesFactory(SearchTypesFactory searchTypesFactory) {
        this.searchTypesFactory = searchTypesFactory;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void afterPropertiesSet() throws Exception {
        ParameterCheck.mandatory((String)"apiUtils", (Object)this.apiUtils);
        ParameterCheck.mandatory((String)"fileFolderService", (Object)this.fileFolderService);
        ParameterCheck.mandatory((String)"nodesModelFactory", (Object)this.nodesModelFactory);
        ParameterCheck.mandatory((String)"searchTypesFactory", (Object)this.searchTypesFactory);
    }

    @WebApiDescription(title="Return a paged list of file plan children (record categories) for the container identified by 'filePlanId'")
    public CollectionWithPagingInfo<RecordCategory> readAll(String filePlanId, final Parameters parameters) {
        RMParameterCheck.checkNotBlank("filePlanId", filePlanId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        QName filePlanType = this.apiUtils.getFilePlanType();
        if (filePlanType == null) {
            throw new EntityNotFoundException(filePlanId);
        }
        NodeRef parentNodeRef = this.apiUtils.lookupAndValidateNodeType(filePlanId, filePlanType);
        Set<QName> searchTypeQNames = this.searchTypesFactory.buildSearchTypesForFilePlanEndpoint();
        List<FilterProp> filterProps = this.apiUtils.getListChildrenFilterProps(parameters, null);
        PagingResults pagingResults = this.fileFolderService.list(parentNodeRef, null, searchTypeQNames, null, this.apiUtils.getSortProperties(parameters), filterProps, Util.getPagingRequest((Paging)parameters.getPaging()));
        final List page = pagingResults.getPage();
        final HashMap<String, UserInfo> mapUserInfo = new HashMap<String, UserInfo>();
        AbstractList<RecordCategory> nodes = new AbstractList<RecordCategory>(){

            @Override
            public RecordCategory get(int index) {
                FileInfo info = (FileInfo)page.get(index);
                return FilePlanChildrenRelation.this.nodesModelFactory.createRecordCategory(info, parameters, mapUserInfo, true);
            }

            @Override
            public int size() {
                return page.size();
            }
        };
        FilePlan sourceEntity = null;
        if (parameters.includeSource()) {
            FileInfo info = this.fileFolderService.getFileInfo(parentNodeRef);
            sourceEntity = this.nodesModelFactory.createFilePlan(info, parameters, mapUserInfo, true);
        }
        return CollectionWithPagingInfo.asPaged((Paging)parameters.getPaging(), (Collection)nodes, (boolean)pagingResults.hasMoreItems(), (Integer)((Integer)pagingResults.getTotalResultCount().getFirst()), sourceEntity);
    }

    @WebApiDescription(title="Create one (or more) record categories as children of container identified by 'filePlanId'")
    public List<RecordCategory> create(String filePlanId, final List<RecordCategory> nodeInfos, final Parameters parameters) {
        RMParameterCheck.checkNotBlank("filePlanId", filePlanId);
        ParameterCheck.mandatory((String)"nodeInfos", nodeInfos);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        QName filePlanType = this.apiUtils.getFilePlanType();
        if (filePlanType == null) {
            throw new EntityNotFoundException(filePlanId);
        }
        final NodeRef parentNodeRef = this.apiUtils.lookupAndValidateNodeType(filePlanId, filePlanType);
        RetryingTransactionHelper.RetryingTransactionCallback<List<NodeRef>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<List<NodeRef>>(){

            public List<NodeRef> execute() {
                LinkedList<NodeRef> createdNodes = new LinkedList<NodeRef>();
                for (RecordCategory nodeInfo : nodeInfos) {
                    nodeInfo.setNodeType(FilePlanChildrenRelation.RECORD_CATEGORY_TYPE);
                    NodeRef newNodeRef = FilePlanChildrenRelation.this.apiUtils.createRMNode(parentNodeRef, nodeInfo, parameters);
                    createdNodes.add(newNodeRef);
                }
                return createdNodes;
            }
        };
        List createdNodes = (List)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false, true);
        ArrayList<RecordCategory> result = new ArrayList<RecordCategory>(nodeInfos.size());
        HashMap<String, UserInfo> mapUserInfo = new HashMap<String, UserInfo>();
        for (NodeRef newNodeRef : createdNodes) {
            FileInfo info = this.fileFolderService.getFileInfo(newNodeRef);
            result.add(this.nodesModelFactory.createRecordCategory(info, parameters, mapUserInfo, false));
        }
        return result;
    }

    public RecordCategory create(String entityResourceId, FormData formData, Parameters parameters, WithResponse withResponse) {
        throw new IntegrityException("Uploading records into file plan root is not allowed.", null);
    }
}

