/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.issue;

import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class RM3341Test
extends BaseRMTestCase {
    public void testCopyingContentsInHoldandTransfer() throws Exception {
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                NodeRef holdContainer = RM3341Test.this.filePlanService.getHoldContainer(RM3341Test.this.filePlan);
                TestCase.assertNotNull((Object)holdContainer);
                NodeRef transferContainer = RM3341Test.this.filePlanService.getTransferContainer(RM3341Test.this.filePlan);
                TestCase.assertNotNull((Object)transferContainer);
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)RM3341Test.this.permissionService.hasPermission(holdContainer, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)RM3341Test.this.permissionService.hasPermission(transferContainer, "Filing"));
                return null;
            }
        }, "admin");
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                NodeRef holdContainer = RM3341Test.this.filePlanService.getHoldContainer(RM3341Test.this.filePlan);
                TestCase.assertNotNull((Object)holdContainer);
                try {
                    RM3341Test.this.fileFolderService.create(holdContainer, "test file", ContentModel.TYPE_CONTENT);
                    TestCase.fail((String)"This should have thrown an exception");
                }
                catch (IntegrityException integrityException) {
                    // empty catch block
                }
                return null;
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                NodeRef transferContainer = RM3341Test.this.filePlanService.getTransferContainer(RM3341Test.this.filePlan);
                TestCase.assertNotNull((Object)transferContainer);
                try {
                    RM3341Test.this.fileFolderService.create(transferContainer, "test content", ContentModel.TYPE_CONTENT);
                    TestCase.fail((String)"This should have thrown an exception");
                }
                catch (IntegrityException integrityException) {
                    // empty catch block
                }
                return null;
            }
        });
    }
}

