/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.util;

import java.util.HashSet;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.util.Pair;

public class RMContainerCacheManager
implements RecordsManagementModel {
    private NodeService nodeService;
    private SimpleCache<Pair<StoreRef, String>, Set<NodeRef>> cache;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setCache(SimpleCache<Pair<StoreRef, String>, Set<NodeRef>> cache) {
        this.cache = cache;
    }

    public boolean isCached(StoreRef storeRef) {
        boolean isCached;
        Pair<StoreRef, String> key = this.getKey(storeRef);
        Set values = (Set)this.cache.get(key);
        boolean bl = isCached = values != null && !values.isEmpty();
        if (!isCached) {
            this.cache.remove(key);
        }
        return isCached;
    }

    public Set<NodeRef> get(StoreRef storeRef) {
        return (Set)this.cache.get(this.getKey(storeRef));
    }

    public void add(NodeRef nodeRef) {
        if (nodeRef != null && this.nodeService.hasAspect(nodeRef, ASPECT_RECORDS_MANAGEMENT_ROOT)) {
            Pair<StoreRef, String> key = this.getKey(nodeRef.getStoreRef());
            Set entries = this.cache.contains(key) ? (Set)this.cache.get(key) : new HashSet();
            if (!entries.contains(nodeRef)) {
                entries.add(nodeRef);
            }
            if (entries.size() > 0) {
                this.cache.put(key, entries);
            }
        }
    }

    public void remove(NodeRef nodeRef) {
        Pair<StoreRef, String> key;
        if (nodeRef != null && this.nodeService.hasAspect(nodeRef, ASPECT_RECORDS_MANAGEMENT_ROOT) && this.cache.contains(key = this.getKey(nodeRef.getStoreRef()))) {
            ((Set)this.cache.get(key)).remove(nodeRef);
            if (((Set)this.cache.get(key)).size() == 0) {
                this.cache.remove(key);
            }
        }
    }

    public void reset() {
        this.cache.clear();
    }

    private Pair<StoreRef, String> getKey(StoreRef storeRef) {
        return new Pair((Object)storeRef, (Object)ASPECT_RECORDS_MANAGEMENT_ROOT.toString());
    }
}

