/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.forms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.admin.RecordsManagementAdminService;
import org.alfresco.module.org_alfresco_module_rm.forms.RecordsManagementTypeFormFilter;
import org.alfresco.module.org_alfresco_module_rm.identifier.IdentifierService;
import org.alfresco.module.org_alfresco_module_rm.test.util.AlfMock;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.repo.forms.FieldDefinition;
import org.alfresco.repo.forms.Form;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;

public class RecordsManagementTypeFormFilterUnitTest
extends BaseUnitTest {
    private static final QName MY_CUSTOM_TYPE = AlfMock.generateQName("http://www.alfresco.org/model/recordsmanagement/1.0");
    @Mock
    private Form mockForm;
    @Mock
    private TypeDefinition mockTypeDefinition;
    @Mock(name="recordsManagementAdminService")
    private RecordsManagementAdminService mockRecordsManagementAdminService;
    @Spy
    @InjectMocks
    RecordsManagementTypeFormFilter typeFormFilter;

    @Test
    public void testAddCustomRMPropertiesNoneFound() {
        this.typeFormFilter.addCustomRMProperties(MY_CUSTOM_TYPE, this.mockForm);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockForm});
    }

    @Test
    public void testAfterGenerateNotCustomisable() {
        Mockito.when((Object)this.mockTypeDefinition.getName()).thenReturn((Object)MY_CUSTOM_TYPE);
        Mockito.when((Object)this.mockRecordsManagementAdminService.isCustomisable(MY_CUSTOM_TYPE)).thenReturn((Object)false);
        this.typeFormFilter.afterGenerate(this.mockTypeDefinition, null, null, this.mockForm, null);
        ((RecordsManagementTypeFormFilter)Mockito.verify((Object)this.typeFormFilter, (VerificationMode)Mockito.never())).addCustomRMProperties((QName)ArgumentMatchers.any(QName.class), (Form)ArgumentMatchers.any(Form.class));
    }

    @Test
    public void testAfterGenerateCustomisable() {
        Mockito.when((Object)this.mockTypeDefinition.getName()).thenReturn((Object)MY_CUSTOM_TYPE);
        Mockito.when((Object)this.mockRecordsManagementAdminService.isCustomisable(MY_CUSTOM_TYPE)).thenReturn((Object)true);
        this.typeFormFilter.afterGenerate(this.mockTypeDefinition, null, null, this.mockForm, null);
        ((RecordsManagementTypeFormFilter)Mockito.verify((Object)this.typeFormFilter, (VerificationMode)Mockito.times((int)1))).addCustomRMProperties((QName)ArgumentMatchers.any(QName.class), (Form)ArgumentMatchers.any(Form.class));
    }

    @Test
    public void testDefaultFormValues() {
        ArrayList<FieldDefinition> defs = new ArrayList<FieldDefinition>(3);
        FieldDefinition idDef = this.mockFieldDefinition("rma:identifier");
        defs.add(idDef);
        FieldDefinition vrDef = this.mockFieldDefinition("rma:vitalRecordIndicator");
        defs.add(vrDef);
        FieldDefinition rpDef = this.mockFieldDefinition("rma:reviewPeriod");
        defs.add(rpDef);
        Mockito.when((Object)this.mockForm.getFieldDefinitions()).thenReturn(defs);
        this.typeFormFilter.afterGenerate(this.mockTypeDefinition, null, null, this.mockForm, null);
        ((IdentifierService)Mockito.verify((Object)this.mockedIdentifierService)).generateIdentifier((QName)ArgumentMatchers.nullable(QName.class), (NodeRef)ArgumentMatchers.nullable(NodeRef.class));
        ((FieldDefinition)Mockito.verify((Object)idDef)).setDefaultValue((String)ArgumentMatchers.nullable(String.class));
        ((FieldDefinition)Mockito.verify((Object)vrDef)).setDefaultValue(Boolean.FALSE.toString());
        ((FieldDefinition)Mockito.verify((Object)rpDef)).setDefaultValue("none|0");
    }

    private FieldDefinition mockFieldDefinition(String name) {
        FieldDefinition def = (FieldDefinition)Mockito.mock(FieldDefinition.class);
        Mockito.when((Object)def.getName()).thenReturn((Object)name);
        return def;
    }

    @Test
    public void testAddCustomRMProperties() {
        Map<QName, PropertyDefinition> properties = this.mockPropertyDefintionMap(2);
        Mockito.when((Object)this.mockRecordsManagementAdminService.getCustomPropertyDefinitions(MY_CUSTOM_TYPE)).thenReturn(properties);
        this.typeFormFilter.addCustomRMProperties(MY_CUSTOM_TYPE, this.mockForm);
        ((Form)Mockito.verify((Object)this.mockForm, (VerificationMode)Mockito.times((int)1))).addFields((Collection)ArgumentMatchers.anyList());
    }

    private Map<QName, PropertyDefinition> mockPropertyDefintionMap(int size) {
        HashMap<QName, PropertyDefinition> properties = new HashMap<QName, PropertyDefinition>(size);
        for (int i = 0; i < size; ++i) {
            QName name = AlfMock.generateQName("http://www.alfresco.org/model/recordsmanagement/1.0");
            PropertyDefinition propDef = (PropertyDefinition)Mockito.mock(PropertyDefinition.class);
            Mockito.when((Object)propDef.getName()).thenReturn((Object)name);
            DataTypeDefinition mockDataTypeDefinition = (DataTypeDefinition)Mockito.mock(DataTypeDefinition.class);
            Mockito.when((Object)mockDataTypeDefinition.getName()).thenReturn((Object)DataTypeDefinition.TEXT);
            Mockito.when((Object)propDef.getDataType()).thenReturn((Object)mockDataTypeDefinition);
            properties.put(name, propDef);
        }
        return properties;
    }
}

