/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model.rma.type;

import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.BaseBehaviourBean;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.annotation.Behaviour;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ParameterCheck;

@BehaviourBean(defaultType="cm:cmobject")
public class CmObjectType
extends BaseBehaviourBean
implements NodeServicePolicies.OnMoveNodePolicy,
CopyServicePolicies.BeforeCopyPolicy {
    private static final String MOVE_BEHAVIOUR_NAME = "onMoveCmObjectType";
    private static final String COPY_BEHAVIOUR_NAME = "onCopyCmObjectType";

    public void disableMove() {
        this.getBehaviour(MOVE_BEHAVIOUR_NAME).disable();
    }

    public void enableMove() {
        this.getBehaviour(MOVE_BEHAVIOUR_NAME).enable();
    }

    public void disableCopy() {
        this.getBehaviour(COPY_BEHAVIOUR_NAME).disable();
    }

    public void enableCopy() {
        this.getBehaviour(COPY_BEHAVIOUR_NAME).enable();
    }

    @Behaviour(kind=BehaviourKind.CLASS, name="onMoveCmObjectType")
    public void onMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        ParameterCheck.mandatory((String)"oldChildAssocRef", (Object)oldChildAssocRef);
        ParameterCheck.mandatory((String)"newChildAssocRef", (Object)newChildAssocRef);
        NodeRef sourceParent = oldChildAssocRef.getParentRef();
        boolean isSourceParentFilePlanComponent = this.isFilePlanComponent(sourceParent);
        NodeRef targetParent = newChildAssocRef.getParentRef();
        boolean isTargetParentFilePlanComponent = this.isFilePlanComponent(targetParent);
        if (isSourceParentFilePlanComponent && isTargetParentFilePlanComponent) {
            return;
        }
        NodeRef object = oldChildAssocRef.getChildRef();
        QName objectType = this.nodeService.getType(object);
        if (!objectType.equals((Object)ContentModel.TYPE_CONTENT) && isTargetParentFilePlanComponent) {
            throw new AlfrescoRuntimeException("Only documents can be moved from a collaboration site into a RM site.");
        }
        if (isTargetParentFilePlanComponent && !this.isRecordFolder(targetParent)) {
            throw new AlfrescoRuntimeException("A document can only be moved into a folder in RM site.");
        }
    }

    @Behaviour(kind=BehaviourKind.CLASS, name="onCopyCmObjectType")
    public void beforeCopy(QName classRef, NodeRef sourceNodeRef, NodeRef targetNodeRef) {
        ParameterCheck.mandatory((String)"sourceNodeRef", (Object)sourceNodeRef);
        ParameterCheck.mandatory((String)"targetNodeRef", (Object)targetNodeRef);
        NodeRef sourceParentNodeRef = this.nodeService.getPrimaryParent(sourceNodeRef).getParentRef();
        boolean isSourceParentFilePlanComponent = this.isFilePlanComponent(sourceParentNodeRef);
        NodeRef targetParentNodeRef = this.nodeService.getPrimaryParent(targetNodeRef).getParentRef();
        boolean isTargetNodeParentFilePlanComponent = this.isFilePlanComponent(targetParentNodeRef);
        if (isSourceParentFilePlanComponent && isTargetNodeParentFilePlanComponent) {
            return;
        }
        if (!isSourceParentFilePlanComponent && isTargetNodeParentFilePlanComponent) {
            throw new AlfrescoRuntimeException("Nothing can be copied from a collaboration site into a RM site.");
        }
    }
}

