/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.recorded.version.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.recordableversion.RecordableVersionConfigService;
import org.alfresco.module.org_alfresco_module_rm.recorded.version.config.BaseRecordedVersionConfigTest;
import org.alfresco.module.org_alfresco_module_rm.script.slingshot.RecordedVersionConfigGet;
import org.alfresco.module.org_alfresco_module_rm.script.slingshot.Version;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionPolicy;
import org.alfresco.service.cmr.repository.NodeService;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mockito;
import org.springframework.extensions.webscripts.DeclarativeWebScript;

public class RecordedVersionConfigGetUnitTest
extends BaseRecordedVersionConfigTest {
    @InjectMocks
    protected RecordedVersionConfigGet webScript;

    protected DeclarativeWebScript getWebScript() {
        return this.webScript;
    }

    @Override
    protected String getWebScriptTemplate() {
        return "alfresco/templates/webscripts/org/alfresco/slingshot/documentlibrary/action/recorded-version-config.get.json.ftl";
    }

    @Test
    public void getRecordedVersionConfig() throws Exception {
        Map<String, String> parameters = this.buildParameters();
        ((NodeService)Mockito.doReturn(null).when((Object)this.mockedNodeService)).getProperty(this.testdoc, PROP_RECORDABLE_VERSION_POLICY);
        List<Version> versions = Arrays.asList(new Version(RecordableVersionPolicy.NONE.toString(), true), new Version(RecordableVersionPolicy.MAJOR_ONLY.toString(), false), new Version(RecordableVersionPolicy.ALL.toString(), false));
        ((RecordableVersionConfigService)Mockito.doReturn(versions).when((Object)this.mockedRecordableVersionConfigService)).getVersions(this.testdoc);
        JSONObject json = this.executeJSONWebScript(parameters);
        Assert.assertNotNull((Object)json);
        Assert.assertTrue((boolean)json.has("data"));
        JSONObject data = json.getJSONObject("data");
        Assert.assertNotNull((Object)data);
        Assert.assertTrue((boolean)data.has("recordableVersions"));
        JSONArray recordableVersions = data.getJSONArray("recordableVersions");
        Assert.assertNotNull((Object)recordableVersions);
        Assert.assertEquals((long)recordableVersions.length(), (long)3L);
        ArrayList<RecordableVersionPolicy> policies = new ArrayList<RecordableVersionPolicy>();
        boolean isSelected = false;
        int selectedOnce = 0;
        for (int i = 0; i < recordableVersions.length(); ++i) {
            JSONObject jsonObject = recordableVersions.getJSONObject(i);
            String policy = jsonObject.getString("policy");
            policies.add(RecordableVersionPolicy.valueOf((String)policy));
            boolean selected = Boolean.valueOf(jsonObject.getString("selected"));
            if (!selected) continue;
            isSelected = true;
            ++selectedOnce;
        }
        Assert.assertEquals(policies, Arrays.asList(RecordableVersionPolicy.values()));
        Assert.assertTrue((boolean)isSelected);
        Assert.assertEquals((long)selectedOnce, (long)1L);
        ((NodeService)Mockito.doReturn(null).when((Object)this.mockedNodeService)).getProperty(this.testdoc, PROP_RECORDABLE_VERSION_POLICY);
    }
}

