/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.issue;

import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.junit.Test;
import org.springframework.extensions.webscripts.GUID;

public class RM4804Test
extends BaseRMTestCase {
    NodeRef record;
    NodeRef transferFolder;

    @Test
    public void testTransferCompletedRecordOfTypePDF() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){

            @Override
            public void given() {
                NodeRef recordCategory = RM4804Test.this.filePlanService.createRecordCategory(RM4804Test.this.filePlan, GUID.generate());
                HashMap<QName, Object> dsProps = new HashMap<QName, Object>(3);
                dsProps.put(RecordsManagementModel.PROP_DISPOSITION_AUTHORITY, "disposition authority");
                dsProps.put(RecordsManagementModel.PROP_DISPOSITION_INSTRUCTIONS, GUID.generate());
                dsProps.put(RecordsManagementModel.PROP_RECORD_LEVEL_DISPOSITION, false);
                DispositionSchedule dispositionSchedule = RM4804Test.this.dispositionService.createDispositionSchedule(recordCategory, dsProps);
                HashMap<QName, String> dispositionActionCutOff = new HashMap<QName, String>(3);
                dispositionActionCutOff.put(RecordsManagementModel.PROP_DISPOSITION_ACTION_NAME, "cutoff");
                dispositionActionCutOff.put(RecordsManagementModel.PROP_DISPOSITION_DESCRIPTION, GUID.generate());
                dispositionActionCutOff.put(RecordsManagementModel.PROP_DISPOSITION_PERIOD, "immediately|0");
                RM4804Test.this.dispositionService.addDispositionActionDefinition(dispositionSchedule, dispositionActionCutOff);
                HashMap<QName, String> dispositionActionTransfer = new HashMap<QName, String>(4);
                dispositionActionTransfer.put(RecordsManagementModel.PROP_DISPOSITION_ACTION_NAME, "transfer");
                dispositionActionTransfer.put(RecordsManagementModel.PROP_DISPOSITION_DESCRIPTION, GUID.generate());
                dispositionActionTransfer.put(RecordsManagementModel.PROP_DISPOSITION_PERIOD, "immediately|0");
                dispositionActionTransfer.put(RecordsManagementModel.PROP_DISPOSITION_LOCATION, "");
                RM4804Test.this.dispositionService.addDispositionActionDefinition(dispositionSchedule, dispositionActionTransfer);
                NodeRef recordFolder = RM4804Test.this.recordFolderService.createRecordFolder(recordCategory, GUID.generate());
                HashMap<QName, Serializable> props = new HashMap<QName, Serializable>(1);
                props.put(ContentModel.PROP_TITLE, (Serializable)((Object)GUID.generate()));
                InputStream inputStream = IOUtils.toInputStream((String)GUID.generate());
                RM4804Test.this.record = RM4804Test.this.utils.createRecord(recordFolder, GUID.generate(), props, "application/pdf", inputStream);
                RM4804Test.this.utils.completeRecord(RM4804Test.this.record);
                RM4804Test.this.rmActionService.executeRecordsManagementAction(recordFolder, "cutoff", null);
                RM4804Test.this.transferFolder = (NodeRef)RM4804Test.this.rmActionService.executeRecordsManagementAction(recordFolder, "transfer").getValue();
            }

            @Override
            public void when() {
                RM4804Test.this.rmActionService.executeRecordsManagementAction(RM4804Test.this.transferFolder, "transferComplete");
            }

            @Override
            public void then() {
                TestCase.assertTrue((boolean)RM4804Test.this.nodeService.hasAspect(RM4804Test.this.record, RecordsManagementModel.ASPECT_TRANSFERRED));
            }
        });
    }
}

