/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.hold;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.springframework.extensions.webscripts.GUID;

public class RemoveActiveContentFromHoldTest
extends BaseRMTestCase {
    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    @Override
    protected boolean isUserTest() {
        return true;
    }

    public void testRemoveDocumentFromHold() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef hold;
            Integer before;

            @Override
            public void given() {
                this.hold = RemoveActiveContentFromHoldTest.this.holdService.createHold(RemoveActiveContentFromHoldTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
                RemoveActiveContentFromHoldTest.this.holdService.addToHold(this.hold, RemoveActiveContentFromHoldTest.this.dmDocument);
            }

            @Override
            public void when() {
                this.before = (Integer)RemoveActiveContentFromHoldTest.this.nodeService.getProperty(RemoveActiveContentFromHoldTest.this.dmFolder, RecordsManagementModel.PROP_HELD_CHILDREN_COUNT);
                RemoveActiveContentFromHoldTest.this.holdService.removeFromHold(this.hold, RemoveActiveContentFromHoldTest.this.dmDocument);
            }

            @Override
            public void then() {
                TestCase.assertFalse((boolean)RemoveActiveContentFromHoldTest.this.freezeService.isFrozen(RemoveActiveContentFromHoldTest.this.dmDocument));
                TestCase.assertFalse((boolean)RemoveActiveContentFromHoldTest.this.holdService.getHeld(this.hold).contains(RemoveActiveContentFromHoldTest.this.dmDocument));
                TestCase.assertFalse((boolean)RemoveActiveContentFromHoldTest.this.holdService.heldBy(RemoveActiveContentFromHoldTest.this.dmDocument, true).contains(this.hold));
                TestCase.assertTrue((this.before > (Integer)RemoveActiveContentFromHoldTest.this.nodeService.getProperty(RemoveActiveContentFromHoldTest.this.dmFolder, RecordsManagementModel.PROP_HELD_CHILDREN_COUNT) ? 1 : 0) != 0);
            }
        });
    }

    public void testRemoveDocumentFromASingleHold() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef hold;
            private NodeRef hold2;

            @Override
            public void given() {
                this.hold = RemoveActiveContentFromHoldTest.this.holdService.createHold(RemoveActiveContentFromHoldTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
                this.hold2 = RemoveActiveContentFromHoldTest.this.holdService.createHold(RemoveActiveContentFromHoldTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
                ArrayList<NodeRef> holds = new ArrayList<NodeRef>(2);
                holds.add(this.hold);
                holds.add(this.hold2);
                RemoveActiveContentFromHoldTest.this.holdService.addToHolds(holds, RemoveActiveContentFromHoldTest.this.dmDocument);
            }

            @Override
            public void when() {
                RemoveActiveContentFromHoldTest.this.holdService.removeFromHold(this.hold, RemoveActiveContentFromHoldTest.this.dmDocument);
            }

            @Override
            public void then() {
                TestCase.assertTrue((boolean)RemoveActiveContentFromHoldTest.this.freezeService.isFrozen(RemoveActiveContentFromHoldTest.this.dmDocument));
                TestCase.assertFalse((boolean)RemoveActiveContentFromHoldTest.this.holdService.heldBy(RemoveActiveContentFromHoldTest.this.dmDocument, true).contains(this.hold));
                TestCase.assertTrue((boolean)RemoveActiveContentFromHoldTest.this.holdService.heldBy(RemoveActiveContentFromHoldTest.this.dmDocument, true).contains(this.hold2));
            }
        });
    }

    public void testRemoveDocumentFromHoldFailsWithoutFilingPermission() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(AccessDeniedException.class){
            private NodeRef hold;

            @Override
            public void given() {
                this.hold = RemoveActiveContentFromHoldTest.this.holdService.createHold(RemoveActiveContentFromHoldTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
                RemoveActiveContentFromHoldTest.this.holdService.addToHold(this.hold, RemoveActiveContentFromHoldTest.this.dmDocument);
            }

            @Override
            public void when() {
                AuthenticationUtil.runAs(() -> {
                    RemoveActiveContentFromHoldTest.this.holdService.removeFromHold(this.hold, RemoveActiveContentFromHoldTest.this.dmDocument);
                    return null;
                }, (String)RemoveActiveContentFromHoldTest.this.recordsManagerName);
            }
        });
    }

    public void testRemoveDocumentFromHoldFailsWithoutRemoveHoldPermission() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(AccessDeniedException.class, this.powerUserName, false){
            private NodeRef hold;

            @Override
            public void given() {
                AuthenticationUtil.runAs(() -> {
                    this.hold = RemoveActiveContentFromHoldTest.this.holdService.createHold(RemoveActiveContentFromHoldTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
                    RemoveActiveContentFromHoldTest.this.holdService.addToHold(this.hold, RemoveActiveContentFromHoldTest.this.dmDocument);
                    return null;
                }, (String)AuthenticationUtil.getAdminUserName());
            }

            @Override
            public void when() {
                RemoveActiveContentFromHoldTest.this.holdService.removeFromHold(this.hold, RemoveActiveContentFromHoldTest.this.dmDocument);
            }
        });
    }
}

