/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.util;

import java.util.UUID;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class AlfMock {
    public static String generateText() {
        return UUID.randomUUID().toString();
    }

    public static QName generateQName() {
        return AlfMock.generateQName(GUID.generate());
    }

    public static QName generateQName(String uri) {
        return QName.createQName((String)uri, (String)GUID.generate());
    }

    public static NodeRef generateNodeRef(NodeService mockedNodeService) {
        return AlfMock.generateNodeRef(mockedNodeService, null);
    }

    public static NodeRef generateNodeRef(NodeService mockedNodeService, QName type) {
        return AlfMock.generateNodeRef(mockedNodeService, type, true);
    }

    public static NodeRef generateCmContent(NodeService mockedNodeService, String name) {
        NodeRef nodeRef = AlfMock.generateNodeRef(mockedNodeService, ContentModel.TYPE_CONTENT, true);
        ((NodeService)Mockito.doReturn((Object)name).when((Object)mockedNodeService)).getProperty(nodeRef, ContentModel.PROP_NAME);
        return nodeRef;
    }

    public static NodeRef generateNodeRef(NodeService mockedNodeService, QName type, boolean exists) {
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, GUID.generate());
        Mockito.lenient().when((Object)mockedNodeService.exists((NodeRef)ArgumentMatchers.eq((Object)nodeRef))).thenReturn((Object)exists);
        if (type != null) {
            Mockito.when((Object)mockedNodeService.getType((NodeRef)ArgumentMatchers.eq((Object)nodeRef))).thenReturn((Object)type);
        }
        return nodeRef;
    }
}

