/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.disposition;

import com.google.common.collect.ImmutableMap;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.module.org_alfresco_module_rm.test.util.bdt.BehaviourTest;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.extensions.webscripts.GUID;

public class MultipleSchedulesTest
extends BaseRMTestCase {
    protected static final String TEST_PREFIX = MultipleSchedulesTest.class.getName() + GUID.generate() + "_";
    protected static final String CATEGORY_A_NAME = TEST_PREFIX + "CategoryA";
    protected static final String FOLDER_A_NAME = TEST_PREFIX + "FolderA";
    protected static final String CATEGORY_B_NAME = TEST_PREFIX + "CategoryB";
    protected static final String FOLDER_B_NAME = TEST_PREFIX + "FolderB";
    protected static final String CATEGORY_C_NAME = TEST_PREFIX + "CategoryC";
    protected static final String FOLDER_C_NAME = TEST_PREFIX + "FolderC";
    protected static final String RECORD_NAME = TEST_PREFIX + "Record";
    private DispositionService internalDispositionService;
    private NodeRef categoryA;
    private NodeRef folderA;
    private NodeRef categoryB;
    private NodeRef folderB;
    private NodeRef categoryC;
    private NodeRef folderC;
    private NodeRef record;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        BehaviourTest.initBehaviourTests(this.retryingTransactionHelper);
        this.applicationContext = ApplicationContextHelper.getApplicationContext((String[])this.getConfigLocations());
        this.internalDispositionService = (DispositionService)this.applicationContext.getBean("dispositionService");
        this.record = null;
    }

    private void setUpFilePlan() {
        if (this.categoryA != null) {
            return;
        }
        this.categoryA = this.filePlanService.createRecordCategory(this.filePlan, CATEGORY_A_NAME);
        this.categoryB = this.filePlanService.createRecordCategory(this.filePlan, CATEGORY_B_NAME);
        this.categoryC = this.filePlanService.createRecordCategory(this.filePlan, CATEGORY_C_NAME);
        DispositionSchedule dispSchedA = this.utils.createBasicDispositionSchedule(this.categoryA, "instructions", "authority", true, false);
        ImmutableMap cutOffParamsA = ImmutableMap.of((Object)PROP_DISPOSITION_ACTION_NAME, (Object)"cutoff", (Object)PROP_DISPOSITION_DESCRIPTION, (Object)"description", (Object)PROP_DISPOSITION_PERIOD, (Object)"immediately|0");
        this.dispositionService.addDispositionActionDefinition(dispSchedA, (Map)cutOffParamsA);
        ImmutableMap destroyParamsA = ImmutableMap.of((Object)PROP_DISPOSITION_ACTION_NAME, (Object)"destroy", (Object)PROP_DISPOSITION_DESCRIPTION, (Object)"description", (Object)PROP_DISPOSITION_PERIOD, (Object)"immediately|0");
        this.dispositionService.addDispositionActionDefinition(dispSchedA, (Map)destroyParamsA);
        DispositionSchedule dispSchedB = this.utils.createBasicDispositionSchedule(this.categoryB, "instructions", "authority", true, false);
        ImmutableMap cutOffParamsB = ImmutableMap.of((Object)PROP_DISPOSITION_ACTION_NAME, (Object)"cutoff", (Object)PROP_DISPOSITION_DESCRIPTION, (Object)"description", (Object)PROP_DISPOSITION_PERIOD, (Object)"immediately|0");
        this.dispositionService.addDispositionActionDefinition(dispSchedB, (Map)cutOffParamsB);
        ImmutableMap destroyParamsB = ImmutableMap.of((Object)PROP_DISPOSITION_ACTION_NAME, (Object)"destroy", (Object)PROP_DISPOSITION_DESCRIPTION, (Object)"description", (Object)PROP_DISPOSITION_PERIOD, (Object)"week|1", (Object)PROP_DISPOSITION_PERIOD_PROPERTY, (Object)PROP_CUT_OFF_DATE);
        this.dispositionService.addDispositionActionDefinition(dispSchedB, (Map)destroyParamsB);
        DispositionSchedule dispSchedC = this.utils.createBasicDispositionSchedule(this.categoryC, "instructions", "authority", true, false);
        ImmutableMap cutOffParamsC = ImmutableMap.of((Object)PROP_DISPOSITION_ACTION_NAME, (Object)"cutoff", (Object)PROP_DISPOSITION_DESCRIPTION, (Object)"description", (Object)PROP_DISPOSITION_PERIOD, (Object)"immediately|0");
        this.dispositionService.addDispositionActionDefinition(dispSchedC, (Map)cutOffParamsC);
        ImmutableMap destroyParamsC = ImmutableMap.of((Object)PROP_DISPOSITION_ACTION_NAME, (Object)"destroy", (Object)PROP_DISPOSITION_DESCRIPTION, (Object)"description", (Object)PROP_DISPOSITION_PERIOD, (Object)"year|1", (Object)PROP_DISPOSITION_PERIOD_PROPERTY, (Object)PROP_CUT_OFF_DATE);
        this.dispositionService.addDispositionActionDefinition(dispSchedC, (Map)destroyParamsC);
        this.folderA = this.recordFolderService.createRecordFolder(this.categoryA, FOLDER_A_NAME);
        this.folderB = this.recordFolderService.createRecordFolder(this.categoryB, FOLDER_B_NAME);
        this.folderC = this.recordFolderService.createRecordFolder(this.categoryC, FOLDER_C_NAME);
    }

    public void testLinkedToLongerSchedule() {
        Calendar calendar = Calendar.getInstance();
        BehaviourTest.test().given(() -> {
            this.setUpFilePlan();
            this.record = this.fileFolderService.create(this.folderA, RECORD_NAME, ContentModel.TYPE_CONTENT).getNodeRef();
            this.recordService.link(this.record, this.folderB);
        }).when(() -> {
            this.dispositionService.cutoffDisposableItem(this.record);
            this.internalDispositionService.updateNextDispositionAction(this.record);
            calendar.setTime((Date)this.nodeService.getProperty(this.record, PROP_CUT_OFF_DATE));
            calendar.add(3, 1);
        }).then().expect(calendar.getTime()).from(() -> this.dispositionService.getNextDispositionAction(this.record).getAsOfDate()).because("Record should follow largest rentention schedule period, which is one week.");
    }

    public void testLinkedToShorterSchedule() {
        Calendar calendar = Calendar.getInstance();
        BehaviourTest.test().given(() -> {
            this.setUpFilePlan();
            this.record = this.fileFolderService.create(this.folderB, RECORD_NAME, ContentModel.TYPE_CONTENT).getNodeRef();
            this.recordService.link(this.record, this.folderA);
        }).when(() -> {
            this.dispositionService.cutoffDisposableItem(this.record);
            this.internalDispositionService.updateNextDispositionAction(this.record);
            calendar.setTime((Date)this.nodeService.getProperty(this.record, PROP_CUT_OFF_DATE));
            calendar.add(3, 1);
        }).then().expect(calendar.getTime()).from(() -> this.dispositionService.getNextDispositionAction(this.record).getAsOfDate()).because("Record should follow largest rentention schedule period, which is one week.");
    }

    public void testRecalculateDispositionWhenUnlinking() {
        BehaviourTest.test().given(() -> {
            this.setUpFilePlan();
            this.record = this.fileFolderService.create(this.folderA, RECORD_NAME, ContentModel.TYPE_CONTENT).getNodeRef();
            this.recordService.link(this.record, this.folderB);
            this.recordService.link(this.record, this.folderC);
            this.dispositionService.cutoffDisposableItem(this.record);
            this.internalDispositionService.updateNextDispositionAction(this.record);
        }).when(() -> this.recordService.unlink(this.record, this.folderB)).then().expect(false).from(() -> this.dispositionService.isNextDispositionActionEligible(this.record)).because("Destroy action shouldn't be available, as the record should follow disposition schedule from category C.");
    }
}

