/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionActionDefinition;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.script.DispositionAbstractBase;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class DispositionActionDefinitionPost
extends DispositionAbstractBase {
    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        DispositionSchedule schedule = this.parseRequestForSchedule(req);
        JSONObject json = null;
        DispositionActionDefinition actionDef = null;
        try {
            json = new JSONObject(new JSONTokener(req.getContent().getContent()));
            actionDef = this.createActionDefinition(json, schedule);
        }
        catch (IOException iox) {
            throw new WebScriptException(400, "Could not read content from req.", (Throwable)iox);
        }
        catch (JSONException je) {
            throw new WebScriptException(400, "Could not parse JSON from req.", (Throwable)je);
        }
        HashMap<String, Object> model = new HashMap<String, Object>(1);
        model.put("action", this.createActionDefModel(actionDef, req.getURL() + "/" + actionDef.getId()));
        return model;
    }

    protected DispositionActionDefinition createActionDefinition(JSONObject json, DispositionSchedule schedule) throws JSONException {
        if (!json.has("name")) {
            throw new WebScriptException(400, "Mandatory 'name' parameter was not provided in request body");
        }
        HashMap<QName, Serializable> props = new HashMap<QName, Serializable>(8);
        String name = json.getString("name");
        props.put(RecordsManagementModel.PROP_DISPOSITION_ACTION_NAME, (Serializable)((Object)name));
        if (json.has("description")) {
            props.put(RecordsManagementModel.PROP_DISPOSITION_DESCRIPTION, (Serializable)((Object)json.getString("description")));
        }
        if (json.has("period")) {
            props.put(RecordsManagementModel.PROP_DISPOSITION_PERIOD, (Serializable)((Object)json.getString("period")));
        }
        if (json.has("periodProperty")) {
            QName periodProperty = QName.createQName((String)json.getString("periodProperty"), (NamespacePrefixResolver)this.getNamespaceService());
            props.put(RecordsManagementModel.PROP_DISPOSITION_PERIOD_PROPERTY, (Serializable)periodProperty);
        }
        if (json.has("eligibleOnFirstCompleteEvent")) {
            props.put(RecordsManagementModel.PROP_DISPOSITION_EVENT_COMBINATION, (Serializable)((Object)(json.getBoolean("eligibleOnFirstCompleteEvent") ? "or" : "and")));
        }
        if (json.has("combineDispositionStepConditions")) {
            props.put(RecordsManagementModel.PROP_COMBINE_DISPOSITION_STEP_CONDITIONS, Boolean.valueOf(json.getBoolean("combineDispositionStepConditions")));
        }
        if (json.has("location")) {
            props.put(RecordsManagementModel.PROP_DISPOSITION_LOCATION, (Serializable)((Object)json.getString("location")));
        }
        if (json.has("events")) {
            JSONArray events = json.getJSONArray("events");
            ArrayList<String> eventsList = new ArrayList<String>(events.length());
            for (int x = 0; x < events.length(); ++x) {
                eventsList.add(events.getString(x));
            }
            props.put(RecordsManagementModel.PROP_DISPOSITION_EVENT, eventsList);
        }
        if (json.has("name") && "destroy".equals(json.getString("name"))) {
            if (json.has("ghostOnDestroy")) {
                props.put(RecordsManagementModel.PROP_DISPOSITION_ACTION_GHOST_ON_DESTROY, (Serializable)((Object)"ghost"));
            } else {
                props.put(RecordsManagementModel.PROP_DISPOSITION_ACTION_GHOST_ON_DESTROY, (Serializable)((Object)"delete"));
            }
        }
        return this.getDispositionService().addDispositionActionDefinition(schedule, props);
    }
}

