/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.webscript;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMWebScriptTestCase;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class ActionDefinitionsRestApiTest
extends BaseRMWebScriptTestCase {
    private static final String RM_ACTIONDEFINITIONS_URL = "/api/rm/rm-actiondefinitions";

    public void testRmGetActionDefinitions() throws IOException, JSONException {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(RM_ACTIONDEFINITIONS_URL), 200);
        String contentAsString = response.getContentAsString();
        ActionDefinitionsRestApiTest.assertNotNull((Object)contentAsString);
        JSONObject contentAsJson = new JSONObject(contentAsString);
        JSONArray data = contentAsJson.getJSONArray("data");
        ActionDefinitionsRestApiTest.assertNotNull((Object)data);
        List<String> dmActionDefinitions = this.getDmActionDefinitions();
        ArrayList<String> rmActionDefinitions = new ArrayList<String>();
        for (int i = 0; i < data.length(); ++i) {
            String name = data.getJSONObject(i).getString("name");
            ActionDefinitionsRestApiTest.assertNotNull((Object)name);
            rmActionDefinitions.add(name);
            ActionDefinitionsRestApiTest.assertFalse((boolean)dmActionDefinitions.contains(name));
        }
        ActionDefinitionsRestApiTest.assertTrue((boolean)rmActionDefinitions.containsAll(this.getRmActionDefinitions()));
    }

    private List<String> getRmActionDefinitions() {
        return Arrays.asList("reject", "fileTo", "declareRecord");
    }

    private List<String> getDmActionDefinitions() {
        return Arrays.asList("check-in", "check-out", "mail", "move", "transform");
    }
}

