/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.bulk.hold;

import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.bulk.BulkBaseService;
import org.alfresco.module.org_alfresco_module_rm.bulk.BulkCancellationRequest;
import org.alfresco.module.org_alfresco_module_rm.bulk.BulkMonitor;
import org.alfresco.module.org_alfresco_module_rm.bulk.BulkOperation;
import org.alfresco.module.org_alfresco_module_rm.bulk.BulkProgress;
import org.alfresco.module.org_alfresco_module_rm.bulk.BulkStatusUpdater;
import org.alfresco.module.org_alfresco_module_rm.bulk.hold.HoldBulkMonitor;
import org.alfresco.module.org_alfresco_module_rm.bulk.hold.HoldBulkProcessDetails;
import org.alfresco.module.org_alfresco_module_rm.bulk.hold.HoldBulkService;
import org.alfresco.module.org_alfresco_module_rm.bulk.hold.HoldBulkStatus;
import org.alfresco.module.org_alfresco_module_rm.bulk.hold.HoldBulkStatusAndProcessDetails;
import org.alfresco.module.org_alfresco_module_rm.bulk.hold.HoldBulkStatusUpdater;
import org.alfresco.module.org_alfresco_module_rm.capability.CapabilityService;
import org.alfresco.module.org_alfresco_module_rm.hold.HoldService;
import org.alfresco.repo.batch.BatchProcessWorkProvider;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.rest.api.search.model.Query;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rm.rest.api.model.HoldBulkOperationType;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class HoldBulkServiceImpl
extends BulkBaseService<HoldBulkStatus>
implements HoldBulkService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HoldBulkServiceImpl.class);
    private static final String MSG_ERR_ACCESS_DENIED = "permissions.err_access_denied";
    private HoldService holdService;
    private CapabilityService capabilityService;
    private PermissionService permissionService;
    private NodeService nodeService;

    @Override
    protected HoldBulkStatus getInitBulkStatus(String processId, long totalItems) {
        return new HoldBulkStatus(processId, null, null, 0L, 0L, totalItems, null, false, null);
    }

    @Override
    protected BulkStatusUpdater getBulkStatusUpdater() {
        return new HoldBulkStatusUpdater((HoldBulkMonitor)this.bulkMonitor);
    }

    @Override
    protected BatchProcessWorkProvider<NodeRef> getWorkProvider(BulkOperation bulkOperation, BulkStatusUpdater bulkStatusUpdater, BulkProgress bulkProgress) {
        return new AddToHoldWorkerProvider(bulkOperation, bulkStatusUpdater, bulkProgress, (HoldBulkMonitor)this.bulkMonitor);
    }

    @Override
    protected BatchProcessor.BatchProcessWorker<NodeRef> getWorkerProvider(NodeRef nodeRef, BulkOperation bulkOperation, BulkProgress bulkProgress) {
        try {
            HoldBulkOperationType holdBulkOperationType = HoldBulkOperationType.valueOf(bulkOperation.operationType().toUpperCase(Locale.ENGLISH));
            switch (holdBulkOperationType) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case ADD: 
            }
            return new AddToHoldWorkerBatch(nodeRef, bulkProgress);
        }
        catch (IllegalArgumentException e) {
            String errorMsg = "Unsupported action type when starting the bulk process: ";
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} {}", new Object[]{errorMsg, bulkOperation.operationType(), e});
            }
            throw new InvalidArgumentException(errorMsg + bulkOperation.operationType());
        }
    }

    @Override
    protected void checkPermissions(NodeRef holdRef, BulkOperation bulkOperation) {
        if (!this.holdService.isHold(holdRef)) {
            String holdName = (String)((Object)this.nodeService.getProperty(holdRef, ContentModel.PROP_NAME));
            throw new InvalidArgumentException(I18NUtil.getMessage((String)"rm.hold.not-hold", (Object[])new Object[]{holdName}), null);
        }
        if (HoldBulkOperationType.ADD.name().equals(bulkOperation.operationType()) && (!AccessStatus.ALLOWED.equals((Object)this.capabilityService.getCapabilityAccessState(holdRef, "AddToHold")) || this.permissionService.hasPermission(holdRef, "Filing") == AccessStatus.DENIED)) {
            throw new AccessDeniedException(I18NUtil.getMessage((String)MSG_ERR_ACCESS_DENIED));
        }
    }

    @Override
    public void cancelBulkOperation(NodeRef holdRef, String bulkStatusId, BulkCancellationRequest cancellationRequest) {
        BulkMonitor bulkMonitor = this.bulkMonitor;
        if (bulkMonitor instanceof HoldBulkMonitor) {
            HoldBulkMonitor holdBulkMonitor = (HoldBulkMonitor)bulkMonitor;
            HoldBulkStatusAndProcessDetails statusAndProcessDetails = holdBulkMonitor.getBulkStatusWithProcessDetails(holdRef.getId(), bulkStatusId);
            Optional.ofNullable(statusAndProcessDetails).map(HoldBulkStatusAndProcessDetails::holdBulkProcessDetails).map(HoldBulkProcessDetails::bulkOperation).ifPresent(bulkOperation -> {
                this.checkPermissions(holdRef, (BulkOperation)bulkOperation);
                holdBulkMonitor.cancelBulkOperation(bulkStatusId, cancellationRequest);
            });
        }
    }

    public void setHoldService(HoldService holdService) {
        this.holdService = holdService;
    }

    public void setCapabilityService(CapabilityService capabilityService) {
        this.capabilityService = capabilityService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    private class AddToHoldWorkerProvider
    implements BatchProcessWorkProvider<NodeRef> {
        private final HoldBulkMonitor holdBulkMonitor;
        private final Query searchQuery;
        private final String currentUser;
        private final BulkProgress bulkProgress;
        private final BulkStatusUpdater bulkStatusUpdater;

        public AddToHoldWorkerProvider(BulkOperation bulkOperation, BulkStatusUpdater bulkStatusUpdater, BulkProgress bulkProgress, HoldBulkMonitor holdBulkMonitor) {
            this.searchQuery = bulkOperation.searchQuery();
            this.bulkProgress = bulkProgress;
            this.bulkStatusUpdater = bulkStatusUpdater;
            this.holdBulkMonitor = holdBulkMonitor;
            this.currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        }

        public int getTotalEstimatedWorkSize() {
            return (int)this.bulkProgress.totalItems();
        }

        public long getTotalEstimatedWorkSizeLong() {
            return this.bulkProgress.totalItems();
        }

        public Collection<NodeRef> getNextWork() {
            AuthenticationUtil.pushAuthentication();
            AuthenticationUtil.setFullyAuthenticatedUser((String)this.currentUser);
            if (this.holdBulkMonitor.isCancelled(this.bulkProgress.processId())) {
                this.bulkProgress.cancelled().set(true);
                return Collections.emptyList();
            }
            SearchParameters searchParams = this.getNextPageParameters();
            ResultSet result = HoldBulkServiceImpl.this.searchService.query(searchParams);
            if (result.getNodeRefs().isEmpty()) {
                return Collections.emptyList();
            }
            AuthenticationUtil.popAuthentication();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Processing the next work for the batch processor, skipCount={}, size={}", (Object)searchParams.getSkipCount(), (Object)result.getNumberFound());
            }
            this.bulkProgress.currentNodeNumber().addAndGet(HoldBulkServiceImpl.this.batchSize);
            this.bulkStatusUpdater.update();
            return result.getNodeRefs();
        }

        private SearchParameters getNextPageParameters() {
            SearchParameters searchParams = new SearchParameters();
            HoldBulkServiceImpl.this.searchMapper.setDefaults(searchParams);
            HoldBulkServiceImpl.this.searchMapper.fromQuery(searchParams, this.searchQuery);
            searchParams.setSkipCount(this.bulkProgress.currentNodeNumber().get());
            searchParams.setMaxItems(HoldBulkServiceImpl.this.batchSize);
            searchParams.setLimit(HoldBulkServiceImpl.this.batchSize);
            searchParams.addSort("@" + String.valueOf(ContentModel.PROP_CREATED), true);
            return searchParams;
        }
    }

    private class AddToHoldWorkerBatch
    implements BatchProcessor.BatchProcessWorker<NodeRef> {
        private final NodeRef holdRef;
        private final String currentUser;
        private final BulkProgress bulkProgress;

        public AddToHoldWorkerBatch(NodeRef holdRef, BulkProgress bulkProgress) {
            this.holdRef = holdRef;
            this.bulkProgress = bulkProgress;
            this.currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        }

        public String getIdentifier(NodeRef entry) {
            return entry.getId();
        }

        public void beforeProcess() {
            AuthenticationUtil.pushAuthentication();
        }

        public void process(NodeRef entry) throws Throwable {
            if (!this.bulkProgress.cancelled().get()) {
                AuthenticationUtil.setFullyAuthenticatedUser((String)this.currentUser);
                HoldBulkServiceImpl.this.holdService.addToHold(this.holdRef, entry);
            }
        }

        public void afterProcess() {
            AuthenticationUtil.popAuthentication();
        }
    }
}

