/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.record;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.notification.RecordsManagementNotificationHelper;
import org.alfresco.module.org_alfresco_module_rm.record.RecordLinkRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.record.RecordServiceImpl;
import org.alfresco.module.org_alfresco_module_rm.test.util.AlfMock;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.QName;
import org.apache.commons.collections.CollectionUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;

public class RecordServiceImplUnitTest
extends BaseUnitTest {
    private NodeRef nonStandardFilePlanComponent;
    private NodeRef nonStandardFilePlan;
    private NodeRef dmNodeRef;
    private NodeRef unfiledRecordContainer;
    private NodeRef frozenRecordFolder;
    private NodeRef closedRecordFolder;
    private ChildAssociationRef parentAssoc;
    private final String recordId = "recordId";
    private final String documentOwner = "Bob";
    private final String originalName = "originalName";
    private final NodeRef originatingLocation = new NodeRef("workspace://SpacesStore/originalLocation");
    private final NodeRef link = new NodeRef("workspace://SpacesStore/linkLocation");
    @Mock
    private RenditionService mockedRenditionService;
    @Mock
    private RecordsManagementNotificationHelper mockedNotificationHelper;
    @Mock
    private ChildAssociationRef mockedChildAssoc;
    @Mock
    private ChildAssociationRef mockedLinkAssoc;
    @Mock
    private ChildAssociationRef mockedParentAssoc;
    private static QName TYPE_MY_FILE_PLAN = AlfMock.generateQName();
    private static QName ASPECT_FOR_FILE_PLAN = AlfMock.generateQName();
    @Spy
    @InjectMocks
    private RecordServiceImpl recordService;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.nonStandardFilePlanComponent = this.generateNodeRef(TYPE_RECORD_CATEGORY);
        this.nonStandardFilePlan = this.generateNodeRef(TYPE_MY_FILE_PLAN);
        this.dmNodeRef = this.generateNodeRef(TYPE_CONTENT);
        this.unfiledRecordContainer = this.generateNodeRef(TYPE_UNFILED_RECORD_CONTAINER);
        this.frozenRecordFolder = this.generateNodeRef(TYPE_RECORD_FOLDER);
        this.closedRecordFolder = this.generateNodeRef(TYPE_RECORD_FOLDER);
        this.parentAssoc = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        Mockito.when((Object)this.mockedNodeService.getProperty(this.nonStandardFilePlanComponent, PROP_ROOT_NODEREF)).thenReturn((Object)this.nonStandardFilePlan);
        Mockito.when((Object)this.mockedDictionaryService.getAllAspects()).thenReturn((Object)CollectionUtils.EMPTY_COLLECTION);
        Mockito.when((Object)this.recordService.getBehaviour((String)ArgumentMatchers.any(String.class))).thenReturn((Object)((Behaviour)Mockito.mock(Behaviour.class)));
    }

    @Test
    public void testRegisterRecordMetadataAspect() {
        Map map = this.recordService.getRecordMetadataAspectsMap();
        Assert.assertTrue((boolean)map.isEmpty());
        this.recordService.registerRecordMetadataAspect(ASPECT_FOR_FILE_PLAN, TYPE_FILE_PLAN);
        map = this.recordService.getRecordMetadataAspectsMap();
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertTrue((boolean)map.containsKey(ASPECT_FOR_FILE_PLAN));
        Set types = (Set)map.get(ASPECT_FOR_FILE_PLAN);
        Assert.assertNotNull((Object)types);
        Assert.assertEquals((long)1L, (long)types.size());
        Assert.assertTrue((boolean)types.contains(TYPE_FILE_PLAN));
    }

    @Test
    public void linkNonRecord() {
        NodeRef nonRecord = this.generateNodeRef(TYPE_CONTENT);
        NodeRef recordFolder = this.generateRecordFolder();
        this.exception.expect(RecordLinkRuntimeException.class);
        this.recordService.link(nonRecord, recordFolder);
    }

    @Test
    public void linkNonRecordFolder() {
        NodeRef record = this.generateRecord();
        NodeRef nonRecordFolder = this.generateNodeRef(TYPE_FOLDER);
        this.exception.expect(RecordLinkRuntimeException.class);
        this.recordService.link(record, nonRecordFolder);
    }

    @Test
    public void linkRecordToRecordFolderFailsIfAlreadyAChild() {
        NodeRef record = this.generateRecord();
        NodeRef recordFolder = this.generateRecordFolder();
        this.makeChildrenOf(recordFolder, record);
        this.exception.expect(RecordLinkRuntimeException.class);
        this.recordService.link(record, recordFolder);
    }

    @Test
    public void linkRecordToRecordFolder() {
        NodeRef record = this.generateRecord();
        NodeRef recordFolder = this.generateRecordFolder();
        this.makeChildrenOf(this.generateRecordFolder(), record);
        String name = AlfMock.generateText();
        ((NodeService)Mockito.doReturn((Object)name).when((Object)this.mockedNodeService)).getProperty(record, PROP_NAME);
        this.recordService.link(record, recordFolder);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).addChild(recordFolder, record, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name));
    }

    @Test
    public void linkNoSourceDisposition() {
        NodeRef record = this.generateRecord();
        NodeRef recordFolder = this.generateRecordFolder();
        this.makeChildrenOf(this.generateRecordFolder(), record);
        String name = AlfMock.generateText();
        ((NodeService)Mockito.doReturn((Object)name).when((Object)this.mockedNodeService)).getProperty(record, PROP_NAME);
        Mockito.when((Object)this.mockedDispositionService.getDispositionSchedule(record)).thenReturn(null);
        this.recordService.link(record, recordFolder);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).addChild(recordFolder, record, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name));
    }

    @Test
    public void linkNoTargetDisposition() {
        NodeRef record = this.generateRecord();
        NodeRef recordFolder = this.generateRecordFolder();
        this.makeChildrenOf(this.generateRecordFolder(), record);
        String name = AlfMock.generateText();
        ((NodeService)Mockito.doReturn((Object)name).when((Object)this.mockedNodeService)).getProperty(record, PROP_NAME);
        Mockito.when((Object)this.mockedDispositionService.getDispositionSchedule(record)).thenReturn((Object)((DispositionSchedule)Mockito.mock(DispositionSchedule.class)));
        Mockito.when((Object)this.mockedDispositionService.getDispositionSchedule(record)).thenReturn(null);
        this.recordService.link(record, recordFolder);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).addChild(recordFolder, record, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name));
    }

    @Test
    public void linkIncompatibleDispositions() {
        NodeRef record = this.generateRecord();
        NodeRef recordFolder = this.generateRecordFolder();
        this.makeChildrenOf(this.generateRecordFolder(), record);
        String name = AlfMock.generateText();
        ((NodeService)Mockito.doReturn((Object)name).when((Object)this.mockedNodeService)).getProperty(record, PROP_NAME);
        DispositionSchedule recordDispositionSchedule = (DispositionSchedule)Mockito.mock(DispositionSchedule.class);
        Mockito.when((Object)recordDispositionSchedule.isRecordLevelDisposition()).thenReturn((Object)true);
        Mockito.when((Object)this.mockedDispositionService.getOriginDispositionSchedule(record)).thenReturn((Object)recordDispositionSchedule);
        DispositionSchedule recordFolderDispositionSchedule = (DispositionSchedule)Mockito.mock(DispositionSchedule.class);
        Mockito.when((Object)recordFolderDispositionSchedule.isRecordLevelDisposition()).thenReturn((Object)false);
        Mockito.when((Object)this.mockedDispositionService.getDispositionSchedule(recordFolder)).thenReturn((Object)recordFolderDispositionSchedule);
        this.exception.expect(RecordLinkRuntimeException.class);
        this.recordService.link(record, recordFolder);
    }

    @Test
    public void linkCompatibleDispositions() {
        NodeRef record = this.generateRecord();
        NodeRef recordFolder = this.generateRecordFolder();
        this.makeChildrenOf(this.generateRecordFolder(), record);
        String name = AlfMock.generateText();
        ((NodeService)Mockito.doReturn((Object)name).when((Object)this.mockedNodeService)).getProperty(record, PROP_NAME);
        DispositionSchedule recordDispositionSchedule = (DispositionSchedule)Mockito.mock(DispositionSchedule.class);
        Mockito.when((Object)recordDispositionSchedule.isRecordLevelDisposition()).thenReturn((Object)true);
        Mockito.when((Object)this.mockedDispositionService.getDispositionSchedule(record)).thenReturn((Object)recordDispositionSchedule);
        DispositionSchedule recordFolderDispositionSchedule = (DispositionSchedule)Mockito.mock(DispositionSchedule.class);
        Mockito.when((Object)recordFolderDispositionSchedule.isRecordLevelDisposition()).thenReturn((Object)true);
        Mockito.when((Object)this.mockedDispositionService.getDispositionSchedule(recordFolder)).thenReturn((Object)recordFolderDispositionSchedule);
        this.recordService.link(record, recordFolder);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).addChild(recordFolder, record, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name));
    }

    @Test
    public void unlinkNonRecord() {
        NodeRef nonRecord = this.generateNodeRef(TYPE_CONTENT);
        NodeRef recordFolder = this.generateRecordFolder();
        this.exception.expect(RecordLinkRuntimeException.class);
        this.recordService.unlink(nonRecord, recordFolder);
    }

    @Test
    public void unlinkNonRecordFolder() {
        NodeRef record = this.generateRecord();
        NodeRef nonRecordFolder = this.generateNodeRef(TYPE_FOLDER);
        this.exception.expect(RecordLinkRuntimeException.class);
        this.recordService.unlink(record, nonRecordFolder);
    }

    @Test
    public void unlinkRecordFromPrimaryRecordFolder() {
        NodeRef record = this.generateRecord();
        NodeRef recordFolder = this.generateRecordFolder();
        this.makePrimaryParentOf(record, recordFolder);
        this.exception.expect(RecordLinkRuntimeException.class);
        this.recordService.unlink(record, recordFolder);
    }

    @Test
    public void unlinkRecordFromRecordFolder() {
        NodeRef record = this.generateRecord();
        NodeRef recordFolder = this.generateRecordFolder();
        this.makePrimaryParentOf(record, this.generateRecordFolder());
        this.recordService.unlink(record, recordFolder);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).removeChild(recordFolder, record);
    }

    @Test
    public void onCreateChildAssociationNewRecord() {
        NodeRef nodeRef = this.generateCmContent("test.txt");
        ChildAssociationRef assoc = this.generateChildAssociationRef(this.generateNodeRef(), nodeRef);
        ((RecordServiceImpl)Mockito.doNothing().when((Object)this.recordService)).file(nodeRef);
        Mockito.when((Object)this.mockedNodeService.hasAspect(nodeRef, ContentModel.ASPECT_NO_CONTENT)).thenReturn((Object)false);
        Set values = (Set)Mockito.mock(HashSet.class);
        Mockito.when((Object)this.mockedTransactionalResourceHelper.getSet((Object)"newRecords")).thenReturn((Object)values);
        this.recordService.onCreateChildAssociation(assoc, true);
        ((Set)Mockito.verify((Object)values, (VerificationMode)Mockito.times((int)1))).add(nodeRef);
    }

    @Test
    public void onCreateChildAssociationExistingRecord() {
        NodeRef nodeRef = this.generateCmContent("test.txt");
        ChildAssociationRef assoc = this.generateChildAssociationRef(this.generateNodeRef(), nodeRef);
        ((RecordServiceImpl)Mockito.doNothing().when((Object)this.recordService)).file(nodeRef);
        Mockito.when((Object)this.mockedNodeService.hasAspect(nodeRef, ContentModel.ASPECT_NO_CONTENT)).thenReturn((Object)false);
        Set values = (Set)Mockito.mock(HashSet.class);
        Mockito.when((Object)this.mockedTransactionalResourceHelper.getSet((Object)"newRecords")).thenReturn((Object)values);
        this.recordService.onCreateChildAssociation(assoc, false);
        ((Set)Mockito.verify((Object)values, (VerificationMode)Mockito.never())).add(nodeRef);
    }

    @Test
    public void createRecordIntoUnfiledRecordContainer() {
        this.mocksForRecordCreation();
        this.recordService.createRecord(this.filePlan, this.dmNodeRef);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).moveNode(this.dmNodeRef, this.unfiledRecordContainer, ContentModel.ASSOC_CONTAINS, this.parentAssoc.getQName());
    }

    @Test(expected=AlfrescoRuntimeException.class)
    public void createRecordWhenUnfiledRecordContainerIsNull() {
        this.mocksForRecordCreation();
        Mockito.when((Object)this.mockedFilePlanService.getUnfiledContainer(this.filePlan)).thenReturn(null);
        this.recordService.createRecord(this.filePlan, this.dmNodeRef);
    }

    @Test
    public void createRecordIntoSpecifiedUnfiledRecordContainer() {
        this.mocksForRecordCreation();
        this.recordService.createRecord(this.filePlan, this.dmNodeRef, this.unfiledRecordContainer);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).moveNode(this.dmNodeRef, this.unfiledRecordContainer, ContentModel.ASSOC_CONTAINS, this.parentAssoc.getQName());
    }

    @Test
    public void createRecordIntoSpecifiedRecordFolder() {
        this.mocksForRecordCreation();
        this.recordService.createRecord(this.filePlan, this.dmNodeRef, this.recordFolder);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).moveNode(this.dmNodeRef, this.recordFolder, ContentModel.ASSOC_CONTAINS, this.parentAssoc.getQName());
    }

    @Test(expected=AlfrescoRuntimeException.class)
    public void createRecordIntoInvalidRecordFolder() {
        this.mocksForRecordCreation();
        NodeRef recordCategory = this.generateNodeRef(TYPE_RECORD_CATEGORY);
        this.recordService.createRecord(this.filePlan, this.dmNodeRef, recordCategory);
    }

    @Test(expected=AccessDeniedException.class)
    public void createRecordIntoSpecifiedRecordFolderWithoutFilePermission() {
        this.mocksForRecordCreation();
        Mockito.when((Object)this.mockedExtendedPermissionService.hasPermission(this.recordFolder, "Filing")).thenReturn((Object)AccessStatus.DENIED);
        this.recordService.createRecord(this.filePlan, this.dmNodeRef, this.recordFolder);
    }

    @Test(expected=IntegrityException.class)
    public void createRecordIntoRecordFolderInHold() {
        this.mocksForRecordCreation();
        this.recordService.createRecord(this.filePlan, this.dmNodeRef, this.frozenRecordFolder);
    }

    @Test(expected=IntegrityException.class)
    public void createRecordIntoClosedRecordFolder() {
        this.mocksForRecordCreation();
        this.recordService.createRecord(this.filePlan, this.dmNodeRef, this.closedRecordFolder);
    }

    private void mocksForRecordCreation() {
        Mockito.when((Object)this.mockedNodeService.getPrimaryParent(this.dmNodeRef)).thenReturn((Object)this.parentAssoc);
        Mockito.when((Object)this.parentAssoc.getQName()).thenReturn((Object)AlfMock.generateQName());
        Mockito.when((Object)this.mockedExtendedPermissionService.hasPermission(this.dmNodeRef, "Write")).thenReturn((Object)AccessStatus.ALLOWED);
        Mockito.when((Object)this.mockedDictionaryService.isSubClass(this.mockedNodeService.getType(this.dmNodeRef), ContentModel.TYPE_CONTENT)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedFilePlanService.isFilePlan(this.nonStandardFilePlan)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedFreezeService.isFrozen(this.recordFolder)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedFreezeService.isFrozen(this.frozenRecordFolder)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedNodeService.getProperty(this.closedRecordFolder, PROP_IS_CLOSED)).thenReturn((Object)true);
        ((RecordServiceImpl)Mockito.doNothing().when((Object)this.recordService)).invokeBeforeRecordDeclaration(this.dmNodeRef);
        ((RecordServiceImpl)Mockito.doNothing().when((Object)this.recordService)).invokeOnRecordDeclaration(this.dmNodeRef);
        Mockito.when((Object)this.mockedFilePlanService.getUnfiledContainer(this.filePlan)).thenReturn((Object)this.unfiledRecordContainer);
        Mockito.when((Object)this.mockedVersionService.getVersionHistory(this.dmNodeRef)).thenReturn(null);
    }

    private void setUpReject(Map mockProperties) {
        Mockito.when((Object)this.mockedNodeService.getProperties(this.dmNodeRef)).thenReturn((Object)mockProperties);
        Mockito.when((Object)this.mockedVersionService.getVersionHistory(this.dmNodeRef)).thenReturn(null);
        Mockito.when(mockProperties.get(PROP_IDENTIFIER)).thenReturn((Object)"recordId");
        Mockito.when(mockProperties.get(PROP_ORIGIONAL_NAME)).thenReturn((Object)"originalName");
        Mockito.when(mockProperties.get(PROP_RECORD_ORIGINATING_LOCATION)).thenReturn((Object)this.originatingLocation);
        ArrayList<ChildAssociationRef> assocs = new ArrayList<ChildAssociationRef>();
        assocs.add(this.mockedChildAssoc);
        assocs.add(this.mockedLinkAssoc);
        Mockito.when((Object)this.mockedNodeService.getParentAssocs(this.dmNodeRef)).thenReturn(assocs);
        Mockito.when((Object)this.mockedChildAssoc.getParentRef()).thenReturn((Object)this.originatingLocation);
        Mockito.when((Object)this.mockedLinkAssoc.getParentRef()).thenReturn((Object)this.link);
        Mockito.when((Object)this.mockedNodeService.getType(this.link)).thenReturn((Object)TYPE_RECORD_FOLDER);
        Mockito.when((Object)this.mockedNodeService.getPrimaryParent(this.dmNodeRef)).thenReturn((Object)this.mockedParentAssoc);
        Mockito.when((Object)this.mockedParentAssoc.getQName()).thenReturn((Object)ContentModel.TYPE_CATEGORY);
        ((RecordServiceImpl)Mockito.doNothing().when((Object)this.recordService)).invokeBeforeRecordRejection(this.dmNodeRef);
        ((RecordServiceImpl)Mockito.doNothing().when((Object)this.recordService)).invokeOnRecordRejection(this.dmNodeRef);
    }

    @Test
    public void testRejectRecord() {
        Map mockProperties = (Map)Mockito.mock(HashMap.class);
        this.setUpReject(mockProperties);
        Mockito.when(mockProperties.get(PROP_RECORD_ORIGINATING_USER_ID)).thenReturn((Object)"Bob");
        this.recordService.rejectRecord(this.dmNodeRef, "Just because..");
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).removeChildAssociation(this.mockedChildAssoc);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).removeChildAssociation(this.mockedLinkAssoc);
    }

    @Test(expected=AlfrescoRuntimeException.class)
    public void testRejectRecordThrowsErrorWithoutDocumentOwner() {
        Map mockProperties = (Map)Mockito.mock(HashMap.class);
        this.setUpReject(mockProperties);
        Mockito.when(mockProperties.get(PROP_RECORD_ORIGINATING_USER_ID)).thenReturn(null);
        this.recordService.rejectRecord(this.dmNodeRef, "Just because..");
    }
}

