/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.capability.declarative.condition;

import org.alfresco.module.org_alfresco_module_rm.capability.declarative.AbstractCapabilityCondition;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionActionDefinition;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.service.cmr.repository.NodeRef;

public class MayBeScheduledCapabilityCondition
extends AbstractCapabilityCondition {
    private String dispositionAction;

    public void setDispositionAction(String dispositionAction) {
        this.dispositionAction = dispositionAction;
    }

    @Override
    public boolean evaluateImpl(NodeRef nodeRef) {
        boolean result = false;
        DispositionSchedule dispositionSchedule = this.dispositionService.getDispositionSchedule(nodeRef);
        if (dispositionSchedule != null && this.checkDispositionLevel(nodeRef, dispositionSchedule)) {
            for (DispositionActionDefinition dispositionActionDefinition : dispositionSchedule.getDispositionActionDefinitions()) {
                if (!dispositionActionDefinition.getName().equals(this.dispositionAction)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean checkDispositionLevel(NodeRef nodeRef, DispositionSchedule dispositionSchedule) {
        boolean isRecordLevelDisposition = dispositionSchedule.isRecordLevelDisposition();
        return this.recordService.isRecord(nodeRef) && isRecordLevelDisposition || this.recordFolderService.isRecordFolder(nodeRef) && !isRecordLevelDisposition;
    }
}

