/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.patch.v21;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.patch.v21.RMv21PatchComponent;
import org.alfresco.module.org_alfresco_module_rm.role.FilePlanRoleService;
import org.alfresco.module.org_alfresco_module_rm.role.Role;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.springframework.beans.factory.BeanNameAware;

public class RMv21RolesPatch
extends RMv21PatchComponent
implements BeanNameAware {
    private FilePlanService filePlanService;
    private FilePlanRoleService filePlanRoleService;
    private AuthorityService authorityService;

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setFilePlanRoleService(FilePlanRoleService filePlanRoleService) {
        this.filePlanRoleService = filePlanRoleService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    @Override
    protected void executePatch() {
        Set<NodeRef> filePlans = this.filePlanService.getFilePlans();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(" ... updating " + filePlans.size() + " file plans");
        }
        for (NodeRef filePlan : filePlans) {
            boolean parentAddedToZone = false;
            Set<Role> roles = this.filePlanRoleService.getRoles(filePlan);
            for (Role role : roles) {
                String roleGroupName = role.getRoleGroupName();
                if (this.authorityService.getAuthorityZones(roleGroupName).contains("APP.RM")) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(" ... updating " + roleGroupName + " in file plan " + filePlan.toString());
                }
                this.addAuthorityToZone(roleGroupName);
                if (parentAddedToZone) continue;
                String allRolesGroupName = this.filePlanRoleService.getAllRolesContainerGroup(filePlan);
                this.addAuthorityToZone(allRolesGroupName);
                parentAddedToZone = true;
            }
        }
    }

    private void addAuthorityToZone(String roleGroupName) {
        this.authorityService.addAuthorityToZones(roleGroupName, new HashSet<String>(Arrays.asList("APP.RM")));
    }
}

