/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.capability;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.capability.CapabilityService;
import org.alfresco.module.org_alfresco_module_rm.capability.Group;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.util.ParameterCheck;

public class CapabilityServiceImpl
implements CapabilityService {
    private Map<String, Capability> capabilities = new HashMap<String, Capability>(57);
    private Map<String, Group> groups = new HashMap<String, Group>(13);

    @Override
    public Capability getCapability(String name) {
        ParameterCheck.mandatoryString((String)"name", (String)name);
        return this.capabilities.get(name);
    }

    @Override
    public void registerCapability(Capability capability) {
        ParameterCheck.mandatory((String)"capability", (Object)capability);
        this.capabilities.put(capability.getName(), capability);
    }

    @Override
    public Set<Capability> getCapabilities() {
        return this.getCapabilities(true);
    }

    @Override
    public Set<Capability> getCapabilities(boolean includePrivate) {
        HashSet<Capability> result = null;
        if (includePrivate) {
            result = new HashSet<Capability>(this.capabilities.values());
        } else {
            result = new HashSet(this.capabilities.size());
            for (Capability capability : this.capabilities.values()) {
                if (capability.isPrivate()) continue;
                result.add(capability);
            }
        }
        return result;
    }

    @Override
    public Map<Capability, AccessStatus> getCapabilitiesAccessState(NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        return this.getCapabilitiesAccessState(nodeRef, false);
    }

    @Override
    public Map<Capability, AccessStatus> getCapabilitiesAccessState(NodeRef nodeRef, boolean includePrivate) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        Set<Capability> listOfCapabilites = this.getCapabilities(includePrivate);
        HashMap<Capability, AccessStatus> answer = new HashMap<Capability, AccessStatus>();
        for (Capability capability : listOfCapabilites) {
            AccessStatus status;
            if (answer.put(capability, status = capability.hasPermission(nodeRef)) == null) continue;
            throw new IllegalStateException();
        }
        return answer;
    }

    @Override
    public Map<Capability, AccessStatus> getCapabilitiesAccessState(NodeRef nodeRef, List<String> capabilityNames) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        ParameterCheck.mandatory((String)"capabilityNames", capabilityNames);
        HashMap<Capability, AccessStatus> answer = new HashMap<Capability, AccessStatus>();
        for (String capabilityName : capabilityNames) {
            AccessStatus status;
            Capability capability = this.capabilities.get(capabilityName);
            if (capability == null || answer.put(capability, status = capability.hasPermission(nodeRef)) == null) continue;
            throw new IllegalStateException();
        }
        return answer;
    }

    @Override
    public AccessStatus getCapabilityAccessState(NodeRef nodeRef, String capabilityName) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        ParameterCheck.mandatory((String)"capabilityName", (Object)capabilityName);
        AccessStatus result = AccessStatus.UNDETERMINED;
        Capability capability = this.getCapability(capabilityName);
        if (capability != null) {
            List<String> list = Collections.singletonList(capabilityName);
            Map<Capability, AccessStatus> map = this.getCapabilitiesAccessState(nodeRef, list);
            result = map.get(capability);
        }
        return result;
    }

    @Override
    public List<Group> getGroups() {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (Map.Entry<String, Group> entry : this.groups.entrySet()) {
            groups.add(entry.getValue());
        }
        Collections.sort(groups, new Comparator<Group>(){

            @Override
            public int compare(Group g1, Group g2) {
                return g1.getIndex() - g2.getIndex();
            }
        });
        return groups;
    }

    @Override
    public List<Capability> getCapabilitiesByGroupId(String groupId) {
        ParameterCheck.mandatoryString((String)"groupId", (String)groupId);
        String id = this.groups.get(groupId).getId();
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        for (Capability capability : this.getCapabilities()) {
            Group group = capability.getGroup();
            if (group == null || !group.getId().equalsIgnoreCase(id)) continue;
            capabilities.add(capability);
        }
        Collections.sort(capabilities, new Comparator<Capability>(){

            @Override
            public int compare(Capability c1, Capability c2) {
                return c1.getIndex() - c2.getIndex();
            }
        });
        return capabilities;
    }

    @Override
    public List<Capability> getCapabilitiesByGroup(Group group) {
        ParameterCheck.mandatory((String)"group", (Object)group);
        return this.getCapabilitiesByGroupId(group.getId());
    }

    @Override
    public Group getGroup(String groupId) {
        ParameterCheck.mandatoryString((String)"groupId", (String)groupId);
        return this.groups.get(groupId);
    }

    @Override
    public void addGroup(Group group) {
        ParameterCheck.mandatory((String)"group", (Object)group);
        this.groups.put(group.getId(), group);
    }

    @Override
    public void removeGroup(Group group) {
        ParameterCheck.mandatory((String)"group", (Object)group);
        this.groups.remove(group.getId());
    }

    @Override
    public boolean hasCapability(NodeRef nodeRef, String capabilityName) {
        AccessStatus accessStatus;
        Capability capability = this.getCapability(capabilityName);
        return capability != null && (accessStatus = this.getCapabilityAccessState(nodeRef, capabilityName)).equals((Object)AccessStatus.ALLOWED);
    }
}

