/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementActionService;
import org.alfresco.module.org_alfresco_module_rm.audit.RecordsManagementAuditService;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.freeze.FreezeService;
import org.alfresco.module.org_alfresco_module_rm.hold.HoldService;
import org.alfresco.module.org_alfresco_module_rm.identifier.IdentifierService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.model.rma.type.CmObjectType;
import org.alfresco.module.org_alfresco_module_rm.model.security.ModelSecurityService;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.module.org_alfresco_module_rm.recordableversion.RecordableVersionConfigService;
import org.alfresco.module.org_alfresco_module_rm.recordfolder.RecordFolderService;
import org.alfresco.module.org_alfresco_module_rm.report.ReportService;
import org.alfresco.module.org_alfresco_module_rm.role.FilePlanRoleService;
import org.alfresco.module.org_alfresco_module_rm.security.ExtendedSecurityService;
import org.alfresco.module.org_alfresco_module_rm.test.util.AlfMock;
import org.alfresco.module.org_alfresco_module_rm.test.util.MockAuthenticationUtilHelper;
import org.alfresco.module.org_alfresco_module_rm.util.AlfrescoTransactionSupport;
import org.alfresco.module.org_alfresco_module_rm.util.AuthenticationUtil;
import org.alfresco.module.org_alfresco_module_rm.util.NodeTypeUtility;
import org.alfresco.module.org_alfresco_module_rm.util.TransactionalResourceHelper;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionService;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.permissions.impl.ExtendedPermissionService;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.GUID;
import org.alfresco.util.collections.CollectionUtils;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.springframework.context.ApplicationContext;

public class BaseUnitTest
implements RecordsManagementModel,
ContentModel {
    protected NodeRef filePlanComponent;
    protected NodeRef filePlan;
    protected NodeRef recordFolder;
    protected NodeRef record;
    @Mock(name="nodeService")
    protected NodeService mockedNodeService;
    @Mock(name="dictionaryService")
    protected DictionaryService mockedDictionaryService;
    @Mock(name="namespaceService")
    protected NamespaceService mockedNamespaceService;
    @Mock(name="identifierService")
    protected IdentifierService mockedIdentifierService;
    @Mock(name="permissionService")
    protected PermissionService mockedPermissionService;
    @Mock(name="ownableService")
    protected OwnableService mockedOwnableService;
    @Mock(name="searchService")
    protected SearchService mockedSearchService;
    @Mock(name="retryingTransactionHelper")
    protected RetryingTransactionHelper mockedRetryingTransactionHelper;
    @Mock(name="authorityService")
    protected AuthorityService mockedAuthorityService;
    @Mock(name="policyComponent")
    protected PolicyComponent mockedPolicyComponent;
    @Mock(name="copyService")
    protected CopyService mockedCopyService;
    @Mock(name="fileFolderService")
    protected FileFolderService mockedFileFolderService;
    @Mock(name="modelSecurityService")
    protected ModelSecurityService mockedModelSecurityService;
    @Mock(name="ruleService")
    protected RuleService mockedRuleService;
    @Mock(name="versionService")
    protected VersionService mockedVersionService;
    @Mock(name="filePlanService")
    protected FilePlanService mockedFilePlanService;
    @Mock(name="recordFolderService")
    protected RecordFolderService mockedRecordFolderService;
    @Mock(name="recordService")
    protected RecordService mockedRecordService;
    @Mock(name="holdService")
    protected HoldService mockedHoldService;
    @Mock(name="recordsManagementActionService")
    protected RecordsManagementActionService mockedRecordsManagementActionService;
    @Mock(name="reportService")
    protected ReportService mockedReportService;
    @Mock(name="filePlanRoleService")
    protected FilePlanRoleService mockedFilePlanRoleService;
    @Mock(name="recordsManagementAuditService")
    protected RecordsManagementAuditService mockedRecordsManagementAuditService;
    @Mock(name="policyBehaviourFilter")
    protected BehaviourFilter mockedBehaviourFilter;
    @Mock(name="authenticationUtil")
    protected AuthenticationUtil mockedAuthenticationUtil;
    @Mock(name="extendedPermissionService")
    protected ExtendedPermissionService mockedExtendedPermissionService;
    @Mock(name="extendedSecurityService")
    protected ExtendedSecurityService mockedExtendedSecurityService;
    @Mock(name="recordableVersionConfigService")
    protected RecordableVersionConfigService mockedRecordableVersionConfigService;
    @Mock(name="cmObjectType")
    protected CmObjectType mockedCmObjectType;
    @Mock(name="recordableVersionService")
    protected RecordableVersionService mockedRecordableVersionService;
    @Mock(name="transactionalResourceHelper")
    protected TransactionalResourceHelper mockedTransactionalResourceHelper;
    @Mock(name="alfrescoTransactionSupport")
    protected AlfrescoTransactionSupport mockedAlfrescoTransactionSupport;
    @Mock(name="freezeService")
    protected FreezeService mockedFreezeService;
    @Mock(name="dispositionService")
    protected DispositionService mockedDispositionService;
    @Mock(name="applicationContext")
    protected ApplicationContext mockedApplicationContext;
    @Mock
    protected NodeTypeUtility mockedNodeTypeUtility;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void before() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        ((ApplicationContext)Mockito.lenient().doReturn((Object)this.mockedNodeService).when((Object)this.mockedApplicationContext)).getBean("dbNodeService");
        Answer<Object> doInTransactionAnswer = new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                RetryingTransactionHelper.RetryingTransactionCallback callback = (RetryingTransactionHelper.RetryingTransactionCallback)invocation.getArguments()[0];
                return callback.execute();
            }
        };
        ((RetryingTransactionHelper)Mockito.lenient().doAnswer((Answer)doInTransactionAnswer).when((Object)this.mockedRetryingTransactionHelper)).doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)ArgumentMatchers.any(RetryingTransactionHelper.RetryingTransactionCallback.class));
        MockAuthenticationUtilHelper.setup(this.mockedAuthenticationUtil);
        this.filePlan = this.generateNodeRef(TYPE_FILE_PLAN);
        this.setupAsFilePlanComponent(this.filePlan);
        ((FilePlanService)Mockito.lenient().doReturn((Object)true).when((Object)this.mockedFilePlanService)).isFilePlan(this.filePlan);
        this.filePlanComponent = this.generateNodeRef();
        this.setupAsFilePlanComponent(this.filePlanComponent);
        ((NamespaceService)Mockito.lenient().doReturn((Object)"http://www.alfresco.org/model/recordsmanagement/1.0").when((Object)this.mockedNamespaceService)).getNamespaceURI("rma");
        ((NamespaceService)Mockito.lenient().doReturn((Object)CollectionUtils.unmodifiableSet((Object[])new String[]{"rma"})).when((Object)this.mockedNamespaceService)).getPrefixes("http://www.alfresco.org/model/recordsmanagement/1.0");
        this.recordFolder = this.generateRecordFolder();
        this.record = this.generateRecord();
        ArrayList<ChildAssociationRef> result = new ArrayList<ChildAssociationRef>(1);
        result.add(new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, this.recordFolder, AlfMock.generateQName("http://www.alfresco.org/model/recordsmanagement/1.0"), this.record, true, 1));
        ((NodeService)Mockito.lenient().doReturn(result).when((Object)this.mockedNodeService)).getChildAssocs((NodeRef)ArgumentMatchers.eq((Object)this.recordFolder), (QNamePattern)ArgumentMatchers.eq((Object)ContentModel.ASSOC_CONTAINS), (QNamePattern)ArgumentMatchers.any(QNamePattern.class));
        ((NodeService)Mockito.lenient().doReturn(result).when((Object)this.mockedNodeService)).getParentAssocs(this.record);
        ((RecordFolderService)Mockito.lenient().doReturn(Collections.singletonList(this.recordFolder)).when((Object)this.mockedRecordFolderService)).getRecordFolders(this.record);
        ((RecordService)Mockito.lenient().doReturn(Collections.singletonList(this.record)).when((Object)this.mockedRecordService)).getRecords(this.recordFolder);
    }

    protected NodeRef generateHoldNodeRef(String name) {
        NodeRef hold = this.generateNodeRef(TYPE_HOLD);
        ((NodeService)Mockito.lenient().doReturn((Object)name).when((Object)this.mockedNodeService)).getProperty(hold, ContentModel.PROP_NAME);
        ((HoldService)Mockito.doReturn((Object)true).when((Object)this.mockedHoldService)).isHold(hold);
        return hold;
    }

    protected NodeRef generateRecordFolder() {
        NodeRef recordFolder = this.generateNodeRef(TYPE_RECORD_FOLDER);
        this.setupAsFilePlanComponent(recordFolder);
        ((RecordFolderService)Mockito.lenient().doReturn((Object)true).when((Object)this.mockedRecordFolderService)).isRecordFolder(recordFolder);
        return recordFolder;
    }

    protected NodeRef generateRecord() {
        NodeRef record = this.generateNodeRef(ContentModel.TYPE_CONTENT);
        this.setupAsFilePlanComponent(record);
        ((NodeService)Mockito.lenient().doReturn((Object)true).when((Object)this.mockedNodeService)).hasAspect(record, ASPECT_RECORD);
        ((RecordService)Mockito.lenient().doReturn((Object)true).when((Object)this.mockedRecordService)).isRecord(record);
        return record;
    }

    protected void setupAsFilePlanComponent(NodeRef nodeRef) {
        ((NodeService)Mockito.lenient().doReturn((Object)true).when((Object)this.mockedNodeService)).hasAspect(nodeRef, ASPECT_FILE_PLAN_COMPONENT);
        ((FilePlanService)Mockito.lenient().doReturn((Object)true).when((Object)this.mockedFilePlanService)).isFilePlanComponent(nodeRef);
        ((FilePlanService)Mockito.lenient().doReturn((Object)this.filePlan).when((Object)this.mockedFilePlanService)).getFilePlan(nodeRef);
        ((NodeService)Mockito.lenient().doReturn((Object)this.filePlan).when((Object)this.mockedNodeService)).getProperty(nodeRef, PROP_ROOT_NODEREF);
    }

    protected NodeRef generateNodeRef() {
        return this.generateNodeRef(null);
    }

    protected NodeRef generateNodeRef(QName type) {
        return this.generateNodeRef(type, true);
    }

    protected NodeRef generateCmContent(String name) {
        NodeRef nodeRef = this.generateNodeRef(ContentModel.TYPE_CONTENT, true);
        ((NodeService)Mockito.lenient().doReturn((Object)name).when((Object)this.mockedNodeService)).getProperty(nodeRef, ContentModel.PROP_NAME);
        return nodeRef;
    }

    protected NodeRef generateNodeRef(QName type, boolean exists) {
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, GUID.generate());
        Mockito.lenient().when((Object)this.mockedNodeService.exists((NodeRef)ArgumentMatchers.eq((Object)nodeRef))).thenReturn((Object)exists);
        if (type != null) {
            Mockito.lenient().when((Object)this.mockedNodeService.getType((NodeRef)ArgumentMatchers.eq((Object)nodeRef))).thenReturn((Object)type);
            Mockito.lenient().when((Object)this.mockedNodeTypeUtility.instanceOf(type, type)).thenReturn((Object)true);
        }
        return nodeRef;
    }

    protected ChildAssociationRef generateChildAssociationRef(NodeRef parent, NodeRef child) {
        ChildAssociationRef mockedChildAssociationRef = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        if (parent != null) {
            ((ChildAssociationRef)Mockito.lenient().doReturn((Object)parent).when((Object)mockedChildAssociationRef)).getParentRef();
        }
        if (child != null) {
            ((ChildAssociationRef)Mockito.doReturn((Object)child).when((Object)mockedChildAssociationRef)).getChildRef();
        }
        return mockedChildAssociationRef;
    }

    protected void makePrimaryParentOf(NodeRef child, NodeRef parent) {
        this.makePrimaryParentOf(child, parent, ContentModel.ASSOC_CONTAINS, AlfMock.generateQName());
    }

    protected void makePrimaryParentOf(NodeRef child, NodeRef parent, QName assocType, QName assocName) {
        this.makePrimaryParentOf(child, parent, assocType, assocName, this.mockedNodeService);
    }

    protected void makePrimaryParentOf(NodeRef child, NodeRef parent, QName assocType, QName assocName, NodeService mockedNodeService) {
        ((NodeService)Mockito.doReturn((Object)new ChildAssociationRef(assocType, parent, assocName, child)).when((Object)mockedNodeService)).getPrimaryParent(child);
    }

    protected void makeChildrenOf(NodeRef parent, NodeRef ... children) {
        ArrayList<ChildAssociationRef> assocs = new ArrayList<ChildAssociationRef>(children.length);
        for (NodeRef child : children) {
            assocs.add(new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, parent, AlfMock.generateQName(), child));
            ((NodeService)Mockito.doReturn(assocs).when((Object)this.mockedNodeService)).getParentAssocs(child);
        }
        ((NodeService)Mockito.doReturn(assocs).when((Object)this.mockedNodeService)).getChildAssocs(parent, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
    }

    protected <T> List<T> buildList(T ... values) {
        ArrayList<T> result = new ArrayList<T>(values.length);
        for (T value : values) {
            result.add(value);
        }
        return result;
    }
}

