/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority;

import java.util.Set;
import java.util.regex.Pattern;
import org.alfresco.repo.security.authority.AuthorityDAOImpl;
import org.alfresco.service.cmr.security.AuthorityType;

public class RMAuthorityDAOImpl
extends AuthorityDAOImpl {
    protected void addAuthorityNameIfMatches(Set<String> authorities, String authorityName, AuthorityType type) {
        if (this.isAuthorityNameMatching(authorityName, type)) {
            authorities.add(authorityName);
        }
    }

    protected void addAuthorityNameIfMatches(Set<String> authorities, String authorityName, AuthorityType type, Pattern pattern) {
        if (this.isAuthorityNameMatching(authorityName, type)) {
            if (pattern == null) {
                authorities.add(authorityName);
            } else if (pattern.matcher(this.getShortName(authorityName)).matches()) {
                authorities.add(authorityName);
            } else {
                String displayName = this.getAuthorityDisplayName(authorityName);
                if (displayName != null && pattern.matcher(displayName).matches()) {
                    authorities.add(authorityName);
                }
            }
        }
    }

    private boolean isAuthorityNameMatching(String authorityName, AuthorityType type) {
        boolean isMatching = false;
        if (type == null || AuthorityType.getAuthorityType((String)authorityName).equals((Object)type) && !this.getAuthorityZones(authorityName).contains("APP.RM")) {
            isMatching = true;
        }
        return isMatching;
    }
}

