/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.recordfolder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.module.org_alfresco_module_rm.recordfolder.RecordFolderService;
import org.alfresco.module.org_alfresco_module_rm.util.ServiceBaseImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class RecordFolderServiceImpl
extends ServiceBaseImpl
implements RecordFolderService,
RecordsManagementModel {
    private static Log logger = LogFactory.getLog(RecordFolderServiceImpl.class);
    private static final String MSG_RECORD_FOLDER_EXPECTED = "rm.service.record-folder-expected";
    private static final String MSG_PARENT_RECORD_FOLDER_ROOT = "rm.service.parent-record-folder-root";
    private static final String MSG_PARENT_RECORD_FOLDER_TYPE = "rm.service.parent-record-folder-type";
    private static final String MSG_RECORD_FOLDER_TYPE = "rm.service.record-folder-type";
    private static final String MSG_CLOSE_RECORD_FOLDER_NOT_FOLDER = "rm.service.close-record-folder-not-folder";
    private DispositionService dispositionService;
    private RecordService recordService;
    private FilePlanService filePlanService;

    public void setDispositionService(DispositionService dispositionService) {
        this.dispositionService = dispositionService;
    }

    public void setRecordService(RecordService recordService) {
        this.recordService = recordService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    @Override
    public void setupRecordFolder(NodeRef nodeRef) {
        DispositionSchedule di;
        if (!this.nodeService.hasAspect(nodeRef, ASPECT_DISPOSITION_LIFECYCLE) && (di = this.dispositionService.getDispositionSchedule(nodeRef)) != null && !di.isRecordLevelDisposition()) {
            this.nodeService.addAspect(nodeRef, ASPECT_DISPOSITION_LIFECYCLE, null);
        }
    }

    @Override
    public boolean isRecordFolderDeclared(NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        if (!this.isRecordFolder(nodeRef)) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_RECORD_FOLDER_EXPECTED));
        }
        boolean result = true;
        List<NodeRef> records = this.recordService.getRecords(nodeRef);
        for (NodeRef record : records) {
            if (this.recordService.isDeclared(record)) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    public boolean isRecordFolderClosed(final NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        if (!this.isRecordFolder(nodeRef)) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_RECORD_FOLDER_EXPECTED));
        }
        return (Boolean)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Boolean>(){

            public Boolean doWork() throws Exception {
                return (Boolean)RecordFolderServiceImpl.this.nodeService.getProperty(nodeRef, RecordsManagementModel.PROP_IS_CLOSED);
            }
        });
    }

    @Override
    public NodeRef createRecordFolder(NodeRef rmContainer, String name, QName type) {
        ParameterCheck.mandatory((String)"rmContainer", (Object)rmContainer);
        ParameterCheck.mandatoryString((String)"name", (String)name);
        ParameterCheck.mandatory((String)"type", (Object)type);
        return this.createRecordFolder(rmContainer, name, type, null);
    }

    @Override
    public NodeRef createRecordFolder(NodeRef rmContainer, String name, QName type, Map<QName, Serializable> properties) {
        ParameterCheck.mandatory((String)"rmContainer", (Object)rmContainer);
        ParameterCheck.mandatoryString((String)"name", (String)name);
        ParameterCheck.mandatory((String)"type", (Object)type);
        if (this.filePlanService.isFilePlan(rmContainer)) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_PARENT_RECORD_FOLDER_ROOT));
        }
        QName parentType = this.nodeService.getType(rmContainer);
        if (!TYPE_RECORD_CATEGORY.equals((Object)parentType) && !this.dictionaryService.isSubClass(parentType, TYPE_RECORD_CATEGORY)) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_PARENT_RECORD_FOLDER_TYPE, (Object[])new Object[]{parentType.toString()}));
        }
        if (!TYPE_RECORD_FOLDER.equals((Object)type) && !this.dictionaryService.isSubClass(type, TYPE_RECORD_FOLDER)) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_RECORD_FOLDER_TYPE, (Object[])new Object[]{type.toString()}));
        }
        HashMap<QName, Object> props = new HashMap<QName, Object>(1);
        if (properties != null && properties.size() != 0) {
            props.putAll(properties);
        }
        props.put(ContentModel.PROP_NAME, name);
        return this.nodeService.createNode(rmContainer, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)(name.length() > 255 ? name.substring(0, 255) : name)), type, props).getChildRef();
    }

    @Override
    public NodeRef createRecordFolder(NodeRef rmContainer, String name) {
        ParameterCheck.mandatory((String)"rmContainer", (Object)rmContainer);
        ParameterCheck.mandatoryString((String)"name", (String)name);
        return this.createRecordFolder(rmContainer, name, TYPE_RECORD_FOLDER);
    }

    @Override
    public NodeRef createRecordFolder(NodeRef rmContainer, String name, Map<QName, Serializable> properties) {
        ParameterCheck.mandatory((String)"rmContainer", (Object)rmContainer);
        ParameterCheck.mandatoryString((String)"name", (String)name);
        ParameterCheck.mandatory((String)"properties", properties);
        return this.createRecordFolder(rmContainer, name, TYPE_RECORD_FOLDER, properties);
    }

    @Override
    public List<NodeRef> getRecordFolders(NodeRef record) {
        ParameterCheck.mandatory((String)"record", (Object)record);
        ArrayList<NodeRef> result = new ArrayList<NodeRef>(1);
        if (this.recordService.isRecord(record)) {
            List assocs = this.nodeService.getParentAssocs(record, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
            for (ChildAssociationRef assoc : assocs) {
                NodeRef parent = assoc.getParentRef();
                if (!this.isRecordFolder(parent)) continue;
                result.add(parent);
            }
        }
        return result;
    }

    @Override
    public void closeRecordFolder(NodeRef nodeRef) {
        ChildAssociationRef assocRef;
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        if (this.isRecord(nodeRef) && (assocRef = this.nodeService.getPrimaryParent(nodeRef)) != null) {
            nodeRef = assocRef.getParentRef();
        }
        if (this.isRecordFolder(nodeRef)) {
            if (!this.isRecordFolderClosed(nodeRef)) {
                this.nodeService.setProperty(nodeRef, PROP_IS_CLOSED, (Serializable)Boolean.valueOf(true));
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)I18NUtil.getMessage((String)MSG_CLOSE_RECORD_FOLDER_NOT_FOLDER, (Object[])new Object[]{nodeRef.toString()}));
        }
    }
}

