/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.action.dm;

import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.action.AuditableActionExecuterAbstractBase;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.record.InplaceRecordService;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoveDmRecordAction
extends AuditableActionExecuterAbstractBase
implements RecordsManagementModel {
    private static Log logger = LogFactory.getLog(MoveDmRecordAction.class);
    public static final String NAME = "move-dm-record";
    public static final String PARAM_TARGET_NODE_REF = "targetNodeRef";
    private NodeService nodeService;
    private InplaceRecordService inplaceRecordService;

    protected NodeService getNodeService() {
        return this.nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    protected InplaceRecordService getInplaceRecordService() {
        return this.inplaceRecordService;
    }

    public void setInplaceRecordService(InplaceRecordService inplaceRecordService) {
        this.inplaceRecordService = inplaceRecordService;
    }

    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        if (!this.getNodeService().hasAspect(actionedUponNodeRef, ASPECT_RECORD) && logger.isDebugEnabled()) {
            logger.debug((Object)("Cannot move the document, because '" + actionedUponNodeRef.toString() + "' is not a record."));
        } else {
            this.getInplaceRecordService().moveRecord(actionedUponNodeRef, this.getTargetNodeRef(action));
        }
    }

    private NodeRef getTargetNodeRef(Action action) {
        String targetNodeRef = (String)((Object)action.getParameterValue(PARAM_TARGET_NODE_REF));
        if (StringUtils.isBlank((CharSequence)targetNodeRef)) {
            throw new AlfrescoRuntimeException("Could not find target node reference.");
        }
        return new NodeRef(targetNodeRef);
    }

    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
    }
}

