/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.disposition;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.RecordsManagementPolicies;
import org.alfresco.module.org_alfresco_module_rm.RecordsManagementServiceRegistry;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionAction;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionActionDefinition;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionActionImpl;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionScheduleImpl;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.disposition.NextActionFromDisposition;
import org.alfresco.module.org_alfresco_module_rm.disposition.property.DispositionProperty;
import org.alfresco.module.org_alfresco_module_rm.event.RecordsManagementEvent;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanComponentKind;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.module.org_alfresco_module_rm.recordfolder.RecordFolderService;
import org.alfresco.module.org_alfresco_module_rm.util.ServiceBaseImpl;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.annotation.Behaviour;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Period;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BehaviourBean
public class DispositionServiceImpl
extends ServiceBaseImpl
implements DispositionService,
RecordsManagementModel,
RecordsManagementPolicies.OnFileRecord {
    private static final Logger LOGGER = LoggerFactory.getLogger(DispositionServiceImpl.class);
    private BehaviourFilter behaviourFilter;
    private RecordsManagementServiceRegistry serviceRegistry;
    private FilePlanService filePlanService;
    private RecordFolderService recordFolderService;
    private RecordService recordService;
    private TransactionService transactionService;
    private Map<QName, DispositionProperty> dispositionProperties = new HashMap<QName, DispositionProperty>(4);

    @Override
    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setRecordsManagementServiceRegistry(RecordsManagementServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setRecordFolderService(RecordFolderService recordFolderService) {
        this.recordFolderService = recordFolderService;
    }

    public void setRecordService(RecordService recordService) {
        this.recordService = recordService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    @Override
    @Behaviour(kind=BehaviourKind.CLASS, type="rma:record")
    public void onFileRecord(NodeRef nodeRef) {
        DispositionSchedule di;
        if (!this.nodeService.hasAspect(nodeRef, ASPECT_DISPOSITION_LIFECYCLE) && (di = this.getDispositionSchedule(nodeRef)) != null && di.isRecordLevelDisposition()) {
            this.nodeService.addAspect(nodeRef, ASPECT_DISPOSITION_LIFECYCLE, null);
        }
    }

    @Override
    public void refreshDispositionAction(NodeRef nodeRef) {
        List<DispositionActionDefinition> dispositionActionDefinitions;
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        DispositionSchedule di = this.getDispositionSchedule(nodeRef);
        if (di != null && !(dispositionActionDefinitions = di.getDispositionActionDefinitions()).isEmpty()) {
            DispositionActionDefinition nextDispositionActionDefinition = dispositionActionDefinitions.get(0);
            this.initialiseDispositionAction(nodeRef, nextDispositionActionDefinition);
        }
    }

    @Override
    public void registerDispositionProperty(DispositionProperty dispositionProperty) {
        this.dispositionProperties.put(dispositionProperty.getQName(), dispositionProperty);
    }

    @Override
    public Collection<DispositionProperty> getDispositionProperties(boolean isRecordLevel, String dispositionAction) {
        Collection<DispositionProperty> values = this.dispositionProperties.values();
        ArrayList<DispositionProperty> result = new ArrayList<DispositionProperty>(values.size());
        for (DispositionProperty dispositionProperty : values) {
            boolean test = dispositionProperty.applies(isRecordLevel, dispositionAction);
            if (!test) continue;
            result.add(dispositionProperty);
        }
        return result;
    }

    @Override
    public Collection<DispositionProperty> getDispositionProperties() {
        return this.dispositionProperties.values();
    }

    @Override
    public DispositionSchedule getDispositionSchedule(final NodeRef nodeRef) {
        DispositionScheduleImpl ds = null;
        NodeRef dsNodeRef = null;
        if (this.isRecord(nodeRef)) {
            DispositionSchedule originDispositionSchedule = (DispositionSchedule)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<DispositionSchedule>(){

                public DispositionSchedule doWork() {
                    return DispositionServiceImpl.this.getOriginDispositionSchedule(nodeRef);
                }
            });
            if (originDispositionSchedule == null || BooleanUtils.isNotTrue((Boolean)originDispositionSchedule.isRecordLevelDisposition())) {
                return null;
            }
            NextActionFromDisposition dsNextAction = this.getDispositionActionByNameForRecord(nodeRef);
            if (dsNextAction != null) {
                NodeRef action = dsNextAction.getNextActionNodeRef();
                if (BooleanUtils.isNotTrue((Boolean)((Boolean)this.nodeService.getProperty(action, PROP_MANUALLY_SET_AS_OF))) && !dsNextAction.getWriteMode().equals((Object)WriteMode.READ_ONLY)) {
                    String dispositionActionName = dsNextAction.getNextActionName();
                    Date dispositionActionDate = dsNextAction.getNextActionDateAsOf();
                    AuthenticationUtil.RunAsWork runAsWork = () -> {
                        this.nodeService.setProperty(action, PROP_DISPOSITION_AS_OF, (Serializable)dispositionActionDate);
                        return null;
                    };
                    if (AlfrescoTransactionSupport.getTransactionReadState().equals((Object)AlfrescoTransactionSupport.TxnReadState.TXN_READ_ONLY)) {
                        this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
                            AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)runAsWork);
                            return null;
                        }, false, true);
                    } else {
                        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)runAsWork);
                    }
                    if (dsNextAction.getWriteMode().equals((Object)WriteMode.DATE_AND_NAME)) {
                        this.nodeService.setProperty(action, PROP_DISPOSITION_ACTION_NAME, (Serializable)((Object)dispositionActionName));
                    }
                }
                dsNodeRef = dsNextAction.getDispositionNodeRef();
            }
        } else {
            dsNodeRef = this.getDispositionScheduleImpl(nodeRef);
        }
        if (dsNodeRef != null) {
            ds = new DispositionScheduleImpl(this.serviceRegistry, this.nodeService, dsNodeRef);
        }
        return ds;
    }

    private NodeRef getDispositionScheduleImpl(NodeRef nodeRef) {
        NodeRef parent;
        NodeRef result = this.getAssociatedDispositionScheduleImpl(nodeRef);
        if (result == null && (parent = this.nodeService.getPrimaryParent(nodeRef).getParentRef()) != null && this.filePlanService.isRecordCategory(parent)) {
            result = this.getDispositionScheduleImpl(parent);
        }
        return result;
    }

    @Override
    public DispositionSchedule getOriginDispositionSchedule(NodeRef nodeRef) {
        NodeRef parent = this.nodeService.getPrimaryParent(nodeRef).getParentRef();
        if (parent != null) {
            if (this.filePlanService.isRecordCategory(parent)) {
                NodeRef result = this.getAssociatedDispositionScheduleImpl(parent);
                if (result == null) {
                    return this.getOriginDispositionSchedule(parent);
                }
                return new DispositionScheduleImpl(this.serviceRegistry, this.nodeService, result);
            }
            return this.getOriginDispositionSchedule(parent);
        }
        return null;
    }

    @Override
    public DispositionSchedule getAssociatedDispositionSchedule(NodeRef nodeRef) {
        NodeRef dsNodeRef;
        DispositionScheduleImpl ds = null;
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        if (this.nodeService.exists(nodeRef) && (dsNodeRef = this.getAssociatedDispositionScheduleImpl(nodeRef)) != null) {
            ds = new DispositionScheduleImpl(this.serviceRegistry, this.nodeService, dsNodeRef);
        }
        return ds;
    }

    private NodeRef getAssociatedDispositionScheduleImpl(NodeRef nodeRef) {
        List childAssocs;
        NodeRef result = null;
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        if (!this.filePlanService.isFilePlanComponent(nodeRef)) {
            throw new AlfrescoRuntimeException("Can not find the associated retention schedule for a non records management component. (nodeRef=" + nodeRef.toString() + ")");
        }
        if (this.getInternalNodeService().hasAspect(nodeRef, ASPECT_SCHEDULED) && !(childAssocs = this.getInternalNodeService().getChildAssocs(nodeRef, (QNamePattern)ASSOC_DISPOSITION_SCHEDULE, RegexQNamePattern.MATCH_ALL)).isEmpty()) {
            ChildAssociationRef firstChildAssocRef = (ChildAssociationRef)childAssocs.get(0);
            result = firstChildAssocRef.getChildRef();
        }
        return result;
    }

    @Override
    public NodeRef getAssociatedRecordsManagementContainer(DispositionSchedule dispositionSchedule) {
        List assocs;
        ParameterCheck.mandatory((String)"dispositionSchedule", (Object)dispositionSchedule);
        NodeRef result = null;
        NodeRef dsNodeRef = dispositionSchedule.getNodeRef();
        if (this.nodeService.exists(dsNodeRef) && !(assocs = this.nodeService.getParentAssocs(dsNodeRef, (QNamePattern)ASSOC_DISPOSITION_SCHEDULE, RegexQNamePattern.MATCH_ALL)).isEmpty()) {
            if (assocs.size() != 1 && LOGGER.isWarnEnabled()) {
                LOGGER.warn("Retention schedule has more than one associated records management container.  This is not currently supported so only the first container will be considered. (dispositionScheduleNodeRef=" + dispositionSchedule.getNodeRef().toString() + ")");
            }
            ChildAssociationRef assoc = (ChildAssociationRef)assocs.get(0);
            result = assoc.getParentRef();
        }
        return result;
    }

    @Override
    public boolean hasDisposableItems(DispositionSchedule dispositionSchdule) {
        ParameterCheck.mandatory((String)"dispositionSchedule", (Object)dispositionSchdule);
        NodeRef rmContainer = this.getAssociatedRecordsManagementContainer(dispositionSchdule);
        return this.hasDisposableItemsImpl(dispositionSchdule.isRecordLevelDisposition(), rmContainer);
    }

    private boolean hasDisposableItemsImpl(boolean isRecordLevelDisposition, NodeRef rmContainer) {
        List<NodeRef> items = this.filePlanService.getAllContained(rmContainer);
        for (NodeRef item : items) {
            if (this.recordFolderService.isRecordFolder(item)) {
                if (isRecordLevelDisposition) {
                    List assocs = this.nodeService.getChildAssocs(item, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL, 1, true);
                    if (assocs.isEmpty()) continue;
                    return true;
                }
                return true;
            }
            if (!this.filePlanService.isRecordCategory(item) || this.getAssociatedDispositionScheduleImpl(item) != null) continue;
            if (this.hasDisposableItemsImpl(isRecordLevelDisposition, item)) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    @Override
    public List<NodeRef> getDisposableItems(DispositionSchedule dispositionSchedule) {
        ParameterCheck.mandatory((String)"dispositionSchedule", (Object)dispositionSchedule);
        NodeRef rmContainer = this.getAssociatedRecordsManagementContainer(dispositionSchedule);
        return this.getDisposableItemsImpl(dispositionSchedule.isRecordLevelDisposition(), rmContainer);
    }

    @Override
    public boolean isDisposableItem(NodeRef nodeRef) {
        return this.nodeService.hasAspect(nodeRef, ASPECT_DISPOSITION_LIFECYCLE);
    }

    private List<NodeRef> getDisposableItemsImpl(boolean isRecordLevelDisposition, NodeRef rmContainer) {
        List<NodeRef> items = this.filePlanService.getAllContained(rmContainer);
        ArrayList<NodeRef> result = new ArrayList<NodeRef>(items.size());
        for (NodeRef item : items) {
            if (this.recordFolderService.isRecordFolder(item)) {
                if (isRecordLevelDisposition) {
                    result.addAll(this.recordService.getRecords(item));
                    continue;
                }
                result.add(item);
                continue;
            }
            if (!this.filePlanService.isRecordCategory(item) || this.getAssociatedDispositionScheduleImpl(item) != null) continue;
            result.addAll(this.getDisposableItemsImpl(isRecordLevelDisposition, item));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DispositionSchedule createDispositionSchedule(NodeRef nodeRef, Map<QName, Serializable> props) {
        NodeRef dsNodeRef;
        block8: {
            dsNodeRef = null;
            ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
            if (!this.nodeService.exists(nodeRef)) {
                throw new AlfrescoRuntimeException("Unable to create retention schedule, because node does not exist. (nodeRef=" + nodeRef.toString() + ")");
            }
            QName nodeRefType = this.nodeService.getType(nodeRef);
            if (!TYPE_RECORD_CATEGORY.equals((Object)nodeRefType) && !this.dictionaryService.isSubClass(nodeRefType, TYPE_RECORD_CATEGORY)) {
                throw new AlfrescoRuntimeException("Unable to create retention schedule on a node that is not a records management container.");
            }
            this.behaviourFilter.disableBehaviour(nodeRef, ASPECT_SCHEDULED);
            try {
                List assocs;
                if (!this.nodeService.hasAspect(nodeRef, ASPECT_SCHEDULED)) {
                    this.nodeService.addAspect(nodeRef, ASPECT_SCHEDULED, null);
                }
                if ((assocs = this.nodeService.getChildAssocs(nodeRef, (QNamePattern)ASSOC_DISPOSITION_SCHEDULE, RegexQNamePattern.MATCH_ALL)).isEmpty()) {
                    List<NodeRef> items;
                    DispositionSchedule currentDispositionSchdule = this.getDispositionSchedule(nodeRef);
                    if (currentDispositionSchdule != null && !(items = this.getDisposableItemsImpl(currentDispositionSchdule.isRecordLevelDisposition(), nodeRef)).isEmpty()) {
                        throw new AlfrescoRuntimeException("Can not create a retention schedule if there are disposable items already under the control of an other retention schedule");
                    }
                    dsNodeRef = this.nodeService.createNode(nodeRef, ASSOC_DISPOSITION_SCHEDULE, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)"dispositionSchedule")), TYPE_DISPOSITION_SCHEDULE, props).getChildRef();
                    break block8;
                }
                throw new AlfrescoRuntimeException("Unable to create retention schedule on node that already has a retention schedule.");
            }
            finally {
                this.behaviourFilter.enableBehaviour(nodeRef, ASPECT_SCHEDULED);
            }
        }
        return new DispositionScheduleImpl(this.serviceRegistry, this.nodeService, dsNodeRef);
    }

    @Override
    public DispositionActionDefinition addDispositionActionDefinition(DispositionSchedule schedule, Map<QName, Serializable> actionDefinitionParams) {
        String name = (String)((Object)actionDefinitionParams.get(PROP_DISPOSITION_ACTION_NAME));
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("'name' parameter is mandatory when creating a disposition action definition");
        }
        NodeRef actionNodeRef = this.nodeService.createNode(schedule.getNodeRef(), RecordsManagementModel.ASSOC_DISPOSITION_ACTION_DEFINITIONS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)name)), RecordsManagementModel.TYPE_DISPOSITION_ACTION_DEFINITION, actionDefinitionParams).getChildRef();
        NodeRef scheduleParent = this.nodeService.getPrimaryParent(schedule.getNodeRef()).getParentRef();
        DispositionSchedule updatedSchedule = this.getDispositionSchedule(scheduleParent);
        return updatedSchedule.getDispositionActionDefinition(actionNodeRef.getId());
    }

    @Override
    public void removeDispositionActionDefinition(DispositionSchedule schedule, DispositionActionDefinition actionDefinition) {
        if (this.hasDisposableItems(schedule)) {
            throw new AlfrescoRuntimeException("Can not remove action definitions from schedule '" + String.valueOf(schedule.getNodeRef()) + "' as one or more record or record folders are present.");
        }
        this.nodeService.removeChild(schedule.getNodeRef(), actionDefinition.getNodeRef());
    }

    @Override
    public DispositionActionDefinition updateDispositionActionDefinition(DispositionActionDefinition actionDefinition, Map<QName, Serializable> actionDefinitionParams) {
        this.nodeService.addProperties(actionDefinition.getNodeRef(), actionDefinitionParams);
        NodeRef ds = this.nodeService.getPrimaryParent(actionDefinition.getNodeRef()).getParentRef();
        DispositionScheduleImpl updatedSchedule = new DispositionScheduleImpl(this.serviceRegistry, this.nodeService, ds);
        return updatedSchedule.getDispositionActionDefinition(actionDefinition.getId());
    }

    private DispositionAction initialiseDispositionAction(final NodeRef nodeRef, DispositionActionDefinition dispositionActionDefinition) {
        List childAssocs = this.nodeService.getChildAssocs(nodeRef, (QNamePattern)ASSOC_NEXT_DISPOSITION_ACTION, (QNamePattern)ASSOC_NEXT_DISPOSITION_ACTION, 1, true);
        if (childAssocs != null && !childAssocs.isEmpty()) {
            return new DispositionActionImpl(this.serviceRegistry, ((ChildAssociationRef)childAssocs.get(0)).getChildRef());
        }
        final HashMap<QName, Serializable> props = new HashMap<QName, Serializable>(10);
        Date asOfDate = this.calculateAsOfDate(nodeRef, dispositionActionDefinition);
        props.put(PROP_DISPOSITION_ACTION_ID, (Serializable)((Object)dispositionActionDefinition.getId()));
        props.put(PROP_DISPOSITION_ACTION, (Serializable)((Object)dispositionActionDefinition.getName()));
        if (asOfDate != null) {
            props.put(PROP_DISPOSITION_AS_OF, asOfDate);
        }
        DispositionAction da = AlfrescoTransactionSupport.getTransactionReadState().equals((Object)AlfrescoTransactionSupport.TxnReadState.TXN_READ_ONLY) ? (DispositionAction)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<DispositionAction>(){

            public DispositionAction execute() throws Throwable {
                return DispositionServiceImpl.this.createDispositionAction(nodeRef, props);
            }
        }, false, true) : this.createDispositionAction(nodeRef, props);
        List<RecordsManagementEvent> events = dispositionActionDefinition.getEvents();
        for (RecordsManagementEvent event : events) {
            da.addEventCompletionDetails(event);
        }
        return da;
    }

    private DispositionAction createDispositionAction(NodeRef nodeRef, Map<QName, Serializable> props) {
        NodeRef dispositionActionNodeRef = this.nodeService.createNode(nodeRef, ASSOC_NEXT_DISPOSITION_ACTION, ASSOC_NEXT_DISPOSITION_ACTION, TYPE_DISPOSITION_ACTION, props).getChildRef();
        return new DispositionActionImpl(this.serviceRegistry, dispositionActionNodeRef);
    }

    @Override
    public Date calculateAsOfDate(NodeRef nodeRef, DispositionActionDefinition dispositionActionDefinition) {
        Date asOfDate = null;
        Period period = dispositionActionDefinition.getPeriod();
        if (period != null) {
            DispositionAction lastCompletedDispositionAction;
            Date contextDate = null;
            QName periodProperty = dispositionActionDefinition.getPeriodProperty();
            contextDate = periodProperty != null ? (RecordsManagementModel.PROP_DISPOSITION_AS_OF.equals((Object)periodProperty) ? ((lastCompletedDispositionAction = this.getLastCompletedDispostionAction(nodeRef)) != null ? lastCompletedDispositionAction.getCompletedAt() : (Date)this.nodeService.getProperty(nodeRef, periodProperty)) : (Date)this.nodeService.getProperty(nodeRef, periodProperty)) : (period.getPeriodType().equals("immediately") ? (Date)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CREATED) : new Date());
            if (contextDate != null) {
                asOfDate = period.getNextDate(contextDate);
            }
        }
        return asOfDate;
    }

    @Override
    public boolean isNextDispositionActionEligible(NodeRef nodeRef) {
        boolean result = false;
        DispositionSchedule di = this.getDispositionSchedule(nodeRef);
        DispositionAction nextDa = this.getNextDispositionAction(nodeRef);
        if (di != null && this.nodeService.hasAspect(nodeRef, ASPECT_DISPOSITION_LIFECYCLE) && nextDa != null) {
            Boolean combineStepsProp;
            NodeRef accessionNodeRef;
            boolean combineSteps = false;
            if (nextDa.getName().equals("accession") && (accessionNodeRef = di.getDispositionActionDefinitionByName("accession").getNodeRef()) != null && (combineStepsProp = (Boolean)this.getInternalNodeService().getProperty(accessionNodeRef, PROP_COMBINE_DISPOSITION_STEP_CONDITIONS)) != null) {
                combineSteps = combineStepsProp;
            }
            Date asOf = (Date)this.getInternalNodeService().getProperty(nextDa.getNodeRef(), PROP_DISPOSITION_AS_OF);
            boolean asOfDateInPast = false;
            if (asOf != null) {
                asOfDateInPast = asOf.before(new Date());
            }
            if (asOfDateInPast && !combineSteps) {
                return true;
            }
            if (!asOfDateInPast && combineSteps) {
                return false;
            }
            DispositionActionImpl da = new DispositionActionImpl(this.serviceRegistry, nextDa.getNodeRef());
            DispositionActionDefinition dad = da.getDispositionActionDefinition();
            if (dad != null) {
                boolean firstComplete = (Boolean)this.authenticationUtil.runAsSystem(() -> dad.eligibleOnFirstCompleteEvent());
                List assocs = this.getInternalNodeService().getChildAssocs(nextDa.getNodeRef(), (QNamePattern)ASSOC_EVENT_EXECUTIONS, RegexQNamePattern.MATCH_ALL);
                for (ChildAssociationRef assoc : assocs) {
                    NodeRef eventExecution = assoc.getChildRef();
                    Boolean isCompleteValue = (Boolean)this.getInternalNodeService().getProperty(eventExecution, PROP_EVENT_EXECUTION_COMPLETE);
                    boolean isComplete = false;
                    if (isCompleteValue == null) continue;
                    isComplete = isCompleteValue;
                    if (isComplete) {
                        result = true;
                        if (!firstComplete) continue;
                        break;
                    }
                    result = false;
                    if (firstComplete) continue;
                    break;
                }
            }
        }
        return result;
    }

    private NodeRef getNextDispositionActionNodeRef(NodeRef nodeRef) {
        NodeRef result = null;
        List assocs = this.nodeService.getChildAssocs(nodeRef, (QNamePattern)ASSOC_NEXT_DISPOSITION_ACTION, (QNamePattern)ASSOC_NEXT_DISPOSITION_ACTION, 1, true);
        if (!assocs.isEmpty()) {
            result = ((ChildAssociationRef)assocs.get(0)).getChildRef();
        }
        return result;
    }

    @Override
    public DispositionAction getNextDispositionAction(NodeRef nodeRef) {
        DispositionActionImpl result = null;
        NodeRef dispositionActionNodeRef = this.getNextDispositionActionNodeRef(nodeRef);
        if (dispositionActionNodeRef != null) {
            result = new DispositionActionImpl(this.serviceRegistry, dispositionActionNodeRef);
        }
        return result;
    }

    @Override
    public List<DispositionAction> getCompletedDispositionActions(NodeRef nodeRef) {
        List assocs = this.nodeService.getChildAssocs(nodeRef, (QNamePattern)ASSOC_DISPOSITION_ACTION_HISTORY, RegexQNamePattern.MATCH_ALL);
        ArrayList<DispositionAction> result = new ArrayList<DispositionAction>(assocs.size());
        for (ChildAssociationRef assoc : assocs) {
            NodeRef dispositionActionNodeRef = assoc.getChildRef();
            result.add(new DispositionActionImpl(this.serviceRegistry, dispositionActionNodeRef));
        }
        return result;
    }

    @Override
    public DispositionAction getLastCompletedDispostionAction(NodeRef nodeRef) {
        DispositionAction result = null;
        List<DispositionAction> list = this.getCompletedDispositionActions(nodeRef);
        if (!list.isEmpty()) {
            result = list.get(list.size() - 1);
        }
        return result;
    }

    @Override
    public boolean isDisposableItemCutoff(NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        return this.nodeService.hasAspect(nodeRef, ASPECT_CUT_OFF);
    }

    @Override
    public void updateNextDispositionAction(final NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        AuthenticationUtil.RunAsWork<Void> runAsWork = new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                DispositionSchedule dispositionSchedule = DispositionServiceImpl.this.getDispositionSchedule(nodeRef);
                DispositionServiceImpl.this.updateNextDispositionAction(nodeRef, dispositionSchedule);
                return null;
            }
        };
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)runAsWork);
    }

    @Override
    public void updateNextDispositionAction(final NodeRef nodeRef, final DispositionSchedule dispositionSchedule) {
        AuthenticationUtil.RunAsWork<Void> runAsWork = new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                if (dispositionSchedule != null) {
                    List assocs;
                    NodeRef currentDispositionAction = null;
                    if (DispositionServiceImpl.this.nodeService.hasAspect(nodeRef, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE) && !(assocs = DispositionServiceImpl.this.nodeService.getChildAssocs(nodeRef, (QNamePattern)RecordsManagementModel.ASSOC_NEXT_DISPOSITION_ACTION, (QNamePattern)RecordsManagementModel.ASSOC_NEXT_DISPOSITION_ACTION)).isEmpty()) {
                        currentDispositionAction = ((ChildAssociationRef)assocs.get(0)).getChildRef();
                    }
                    if (currentDispositionAction != null) {
                        DispositionServiceImpl.this.nodeService.moveNode(currentDispositionAction, nodeRef, RecordsManagementModel.ASSOC_DISPOSITION_ACTION_HISTORY, RecordsManagementModel.ASSOC_DISPOSITION_ACTION_HISTORY);
                    }
                    List<DispositionActionDefinition> dispositionActionDefinitions = dispositionSchedule.getDispositionActionDefinitions();
                    DispositionActionDefinition currentDispositionActionDefinition = null;
                    DispositionActionDefinition nextDispositionActionDefinition = null;
                    if (currentDispositionAction == null) {
                        if (!dispositionActionDefinitions.isEmpty()) {
                            nextDispositionActionDefinition = dispositionActionDefinitions.get(0);
                        }
                    } else {
                        String currentADId = (String)((Object)DispositionServiceImpl.this.nodeService.getProperty(currentDispositionAction, RecordsManagementModel.PROP_DISPOSITION_ACTION_ID));
                        currentDispositionActionDefinition = dispositionSchedule.getDispositionActionDefinition(currentADId);
                        if (currentDispositionActionDefinition == null) {
                            String currentADName = (String)((Object)DispositionServiceImpl.this.nodeService.getProperty(currentDispositionAction, RecordsManagementModel.PROP_DISPOSITION_ACTION));
                            currentDispositionActionDefinition = dispositionSchedule.getDispositionActionDefinitionByName(currentADName);
                        }
                        int index = currentDispositionActionDefinition.getIndex();
                        if (++index < dispositionActionDefinitions.size()) {
                            nextDispositionActionDefinition = dispositionActionDefinitions.get(index);
                        }
                    }
                    if (nextDispositionActionDefinition != null) {
                        if (!DispositionServiceImpl.this.nodeService.hasAspect(nodeRef, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE)) {
                            DispositionServiceImpl.this.nodeService.addAspect(nodeRef, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE, null);
                        }
                        DispositionServiceImpl.this.initialiseDispositionAction(nodeRef, nextDispositionActionDefinition);
                    }
                }
                return null;
            }
        };
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)runAsWork);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void cutoffDisposableItem(final NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        if (!FilePlanComponentKind.RECORD_FOLDER.equals((Object)this.filePlanService.getFilePlanComponentKind(nodeRef)) && !FilePlanComponentKind.RECORD.equals((Object)this.filePlanService.getFilePlanComponentKind(nodeRef))) throw new AlfrescoRuntimeException("Unable to peform cutoff, because node is not a disposible item. (nodeRef=" + nodeRef.toString() + ")");
        if (this.isDisposableItemCutoff(nodeRef)) throw new AlfrescoRuntimeException("unable to perform cutoff, because node is frozen or has frozen children");
        if (this.recordFolderService.isRecordFolder(nodeRef)) {
            for (NodeRef record : this.recordService.getRecords(nodeRef)) {
                this.applyCutoff(record);
            }
        }
        this.applyCutoff(nodeRef);
        if (this.nodeService.hasAspect(nodeRef, ASPECT_UNCUT_OFF)) {
            this.nodeService.removeAspect(nodeRef, ASPECT_UNCUT_OFF);
        }
        if (!this.recordFolderService.isRecordFolder(nodeRef) || this.recordFolderService.isRecordFolderClosed(nodeRef)) return;
        this.authenticationUtil.runAsSystem(new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                DispositionServiceImpl.this.recordFolderService.closeRecordFolder(nodeRef);
                return null;
            }
        });
    }

    @Override
    public Date getDispositionActionDate(NodeRef record, NodeRef dispositionSchedule, String dispositionActionName) {
        DispositionScheduleImpl ds = new DispositionScheduleImpl(this.serviceRegistry, this.nodeService, dispositionSchedule);
        List assocs = this.getInternalNodeService().getChildAssocs(dispositionSchedule);
        if (assocs != null && !assocs.isEmpty()) {
            for (ChildAssociationRef assoc : assocs) {
                if (assoc == null || !assoc.getQName().getLocalName().contains(dispositionActionName)) continue;
                DispositionActionDefinition actionDefinition = ds.getDispositionActionDefinition(assoc.getChildRef().getId());
                return (Date)this.authenticationUtil.runAsSystem(() -> this.calculateAsOfDate(record, actionDefinition));
            }
        }
        return null;
    }

    @Override
    public void recalculateNextDispositionStep(NodeRef record) {
        NextActionFromDisposition dsNextAction;
        List<NodeRef> recordFolders = this.recordFolderService.getRecordFolders(record);
        DispositionAction nextDispositionAction = this.getNextDispositionAction(record);
        if (nextDispositionAction != null && (dsNextAction = this.getNextDispositionAction(record, recordFolders, nextDispositionAction)) != null) {
            final NodeRef action = dsNextAction.getNextActionNodeRef();
            final Date dispositionActionDate = dsNextAction.getNextActionDateAsOf();
            AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() {
                    DispositionServiceImpl.this.nodeService.setProperty(action, RecordsManagementModel.PROP_DISPOSITION_AS_OF, (Serializable)dispositionActionDate);
                    return null;
                }
            });
        }
    }

    private void applyCutoff(final NodeRef nodeRef) {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                HashMap<QName, Date> cutOffProps = new HashMap<QName, Date>(1);
                cutOffProps.put(RecordsManagementModel.PROP_CUT_OFF_DATE, new Date());
                DispositionServiceImpl.this.nodeService.addAspect(nodeRef, RecordsManagementModel.ASPECT_CUT_OFF, cutOffProps);
                return null;
            }
        });
    }

    protected NextActionFromDisposition getDispositionActionByNameForRecord(NodeRef record) {
        List<NodeRef> recordFolders = this.recordFolderService.getRecordFolders(record);
        DispositionAction nextDispositionAction = this.getNextDispositionAction(record);
        if (nextDispositionAction == null) {
            DispositionAction lastCompletedDispositionAction = this.getLastCompletedDispostionAction(record);
            if (lastCompletedDispositionAction != null) {
                return null;
            }
            return this.getFirstDispositionAction(record, recordFolders);
        }
        return this.getNextDispositionAction(record, recordFolders, nextDispositionAction);
    }

    private NextActionFromDisposition getNextDispositionAction(NodeRef record, List<NodeRef> recordFolders, DispositionAction nextDispositionAction) {
        String recordNextDispositionActionName = nextDispositionAction.getName();
        Date recordNextDispositionActionDate = nextDispositionAction.getAsOfDate();
        Date nextDispositionActionDate = new Date(Long.MIN_VALUE);
        NodeRef dispositionNodeRef = null;
        for (NodeRef folder : recordFolders) {
            Date dispActionDate;
            NodeRef dsNodeRef = this.getDispositionScheduleImpl(folder);
            if (dsNodeRef == null || (dispActionDate = this.getDispositionActionDate(record, dsNodeRef, recordNextDispositionActionName)) != null && (nextDispositionActionDate == null || !nextDispositionActionDate.before(dispActionDate))) continue;
            nextDispositionActionDate = dispActionDate;
            dispositionNodeRef = dsNodeRef;
            if (dispActionDate != null) continue;
            break;
        }
        if (dispositionNodeRef == null) {
            return null;
        }
        WriteMode mode = this.determineWriteMode(recordNextDispositionActionDate, nextDispositionActionDate);
        return new NextActionFromDisposition(dispositionNodeRef, nextDispositionAction.getNodeRef(), recordNextDispositionActionName, nextDispositionActionDate, mode);
    }

    private WriteMode determineWriteMode(Date recordNextDispositionActionDate, Date nextDispositionActionDate) {
        Date calculatedDate;
        Date maxDate = new Date(Long.MAX_VALUE);
        Date recordDate = recordNextDispositionActionDate != null ? recordNextDispositionActionDate : maxDate;
        Date date = calculatedDate = nextDispositionActionDate != null ? nextDispositionActionDate : maxDate;
        if (recordDate.before(calculatedDate)) {
            return WriteMode.DATE_ONLY;
        }
        return WriteMode.READ_ONLY;
    }

    private NextActionFromDisposition getFirstDispositionAction(NodeRef record, List<NodeRef> recordFolders) {
        NodeRef newAction = null;
        String newDispositionActionName = null;
        Date newDispositionActionDateAsOf = new Date(Long.MIN_VALUE);
        NodeRef dispositionNodeRef = null;
        for (NodeRef folder : recordFolders) {
            Date firstActionDate;
            DispositionScheduleImpl ds;
            List<DispositionActionDefinition> dispositionActionDefinitions;
            NodeRef folderDS = this.getDispositionScheduleImpl(folder);
            if (folderDS == null || (dispositionActionDefinitions = (ds = new DispositionScheduleImpl(this.serviceRegistry, this.nodeService, folderDS)).getDispositionActionDefinitions()) == null || dispositionActionDefinitions.size() <= 0) continue;
            DispositionActionDefinition firstDispositionActionDef = dispositionActionDefinitions.get(0);
            dispositionNodeRef = folderDS;
            if (newAction == null) {
                NodeRef recordOrFolder = record;
                if (!ds.isRecordLevelDisposition()) {
                    recordOrFolder = folder;
                }
                DispositionAction firstDispositionAction = this.initialiseDispositionAction(recordOrFolder, firstDispositionActionDef);
                newAction = firstDispositionAction.getNodeRef();
                newDispositionActionName = (String)((Object)this.nodeService.getProperty(newAction, PROP_DISPOSITION_ACTION_NAME));
                newDispositionActionDateAsOf = firstDispositionAction.getAsOfDate();
                continue;
            }
            if (firstDispositionActionDef.getPeriod() == null || (firstActionDate = this.calculateAsOfDate(record, firstDispositionActionDef)) != null && (newDispositionActionDateAsOf == null || !newDispositionActionDateAsOf.before(firstActionDate))) continue;
            newDispositionActionName = firstDispositionActionDef.getName();
            newDispositionActionDateAsOf = firstActionDate;
            if (firstActionDate != null) continue;
            break;
        }
        if (newDispositionActionName == null || dispositionNodeRef == null || newAction == null) {
            return null;
        }
        return new NextActionFromDisposition(dispositionNodeRef, newAction, newDispositionActionName, newDispositionActionDateAsOf, WriteMode.DATE_AND_NAME);
    }

    public static enum WriteMode {
        READ_ONLY,
        DATE_ONLY,
        DATE_AND_NAME;

    }
}

