/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.record;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.collections.ListUtils;

public class MoveInplaceRecordTest
extends BaseRMTestCase {
    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    public void testMoveInplaceRecord() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef destinationDmFolder;
            private Set<String> extendedReadersBeforeMove;
            private Set<String> extendedWritersBeforeMove;
            private NodeRef primaryParentBeforeMove;

            @Override
            public void given() {
                this.destinationDmFolder = MoveInplaceRecordTest.this.fileFolderService.create(MoveInplaceRecordTest.this.documentLibrary, "destinationCollabFolder", ContentModel.TYPE_FOLDER).getNodeRef();
                TestCase.assertFalse((boolean)MoveInplaceRecordTest.this.recordService.isRecord(MoveInplaceRecordTest.this.dmDocument));
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        MoveInplaceRecordTest.this.recordService.createRecord(MoveInplaceRecordTest.this.filePlan, MoveInplaceRecordTest.this.dmDocument);
                        return null;
                    }
                }, (String)MoveInplaceRecordTest.this.dmCollaborator);
                TestCase.assertTrue((boolean)MoveInplaceRecordTest.this.recordService.isRecord(MoveInplaceRecordTest.this.dmDocument));
                this.extendedReadersBeforeMove = MoveInplaceRecordTest.this.extendedSecurityService.getReaders(MoveInplaceRecordTest.this.dmDocument);
                this.extendedWritersBeforeMove = MoveInplaceRecordTest.this.extendedSecurityService.getWriters(MoveInplaceRecordTest.this.dmDocument);
                this.primaryParentBeforeMove = MoveInplaceRecordTest.this.nodeService.getPrimaryParent(MoveInplaceRecordTest.this.dmDocument).getParentRef();
                TestCase.assertTrue((String)"Primary parent of newly created should be a records management artifact.", (boolean)MoveInplaceRecordTest.this.filePlanService.isFilePlanComponent(this.primaryParentBeforeMove));
            }

            @Override
            public void when() {
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        MoveInplaceRecordTest.this.inplaceRecordService.moveRecord(MoveInplaceRecordTest.this.dmDocument, destinationDmFolder);
                        return null;
                    }
                }, (String)MoveInplaceRecordTest.this.dmCollaborator);
            }

            @Override
            public void then() {
                TestCase.assertTrue((String)"After move the document should still be a record.", (boolean)MoveInplaceRecordTest.this.recordService.isRecord(MoveInplaceRecordTest.this.dmDocument));
                TestCase.assertEquals((int)0, (int)MoveInplaceRecordTest.this.nodeService.getChildAssocs(MoveInplaceRecordTest.this.dmFolder).size());
                List destinationFolderChildAssocs = MoveInplaceRecordTest.this.nodeService.getChildAssocs(this.destinationDmFolder);
                TestCase.assertEquals((int)1, (int)destinationFolderChildAssocs.size());
                TestCase.assertEquals((Object)MoveInplaceRecordTest.this.dmDocument, (Object)((ChildAssociationRef)destinationFolderChildAssocs.get(0)).getChildRef());
                NodeRef primaryParentAfterMove = MoveInplaceRecordTest.this.nodeService.getPrimaryParent(MoveInplaceRecordTest.this.dmDocument).getParentRef();
                TestCase.assertTrue((String)"Primary parent of record after inplace move should be a records management artifact.", (boolean)MoveInplaceRecordTest.this.filePlanService.isFilePlanComponent(primaryParentAfterMove));
                TestCase.assertEquals((String)"Primary parent of record after inplace move should remain the same.", (Object)this.primaryParentBeforeMove, (Object)primaryParentAfterMove);
                Set extendedReadersAfterMove = MoveInplaceRecordTest.this.extendedSecurityService.getReaders(MoveInplaceRecordTest.this.dmDocument);
                Set extendedWritersAfterMove = MoveInplaceRecordTest.this.extendedSecurityService.getWriters(MoveInplaceRecordTest.this.dmDocument);
                TestCase.assertEquals((int)this.extendedReadersBeforeMove.size(), (int)extendedReadersAfterMove.size());
                TestCase.assertEquals((int)this.extendedWritersBeforeMove.size(), (int)extendedWritersAfterMove.size());
                TestCase.assertEquals((int)0, (int)ListUtils.removeAll(this.extendedReadersBeforeMove, (Collection)extendedReadersAfterMove).size());
                TestCase.assertEquals((int)0, (int)ListUtils.removeAll(this.extendedWritersBeforeMove, (Collection)extendedWritersAfterMove).size());
            }
        });
    }
}

