/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.jscript.app;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.capability.CapabilityService;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.event.EventCompletionDetails;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanComponentKind;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.freeze.FreezeService;
import org.alfresco.module.org_alfresco_module_rm.jscript.app.BaseEvaluator;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.module.org_alfresco_module_rm.role.FilePlanRoleService;
import org.alfresco.module.org_alfresco_module_rm.role.Role;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PathUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class JSONConversionComponent
extends org.alfresco.repo.jscript.app.JSONConversionComponent
implements NodeServicePolicies.OnDeleteNodePolicy,
NodeServicePolicies.OnCreateNodePolicy {
    private static final String IS_RM_NODE = "isRmNode";
    private static final String RM_NODE = "rmNode";
    private static final String IS_RM_SITE_CREATED = "isRmSiteCreated";
    private static final String IS_RECORD_CONTRIBUTOR_GROUP_ENABLED = "isRecordContributorGroupEnabled";
    private static final String RECORD_CONTRIBUTOR_GROUP_NAME = "recordContributorGroupName";
    private static final String IS_VISIBLE_FOR_CURRENT_USER = "isVisibleForCurrentUser";
    private static final String FROZEN_ACTIVE_CONTENT = "frozencontent";
    private boolean isRecordContributorsGroupEnabled = false;
    private String recordContributorsGroupName = "RECORD_CONTRIBUTORS";
    private RecordService recordService;
    private FilePlanService filePlanService;
    private FilePlanRoleService filePlanRoleService;
    private CapabilityService capabilityService;
    private DictionaryService dictionaryService;
    private SiteService siteService;
    private FreezeService freezeService;
    private DispositionService dispositionService;
    private List<BaseEvaluator> indicators = new ArrayList<BaseEvaluator>();
    private List<BaseEvaluator> actions = new ArrayList<BaseEvaluator>();
    private PolicyComponent policyComponent;
    private SimpleCache<String, Object> jsonConversionComponentCache;
    private static final String RM_SITE_EXISTS = "rmSiteExists";

    public void setRecordContributorsGroupEnabled(boolean enabled) {
        this.isRecordContributorsGroupEnabled = enabled;
    }

    public void setRecordContributorsGroupName(String recordContributorsGroupName) {
        this.recordContributorsGroupName = recordContributorsGroupName;
    }

    public void setRecordService(RecordService recordService) {
        this.recordService = recordService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setFilePlanRoleService(FilePlanRoleService filePlanRoleService) {
        this.filePlanRoleService = filePlanRoleService;
    }

    public void setCapabilityService(CapabilityService capabilityService) {
        this.capabilityService = capabilityService;
    }

    protected FilePlanService getFileplanService() {
        return this.filePlanService;
    }

    protected CapabilityService getCapabilityService() {
        return this.capabilityService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void registerIndicator(BaseEvaluator indicator) {
        this.indicators.add(indicator);
    }

    public void registerAction(BaseEvaluator action) {
        this.actions.add(action);
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    protected SimpleCache<String, Object> getJsonConversionComponentCache() {
        return this.jsonConversionComponentCache;
    }

    public void setJsonConversionComponentCache(SimpleCache<String, Object> jsonConversionComponentCache) {
        this.jsonConversionComponentCache = jsonConversionComponentCache;
    }

    public void setDispositionService(DispositionService dispositionService) {
        this.dispositionService = dispositionService;
    }

    public void setFreezeService(FreezeService freezeService) {
        this.freezeService = freezeService;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onDeleteNode"), RecordsManagementModel.TYPE_RM_SITE, (Behaviour)new JavaBehaviour((Object)this, "onDeleteNode"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onCreateNode"), RecordsManagementModel.TYPE_RM_SITE, (Behaviour)new JavaBehaviour((Object)this, "onCreateNode"));
    }

    protected void setRootValues(FileInfo nodeInfo, JSONObject rootJSONObject, boolean useShortQNames) {
        if (nodeInfo != null) {
            NodeRef filePlanNodeRef;
            Set<NodeRef> filePlans;
            super.setRootValues(nodeInfo, rootJSONObject, useShortQNames);
            rootJSONObject.put((Object)"uiType", (Object)this.getUIType(nodeInfo.getNodeRef()));
            this.checkRmSiteExistence(rootJSONObject);
            rootJSONObject.put((Object)IS_RECORD_CONTRIBUTOR_GROUP_ENABLED, (Object)this.isRecordContributorsGroupEnabled);
            rootJSONObject.put((Object)RECORD_CONTRIBUTOR_GROUP_NAME, (Object)this.recordContributorsGroupName);
            NodeRef nodeRef = nodeInfo.getNodeRef();
            if (AccessStatus.ALLOWED.equals((Object)this.capabilityService.getCapabilityAccessState(nodeRef, "ViewRecords"))) {
                boolean isFilePlanComponent = this.filePlanService.isFilePlanComponent(nodeRef);
                rootJSONObject.put((Object)IS_RM_NODE, (Object)isFilePlanComponent);
                if (isFilePlanComponent) {
                    rootJSONObject.put((Object)RM_NODE, (Object)this.setRmNodeValues(nodeRef, useShortQNames));
                    this.addInfo(nodeInfo, rootJSONObject);
                }
            }
            if (!CollectionUtils.isEmpty(filePlans = this.filePlanService.getFilePlans()) && (filePlanNodeRef = (NodeRef)filePlans.stream().findFirst().orElse(null)) != null) {
                Set<Role> roles = this.filePlanRoleService.getRolesByUser(filePlanNodeRef, AuthenticationUtil.getFullyAuthenticatedUser());
                boolean hasFilingPermission = !CollectionUtils.isEmpty(roles);
                rootJSONObject.put((Object)IS_VISIBLE_FOR_CURRENT_USER, (Object)hasFilingPermission);
            }
        }
    }

    private void checkRmSiteExistence(JSONObject rootJSONObject) {
        if (!this.getJsonConversionComponentCache().contains((Serializable)((Object)RM_SITE_EXISTS))) {
            SiteInfo site = this.siteService.getSite("rm");
            if (site != null) {
                this.getJsonConversionComponentCache().put((Serializable)((Object)RM_SITE_EXISTS), (Object)true);
                rootJSONObject.put((Object)IS_RM_SITE_CREATED, (Object)true);
            } else {
                this.getJsonConversionComponentCache().put((Serializable)((Object)RM_SITE_EXISTS), (Object)false);
                rootJSONObject.put((Object)IS_RM_SITE_CREATED, (Object)false);
            }
        } else {
            rootJSONObject.put((Object)IS_RM_SITE_CREATED, this.getJsonConversionComponentCache().get((Serializable)((Object)RM_SITE_EXISTS)));
        }
    }

    private void addInfo(final FileInfo nodeInfo, JSONObject rootJSONObject) {
        String itemType = (String)rootJSONObject.get((Object)"type");
        final QName itemTypeQName = QName.createQName((String)itemType, (NamespacePrefixResolver)this.namespaceService);
        NodeRef originatingLocation = (NodeRef)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() {
                NodeRef originatingLocation = null;
                if (JSONConversionComponent.this.dictionaryService.isSubClass(itemTypeQName, ContentModel.TYPE_CONTENT)) {
                    NodeRef nodeRef = nodeInfo.getNodeRef();
                    List parentAssocs = JSONConversionComponent.this.nodeService.getParentAssocs(nodeRef);
                    for (ChildAssociationRef parent : parentAssocs) {
                        if (parent.isPrimary()) continue;
                        originatingLocation = parent.getParentRef();
                        if (JSONConversionComponent.this.nodeService.hasAspect(originatingLocation, RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT)) continue;
                        break;
                    }
                }
                return originatingLocation;
            }
        });
        if (originatingLocation != null) {
            String pathSeparator = "/";
            String displayPath = this.getDisplayPath(originatingLocation);
            Object[] displayPathElements = displayPath.split(pathSeparator);
            Object[] subPath = ArrayUtils.subarray((Object[])displayPathElements, (int)5, (int)displayPathElements.length);
            StringBuilder originatingLocationPath = new StringBuilder();
            for (int i = 0; i < subPath.length; ++i) {
                originatingLocationPath.append(pathSeparator).append(subPath[i]);
            }
            rootJSONObject.put((Object)"originatingLocationPath", (Object)originatingLocationPath.toString());
        }
    }

    private String getDisplayPath(final NodeRef nodeRef) {
        return (String)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                return PathUtil.getDisplayPath((Path)JSONConversionComponent.this.nodeService.getPath(nodeRef), (boolean)true);
            }
        });
    }

    private JSONObject setRmNodeValues(final NodeRef nodeRef, final boolean useShortQName) {
        JSONObject rmNodeValues = new JSONObject();
        rmNodeValues.put((Object)"uiType", (Object)this.getUIType(nodeRef));
        FilePlanComponentKind kind = this.filePlanService.getFilePlanComponentKind(nodeRef);
        rmNodeValues.put((Object)"kind", (Object)kind.toString());
        ChildAssociationRef assoc = this.nodeService.getPrimaryParent(nodeRef);
        if (assoc != null) {
            rmNodeValues.put((Object)"primaryParentNodeRef", (Object)assoc.getParentRef().toString());
        }
        Map values = (Map)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Map<String, Object>>(){

            public Map<String, Object> doWork() throws Exception {
                HashMap<String, Object> result = new HashMap<String, Object>();
                NodeRef filePlan = JSONConversionComponent.this.filePlanService.getFilePlan(nodeRef);
                if (filePlan != null) {
                    result.put("filePlan", filePlan.toString());
                    NodeRef unfiledRecordContainer = JSONConversionComponent.this.filePlanService.getUnfiledContainer(filePlan);
                    if (unfiledRecordContainer != null) {
                        result.put("unfiledRecordContainer", unfiledRecordContainer.toString());
                        result.put("properties", JSONConversionComponent.this.propertiesToJSON(unfiledRecordContainer, JSONConversionComponent.this.nodeService.getProperties(unfiledRecordContainer), useShortQName));
                        QName type = JSONConversionComponent.this.fileFolderService.getFileInfo(unfiledRecordContainer).getType();
                        result.put("type", useShortQName ? type.toPrefixString((NamespacePrefixResolver)JSONConversionComponent.this.namespaceService) : type.toString());
                    }
                }
                return result;
            }
        });
        rmNodeValues.putAll(values);
        this.setIndicators(rmNodeValues, nodeRef);
        this.setActions(rmNodeValues, nodeRef);
        AuthenticationUtil.runAsSystem(() -> {
            if (this.dispositionService.getNextDispositionAction(nodeRef) != null) {
                for (EventCompletionDetails details : this.dispositionService.getNextDispositionAction(nodeRef).getEventCompletionDetails()) {
                    if (details.isEventComplete()) continue;
                    HashMap properties = (HashMap)rmNodeValues.get((Object)"properties");
                    properties.put("combineDispositionStepConditions", this.nodeService.getProperty(this.dispositionService.getNextDispositionAction(nodeRef).getDispositionActionDefinition().getNodeRef(), RecordsManagementModel.PROP_COMBINE_DISPOSITION_STEP_CONDITIONS));
                    properties.put("incompleteDispositionEvent", details.getEventName());
                    properties.put("dispositionEventCombination", this.nodeService.getProperty(this.dispositionService.getNextDispositionAction(nodeRef).getDispositionActionDefinition().getNodeRef(), RecordsManagementModel.PROP_DISPOSITION_EVENT_COMBINATION));
                    break;
                }
            }
            return null;
        });
        return rmNodeValues;
    }

    private void setIndicators(JSONObject rmNodeValues, NodeRef nodeRef) {
        if (this.indicators != null && !this.indicators.isEmpty()) {
            JSONArray jsonIndicators = new JSONArray();
            for (BaseEvaluator indicator : this.indicators) {
                if (!indicator.evaluate(nodeRef)) continue;
                jsonIndicators.add((Object)indicator.getName());
            }
            rmNodeValues.put((Object)"indicators", (Object)jsonIndicators);
        }
    }

    private void setActions(JSONObject rmNodeValues, NodeRef nodeRef) {
        if (this.actions != null && !this.actions.isEmpty()) {
            JSONArray jsonActions = new JSONArray();
            for (BaseEvaluator action : this.actions) {
                if (!action.evaluate(nodeRef)) continue;
                jsonActions.add((Object)action.getName());
            }
            rmNodeValues.put((Object)"actions", (Object)jsonActions);
        }
    }

    protected JSONObject permissionsToJSON(NodeRef nodeRef) {
        JSONObject permissionsJSON = new JSONObject();
        if (!this.filePlanService.isFilePlanComponent(nodeRef)) {
            permissionsJSON = super.permissionsToJSON(nodeRef);
        } else if (AccessStatus.ALLOWED.equals((Object)this.permissionService.hasPermission(nodeRef, "ReadRecords"))) {
            permissionsJSON.put((Object)"inherited", (Object)this.permissionService.getInheritParentPermissions(nodeRef));
            permissionsJSON.put((Object)"roles", (Object)this.allSetPermissionsToJSON(nodeRef));
            permissionsJSON.put((Object)"user", (Object)this.userPermissionsToJSON(nodeRef));
        }
        return permissionsJSON;
    }

    private String getUIType(NodeRef nodeRef) {
        String result = "unknown";
        FilePlanComponentKind kind = this.filePlanService.getFilePlanComponentKind(nodeRef);
        if (kind != null) {
            switch (kind) {
                case FILE_PLAN: {
                    result = "fileplan";
                    break;
                }
                case RECORD_CATEGORY: {
                    result = "record-category";
                    break;
                }
                case RECORD_FOLDER: {
                    if (this.recordService.isMetadataStub(nodeRef)) {
                        result = "metadata-stub-folder";
                        break;
                    }
                    result = "record-folder";
                    break;
                }
                case RECORD: {
                    if (this.recordService.isMetadataStub(nodeRef)) {
                        result = "metadata-stub";
                        break;
                    }
                    if (this.recordService.isDeclared(nodeRef)) {
                        result = "record";
                        break;
                    }
                    result = "undeclared-record";
                    break;
                }
                case HOLD: {
                    result = "hold";
                    break;
                }
                case TRANSFER: {
                    result = "transfer-container";
                    break;
                }
                case UNFILED_RECORD_FOLDER: {
                    result = "unfiled-record-folder";
                    break;
                }
            }
        } else if (this.freezeService.isFrozen(nodeRef)) {
            result = FROZEN_ACTIVE_CONTENT;
        }
        return result;
    }

    public void onDeleteNode(ChildAssociationRef childAssocRef, boolean isNodeArchived) {
        this.getJsonConversionComponentCache().put((Serializable)((Object)RM_SITE_EXISTS), (Object)false);
    }

    public void onCreateNode(ChildAssociationRef childAssocRef) {
        this.getJsonConversionComponentCache().put((Serializable)((Object)RM_SITE_EXISTS), (Object)true);
    }
}

