/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script.hold;

import java.util.Collections;
import java.util.List;
import org.alfresco.module.org_alfresco_module_rm.script.hold.BaseHoldWebScriptUnitTest;
import org.alfresco.module.org_alfresco_module_rm.test.util.WebScriptExceptionMatcher;
import org.alfresco.service.cmr.repository.NodeRef;
import org.hamcrest.Matcher;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.springframework.extensions.webscripts.WebScriptException;

public abstract class BaseHoldWebScriptWithContentUnitTest
extends BaseHoldWebScriptUnitTest {
    protected String buildContent(List<NodeRef> nodeRefs, List<NodeRef> holds) {
        boolean bFirst;
        StringBuilder builder = new StringBuilder(255);
        builder.append("{");
        if (nodeRefs != null) {
            builder.append("'nodeRefs':[");
            bFirst = true;
            for (NodeRef nodeRef : nodeRefs) {
                if (!bFirst) {
                    builder.append(",");
                } else {
                    bFirst = false;
                }
                builder.append("'" + nodeRef.toString() + "'");
            }
            builder.append("]");
        }
        if (nodeRefs != null && holds != null) {
            builder.append(",");
        }
        if (holds != null) {
            builder.append("'holds':[");
            bFirst = true;
            for (NodeRef hold : holds) {
                if (!bFirst) {
                    builder.append(",");
                } else {
                    bFirst = false;
                }
                builder.append("'" + hold.toString() + "'");
            }
            builder.append("]");
        }
        builder.append("}");
        return builder.toString();
    }

    @Test
    public void sendInvalidJSON() throws Exception {
        String content = "invalid JSON";
        this.exception.expect(WebScriptException.class);
        this.exception.expect((Matcher)WebScriptExceptionMatcher.badRequest());
        this.executeWebScript(Collections.EMPTY_MAP, content);
    }

    @Test
    public void holdDoesNotExist() throws Exception {
        Mockito.when((Object)this.mockedNodeService.exists((NodeRef)Matchers.eq((Object)this.hold1NodeRef))).thenReturn((Object)false);
        String content = this.buildContent(this.records, this.holds);
        this.exception.expect(WebScriptException.class);
        this.exception.expect((Matcher)WebScriptExceptionMatcher.badRequest());
        this.executeWebScript(Collections.EMPTY_MAP, content);
    }

    @Test
    public void nodeRefDoesNotExist() throws Exception {
        Mockito.when((Object)this.mockedNodeService.exists((NodeRef)Matchers.eq((Object)this.record))).thenReturn((Object)false);
        String content = this.buildContent(this.records, this.holds);
        this.exception.expect(WebScriptException.class);
        this.exception.expect((Matcher)WebScriptExceptionMatcher.badRequest());
        this.executeWebScript(Collections.EMPTY_MAP, content);
    }

    @Test
    public void holdMissingFromContent() throws Exception {
        String content = this.buildContent(this.records, null);
        this.exception.expect(WebScriptException.class);
        this.exception.expect((Matcher)WebScriptExceptionMatcher.badRequest());
        this.executeWebScript(Collections.EMPTY_MAP, content);
    }

    @Test
    public void nodeRefMissingFromContent() throws Exception {
        String content = this.buildContent(null, this.holds);
        this.exception.expect(WebScriptException.class);
        this.exception.expect((Matcher)WebScriptExceptionMatcher.badRequest());
        this.executeWebScript(Collections.EMPTY_MAP, content);
    }

    @Test
    public void holdIsNotAHold() throws Exception {
        List<NodeRef> notAHold = Collections.singletonList(this.recordFolder);
        String content = this.buildContent(this.records, notAHold);
        this.exception.expect(WebScriptException.class);
        this.exception.expect((Matcher)WebScriptExceptionMatcher.badRequest());
        this.executeWebScript(Collections.EMPTY_MAP, content);
    }

    @Test
    public void nodeRefIsNotARecordOrRecordFolderOrActiveContent() throws Exception {
        String content = this.buildContent(this.filePlanComponents, this.holds);
        this.exception.expect(WebScriptException.class);
        this.exception.expect((Matcher)WebScriptExceptionMatcher.badRequest());
        this.executeWebScript(Collections.EMPTY_MAP, content);
    }
}

