/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model.rma.aspect;

import org.alfresco.module.org_alfresco_module_rm.model.rma.aspect.VersionRecordAspect;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipService;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionModel;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class VersionRecordAspectUnitTest
extends BaseUnitTest {
    @Mock
    private VersionHistory mockedVersionHistory;
    @Mock
    private Version mockedVersion;
    @Mock
    private VersionService mockedVersionService;
    @Mock
    private RelationshipService mockedRelationshipService;
    @InjectMocks
    private VersionRecordAspect versionRecordAspect;

    @Test
    public void beforeDeleteNoVersionNodeRef() {
        NodeRef nodeRef = this.generateNodeRef();
        Mockito.when((Object)this.mockedRecordableVersionService.getRecordedVersion(nodeRef)).thenReturn(null);
        this.versionRecordAspect.beforeDeleteNode(nodeRef);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.never())).getProperty(nodeRef, RecordableVersionModel.PROP_VERSION_LABEL);
        ((RecordableVersionService)Mockito.verify((Object)this.mockedRecordableVersionService, (VerificationMode)Mockito.never())).destroyRecordedVersion((Version)Matchers.any(Version.class));
    }

    @Test
    public void beforeDeleteMarkVersionDestroyed() {
        NodeRef nodeRef = this.generateNodeRef();
        Mockito.when((Object)this.mockedRecordableVersionService.getRecordedVersion(nodeRef)).thenReturn((Object)this.mockedVersion);
        this.versionRecordAspect.beforeDeleteNode(nodeRef);
        ((RecordableVersionService)Mockito.verify((Object)this.mockedRecordableVersionService)).destroyRecordedVersion(this.mockedVersion);
    }
}

