/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.email;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.dod5015.DOD5015Model;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;

public class RFC822MetadataExtracter
extends org.alfresco.repo.content.metadata.RFC822MetadataExtracter {
    private static final String PROPERTIES_URL = "alfresco/metadata/RFC822MetadataExtracter.properties";
    private NodeService nodeService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    protected void filterSystemProperties(Map<QName, Serializable> systemProperties, Map<QName, Serializable> targetProperties) {
        HashMap<QName, Serializable> clone;
        NodeRef nodeRef = this.getNodeRef(targetProperties);
        if (nodeRef == null) {
            return;
        }
        if (!this.nodeService.hasAspect(nodeRef, RecordsManagementModel.ASPECT_RECORD)) {
            clone = new HashMap<QName, Serializable>(systemProperties);
            for (QName propName : clone.keySet()) {
                if (!"http://www.alfresco.org/model/recordsmanagement/1.0".equals(propName.getNamespaceURI())) continue;
                systemProperties.remove(propName);
            }
        }
        if (!this.nodeService.hasAspect(nodeRef, DOD5015Model.ASPECT_DOD_5015_RECORD)) {
            clone = new HashMap<QName, Serializable>(systemProperties);
            for (QName propName : clone.keySet()) {
                if (!"http://www.alfresco.org/model/dod5015/1.0".equals(propName.getNamespaceURI())) continue;
                systemProperties.remove(propName);
            }
        }
    }

    protected Map<String, Set<QName>> getDefaultMapping() {
        return this.readMappingProperties(PROPERTIES_URL);
    }

    private NodeRef getNodeRef(Map<QName, Serializable> properties) {
        NodeRef result = null;
        String storeProto = (String)((Object)properties.get(ContentModel.PROP_STORE_PROTOCOL));
        String storeId = (String)((Object)properties.get(ContentModel.PROP_STORE_IDENTIFIER));
        String nodeId = (String)((Object)properties.get(ContentModel.PROP_NODE_UUID));
        if (storeProto != null && storeProto.length() != 0 && storeId != null && storeId.length() != 0 && nodeId != null && nodeId.length() != 0) {
            result = new NodeRef(new StoreRef(storeProto, storeId), nodeId);
        }
        return result;
    }
}

