/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.audit.extractor;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.repo.audit.extractor.AbstractDataExtractor;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.rule.RuleService;

public final class FilePlanNodeRefPathDataExtractor
extends AbstractDataExtractor {
    private NodeService nodeService;
    private FilePlanService filePlanService;
    private RuleService ruleService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public boolean isSupported(Serializable data) {
        if (!(data instanceof NodeRef)) {
            return false;
        }
        return this.nodeService.hasAspect((NodeRef)data, RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable extractData(Serializable value) {
        Serializable extractedData = null;
        this.ruleService.disableRules();
        try {
            NodeRef nodeRef = (NodeRef)value;
            List<NodeRef> nodeRefPath = this.filePlanService.getNodeRefPath(nodeRef);
            extractedData = (Serializable)((Object)nodeRefPath);
        }
        finally {
            this.ruleService.enableRules();
        }
        return extractedData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FilePlanNodeRefPathDataExtractor that = (FilePlanNodeRefPathDataExtractor)((Object)o);
        return Objects.equals(this.nodeService, that.nodeService) && Objects.equals(this.filePlanService, that.filePlanService) && Objects.equals(this.ruleService, that.ruleService);
    }

    public int hashCode() {
        return Objects.hash(this.nodeService, this.filePlanService, this.ruleService);
    }
}

