/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.patch.v22;

import java.util.Collections;
import java.util.HashSet;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.patch.v22.RMv22RemoveInPlaceRolesFromAllPatch;
import org.alfresco.module.org_alfresco_module_rm.role.FilePlanRoleService;
import org.alfresco.module.org_alfresco_module_rm.role.Role;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.service.cmr.security.AuthorityService;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class RMv22RemoveInPlaceRolesFromAllPatchUnitTest
extends BaseUnitTest {
    private static final String ALL_ROLES = "allroles";
    @InjectMocks
    private RMv22RemoveInPlaceRolesFromAllPatch patch;

    @Test
    public void noFilePlans() {
        ((FilePlanService)Mockito.doReturn((Object)Collections.EMPTY_SET).when((Object)this.mockedFilePlanService)).getFilePlans();
        this.patch.applyInternal();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.mockedAuthorityService});
    }

    @Test
    public void rolesDontNeedRemovingFromGroup() {
        ((FilePlanService)Mockito.doReturn(Collections.singleton(this.filePlan)).when((Object)this.mockedFilePlanService)).getFilePlans();
        ((FilePlanRoleService)Mockito.doReturn((Object)this.getMockedRole("ExtendedReaders")).when((Object)this.mockedFilePlanRoleService)).getRole(this.filePlan, "ExtendedReaders");
        ((FilePlanRoleService)Mockito.doReturn((Object)this.getMockedRole("ExtendedWriters")).when((Object)this.mockedFilePlanRoleService)).getRole(this.filePlan, "ExtendedWriters");
        ((FilePlanRoleService)Mockito.doReturn((Object)ALL_ROLES).when((Object)this.mockedFilePlanRoleService)).getAllRolesContainerGroup(this.filePlan);
        ((AuthorityService)Mockito.doReturn((Object)Collections.EMPTY_SET).when((Object)this.mockedAuthorityService)).getContainedAuthorities(null, ALL_ROLES, true);
        this.patch.applyInternal();
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService, (VerificationMode)Mockito.times((int)1))).getContainedAuthorities(null, ALL_ROLES, true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedAuthorityService});
    }

    @Test
    public void removeRolesFromGroup() {
        ((FilePlanService)Mockito.doReturn(Collections.singleton(this.filePlan)).when((Object)this.mockedFilePlanService)).getFilePlans();
        ((FilePlanRoleService)Mockito.doReturn((Object)this.getMockedRole("ExtendedReaders")).when((Object)this.mockedFilePlanRoleService)).getRole(this.filePlan, "ExtendedReaders");
        ((FilePlanRoleService)Mockito.doReturn((Object)this.getMockedRole("ExtendedWriters")).when((Object)this.mockedFilePlanRoleService)).getRole(this.filePlan, "ExtendedWriters");
        ((FilePlanRoleService)Mockito.doReturn((Object)ALL_ROLES).when((Object)this.mockedFilePlanRoleService)).getAllRolesContainerGroup(this.filePlan);
        HashSet<String> contains = new HashSet<String>(2);
        contains.add("ExtendedReaders");
        contains.add("ExtendedWriters");
        ((AuthorityService)Mockito.doReturn(contains).when((Object)this.mockedAuthorityService)).getContainedAuthorities(null, ALL_ROLES, true);
        this.patch.applyInternal();
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService, (VerificationMode)Mockito.times((int)1))).getContainedAuthorities(null, ALL_ROLES, true);
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService, (VerificationMode)Mockito.times((int)1))).removeAuthority(ALL_ROLES, "ExtendedReaders");
        ((AuthorityService)Mockito.verify((Object)this.mockedAuthorityService, (VerificationMode)Mockito.times((int)1))).removeAuthority(ALL_ROLES, "ExtendedWriters");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedAuthorityService});
    }

    private Role getMockedRole(String name) {
        Role mockedRole = (Role)Mockito.mock(Role.class);
        ((Role)Mockito.doReturn((Object)name).when((Object)mockedRole)).getRoleGroupName();
        return mockedRole;
    }
}

