/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.repo.action.CompositeActionImpl;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.rule.RuleServiceImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.surf.util.I18NUtil;

public class ExtendedRuleServiceImpl
extends RuleServiceImpl {
    private static final String MSG_RETENTION_PERIOD_NOT_VALID = "rm.action.worm-retention-period-not-valid";
    private static final String PARAM_RETENTION_PERIOD = "retentionPeriod";
    private static final String POSITIVE_INTEGERS_PATTERN = "^\\+?([1-9]\\d*)$";
    private static final String WORM_LOCK_ACTION = "wormLock";
    private boolean runAsAdmin = true;
    private Set<QName> ignoredTypes = new HashSet<QName>();
    private FilePlanService filePlanService;
    protected NodeService nodeService;
    protected RecordService recordService;

    public void setNodeService2(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setRecordService(RecordService recordService) {
        this.recordService = recordService;
    }

    public void setRunAsAdmin(boolean runAsAdmin) {
        this.runAsAdmin = runAsAdmin;
    }

    public void init() {
        super.init();
        this.ignoredTypes.add(RecordsManagementModel.TYPE_DISPOSITION_SCHEDULE);
        this.ignoredTypes.add(RecordsManagementModel.TYPE_DISPOSITION_ACTION);
        this.ignoredTypes.add(RecordsManagementModel.TYPE_DISPOSITION_ACTION_DEFINITION);
        this.ignoredTypes.add(RecordsManagementModel.TYPE_EVENT_EXECUTION);
    }

    private void validateWormLockRuleAction(Rule rule) {
        try {
            CompositeActionImpl compositeAction = (CompositeActionImpl)rule.getAction();
            Pattern pattern = Pattern.compile(POSITIVE_INTEGERS_PATTERN);
            for (Action action : compositeAction.getActions()) {
                Matcher matcher;
                String retentionPeriodParamValue;
                if (!WORM_LOCK_ACTION.equals(action.getActionDefinitionName()) || (retentionPeriodParamValue = (String)((Object)action.getParameterValue(PARAM_RETENTION_PERIOD))) == null || (matcher = pattern.matcher(retentionPeriodParamValue)).matches()) continue;
                throw new IntegrityException(I18NUtil.getMessage((String)MSG_RETENTION_PERIOD_NOT_VALID), null);
            }
        }
        catch (PatternSyntaxException ex) {
            throw new IntegrityException(I18NUtil.getMessage((String)MSG_RETENTION_PERIOD_NOT_VALID), null);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void saveRule(final NodeRef nodeRef, final Rule rule) {
        this.validateWormLockRuleAction(rule);
        if (this.filePlanService.isFilePlanComponent(nodeRef)) {
            AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() {
                    ExtendedRuleServiceImpl.super.saveRule(nodeRef, rule);
                    return null;
                }
            });
        } else {
            super.saveRule(nodeRef, rule);
        }
    }

    public void removeRule(final NodeRef nodeRef, final Rule rule) {
        if (this.filePlanService.isFilePlanComponent(nodeRef)) {
            AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() {
                    ExtendedRuleServiceImpl.super.removeRule(nodeRef, rule);
                    return null;
                }
            });
        } else {
            super.removeRule(nodeRef, rule);
        }
    }

    public void executeRule(final Rule rule, final NodeRef nodeRef, final Set<RuleServiceImpl.ExecutedRuleData> executedRules) {
        if (this.nodeService.exists(nodeRef)) {
            QName typeQName = this.nodeService.getType(nodeRef);
            if (this.filePlanService.isFilePlanComponent(nodeRef) && this.isFilePlanComponentRule(rule)) {
                if (!this.isIgnoredType(typeQName)) {
                    if (this.runAsAdmin) {
                        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                            public Void doWork() {
                                ExtendedRuleServiceImpl.super.executeRule(rule, nodeRef, executedRules);
                                return null;
                            }
                        }, (String)AuthenticationUtil.getAdminUserName());
                    } else {
                        super.executeRule(rule, nodeRef, executedRules);
                    }
                }
            } else {
                super.executeRule(rule, nodeRef, executedRules);
            }
        }
    }

    private boolean isFilePlanComponentRule(Rule rule) {
        NodeRef nodeRef = this.getOwningNodeRef(rule);
        return this.filePlanService.isFilePlanComponent(nodeRef);
    }

    private boolean isIgnoredType(QName typeQName) {
        return this.ignoredTypes.contains(typeQName);
    }
}

