/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.records;

import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.record.RecordMissingMetadataException;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.module.org_alfresco_module_rm.util.RMParameterCheck;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.rest.framework.BinaryProperties;
import org.alfresco.rest.framework.Operation;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.actions.interfaces.BinaryResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.content.BinaryResource;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.alfresco.rm.rest.api.impl.ApiNodesModelFactory;
import org.alfresco.rm.rest.api.impl.FilePlanComponentsApiUtils;
import org.alfresco.rm.rest.api.model.Record;
import org.alfresco.rm.rest.api.model.TargetContainer;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.ConcurrencyFailureException;

@EntityResource(name="records", title="Records")
public class RecordsEntityResource
implements BinaryResourceAction.Read,
EntityResourceAction.ReadById<Record>,
EntityResourceAction.Delete,
EntityResourceAction.Update<Record>,
InitializingBean {
    private ApiNodesModelFactory nodesModelFactory;
    private FilePlanComponentsApiUtils apiUtils;
    private FileFolderService fileFolderService;
    private RecordService recordService;
    private NodeService nodeService;
    private TransactionService transactionService;

    public void setNodesModelFactory(ApiNodesModelFactory nodesModelFactory) {
        this.nodesModelFactory = nodesModelFactory;
    }

    public void setApiUtils(FilePlanComponentsApiUtils apiUtils) {
        this.apiUtils = apiUtils;
    }

    public void setRecordService(RecordService recordService) {
        this.recordService = recordService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    @WebApiDescription(title="Download content", description="Download content for a record with id 'recordId'")
    @BinaryProperties(value={"content"})
    public BinaryResource readProperty(String recordId, Parameters parameters) throws EntityNotFoundException {
        RMParameterCheck.checkNotBlank("recordId", recordId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef record = this.apiUtils.validateRecord(recordId);
        if (this.nodeService.getType(record).equals((Object)RecordsManagementModel.TYPE_NON_ELECTRONIC_DOCUMENT)) {
            throw new IllegalArgumentException("Cannot read content from Non-electronic record " + recordId + ".");
        }
        BinaryResource content = this.apiUtils.getContent(record, parameters, true);
        NodeRef primaryParent = this.nodeService.getPrimaryParent(record).getParentRef();
        FileInfo info = this.fileFolderService.getFileInfo(record);
        this.apiUtils.postActivity(info, primaryParent, "org.alfresco.documentlibrary.file-downloaded");
        return content;
    }

    @Operation(value="file")
    @WebApiDescription(title="File record", description="File a record into fileplan.")
    public Record fileRecord(String recordId, TargetContainer target, Parameters parameters, WithResponse withResponse) {
        RMParameterCheck.checkNotBlank("recordId", recordId);
        ParameterCheck.mandatory((String)"target", (Object)target);
        ParameterCheck.mandatory((String)"targetParentId", (Object)target.getTargetParentId());
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef record = this.apiUtils.validateRecord(recordId);
        NodeRef targetRecordFolder = this.apiUtils.lookupAndValidateNodeType(target.getTargetParentId(), RecordsManagementModel.TYPE_RECORD_FOLDER);
        NodeRef primaryParent = this.nodeService.getPrimaryParent(record).getParentRef();
        if (RecordsManagementModel.TYPE_RECORD_FOLDER.equals((Object)this.nodeService.getType(primaryParent))) {
            this.recordService.link(record, targetRecordFolder);
        } else {
            try {
                this.fileFolderService.moveFrom(record, primaryParent, targetRecordFolder, null);
            }
            catch (FileExistsException e) {
                throw new IntegrityException(e.getMessage(), null);
            }
            catch (FileNotFoundException e) {
                throw new ConcurrencyFailureException("The record was deleted while filing it", (Throwable)e);
            }
        }
        FileInfo info = this.fileFolderService.getFileInfo(record);
        return this.nodesModelFactory.createRecord(info, parameters, null, false);
    }

    @WebApiDescription(title="Get record information", description="Gets information for a record with id 'recordId'")
    @WebApiParam(name="recordId", title="The record id")
    public Record readById(String recordId, Parameters parameters) {
        RMParameterCheck.checkNotBlank("recordId", recordId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef record = this.apiUtils.validateRecord(recordId);
        FileInfo info = this.fileFolderService.getFileInfo(record);
        return this.nodesModelFactory.createRecord(info, parameters, null, false);
    }

    @WebApiDescription(title="Update record", description="Updates a record with id 'recordId'")
    public Record update(String recordId, final Record recordInfo, final Parameters parameters) {
        RMParameterCheck.checkNotBlank("recordId", recordId);
        ParameterCheck.mandatory((String)"recordInfo", (Object)recordInfo);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        final NodeRef record = this.apiUtils.validateRecord(recordId);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() {
                RecordsEntityResource.this.apiUtils.updateNode(record, recordInfo, parameters);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<FileInfo> readCallback = new RetryingTransactionHelper.RetryingTransactionCallback<FileInfo>(){

            public FileInfo execute() {
                return RecordsEntityResource.this.fileFolderService.getFileInfo(record);
            }
        };
        FileInfo info = (FileInfo)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)readCallback, false, true);
        this.apiUtils.postActivity(info, recordInfo.getParentId(), "org.alfresco.documentlibrary.file-updated");
        return this.nodesModelFactory.createRecord(info, parameters, null, false);
    }

    @Operation(value="complete")
    @WebApiDescription(title="Complete record", description="Complete a record.")
    public Record completeRecord(String recordId, Void body, Parameters parameters, WithResponse withResponse) {
        RMParameterCheck.checkNotBlank("recordId", recordId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef record = this.apiUtils.validateRecord(recordId);
        try {
            this.recordService.complete(record);
        }
        catch (RecordMissingMetadataException e) {
            throw new IntegrityException("The record has missing mandatory properties.", null);
        }
        FileInfo info = this.fileFolderService.getFileInfo(record);
        return this.nodesModelFactory.createRecord(info, parameters, null, false);
    }

    @WebApiDescription(title="Delete record", description="Deletes a record with id 'recordId'")
    public void delete(String recordId, Parameters parameters) {
        RMParameterCheck.checkNotBlank("recordId", recordId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef record = this.apiUtils.validateRecord(recordId);
        this.fileFolderService.delete(record);
    }

    public void afterPropertiesSet() throws Exception {
        ParameterCheck.mandatory((String)"nodesModelFactory", (Object)this.nodesModelFactory);
        ParameterCheck.mandatory((String)"apiUtils", (Object)this.apiUtils);
        ParameterCheck.mandatory((String)"fileFolderService", (Object)this.fileFolderService);
        ParameterCheck.mandatory((String)"recordService", (Object)this.recordService);
        ParameterCheck.mandatory((String)"nodeService", (Object)this.nodeService);
    }
}

