/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.webscript;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMWebScriptTestCase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.util.GUID;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class RmAuthoritiesRestApiTest
extends BaseRMWebScriptTestCase {
    private static final String RM_CHILDREN_URL = "/api/rm/%s/roles/%s/authorities/%s";
    private static final String APPLICATION_JSON = "application/json";
    private static final String USER_WITH_CAPABILITY = GUID.generate();
    private static final String USER_WITHOUT_CAPABILITY = GUID.generate();
    private static final String ROLE_INCLUDING_CAPABILITY = GUID.generate();
    private static final String ROLE_NOT_INCLUDING_CAPABILITY = GUID.generate();
    private static final String USER_TO_ADD_TO_ROLE = GUID.generate();
    private static final String GROUP_TO_ADD_TO_ROLE = GUID.generate();

    @Override
    protected void setupTestData() {
        super.setupTestData();
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
                RmAuthoritiesRestApiTest.this.createUser(USER_WITH_CAPABILITY);
                HashSet<Capability> capabilities = new HashSet<Capability>(2);
                capabilities.add(RmAuthoritiesRestApiTest.this.capabilityService.getCapability("ViewRecords"));
                capabilities.add(RmAuthoritiesRestApiTest.this.capabilityService.getCapability("ManageAccessControls"));
                RmAuthoritiesRestApiTest.this.filePlanRoleService.createRole(RmAuthoritiesRestApiTest.this.filePlan, ROLE_INCLUDING_CAPABILITY, ROLE_INCLUDING_CAPABILITY, capabilities);
                RmAuthoritiesRestApiTest.this.filePlanRoleService.assignRoleToAuthority(RmAuthoritiesRestApiTest.this.filePlan, ROLE_INCLUDING_CAPABILITY, USER_WITH_CAPABILITY);
                RmAuthoritiesRestApiTest.this.createUser(USER_WITHOUT_CAPABILITY);
                RmAuthoritiesRestApiTest.this.filePlanRoleService.createRole(RmAuthoritiesRestApiTest.this.filePlan, ROLE_NOT_INCLUDING_CAPABILITY, ROLE_NOT_INCLUDING_CAPABILITY, new HashSet(1));
                RmAuthoritiesRestApiTest.this.filePlanRoleService.assignRoleToAuthority(RmAuthoritiesRestApiTest.this.filePlan, ROLE_NOT_INCLUDING_CAPABILITY, USER_WITHOUT_CAPABILITY);
                RmAuthoritiesRestApiTest.this.createUser(USER_TO_ADD_TO_ROLE);
                RmAuthoritiesRestApiTest.this.createGroup(GROUP_TO_ADD_TO_ROLE);
                return null;
            }
        });
    }

    @Override
    protected void tearDownImpl() {
        super.tearDownImpl();
        this.deleteUser(USER_WITH_CAPABILITY);
        this.filePlanRoleService.deleteRole(this.filePlan, ROLE_INCLUDING_CAPABILITY);
        this.deleteUser(USER_WITHOUT_CAPABILITY);
        this.filePlanRoleService.deleteRole(this.filePlan, ROLE_NOT_INCLUDING_CAPABILITY);
        this.deleteUser(this.getTestUserName());
        this.deleteGroup(this.getTestGroupName());
    }

    public void testRmAddRemoveUser() throws IOException, JSONException {
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_WITH_CAPABILITY);
        String userName = this.getTestUserName();
        RmAuthoritiesRestApiTest.assertFalse((boolean)this.getUsersAssignedToRole().contains(userName));
        String url = this.getFormattedUrlString(userName);
        this.checkContent(this.postRequestSuccess(url));
        RmAuthoritiesRestApiTest.assertTrue((boolean)this.getUsersAssignedToRole().contains(userName));
        this.checkContent(this.deleteRequestSuccess(url));
        RmAuthoritiesRestApiTest.assertFalse((boolean)this.getUsersAssignedToRole().contains(userName));
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_WITHOUT_CAPABILITY);
        this.postRequestFailure(url);
    }

    public void testRmAddRemoveGroup() throws IOException, JSONException {
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_WITH_CAPABILITY);
        String groupName = this.getTestGroupName();
        RmAuthoritiesRestApiTest.assertFalse((boolean)this.getGroupsAssignedToRole().contains(groupName));
        String url = this.getFormattedUrlString(groupName);
        this.checkContent(this.postRequestSuccess(url));
        RmAuthoritiesRestApiTest.assertTrue((boolean)this.getGroupsAssignedToRole().contains(groupName));
        this.checkContent(this.deleteRequestSuccess(url));
        RmAuthoritiesRestApiTest.assertFalse((boolean)this.getGroupsAssignedToRole().contains(groupName));
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_WITHOUT_CAPABILITY);
        this.deleteRequestFailure(url);
    }

    private String getTestUserName() {
        return this.authorityService.getName(AuthorityType.USER, USER_TO_ADD_TO_ROLE);
    }

    private String getTestGroupName() {
        return this.authorityService.getName(AuthorityType.GROUP, GROUP_TO_ADD_TO_ROLE);
    }

    private Set<String> getGroupsAssignedToRole() {
        return this.filePlanRoleService.getGroupsAssignedToRole(this.filePlan, "SecurityOfficer");
    }

    private Set<String> getUsersAssignedToRole() {
        return this.filePlanRoleService.getUsersAssignedToRole(this.filePlan, "SecurityOfficer");
    }

    private String getFormattedFilePlanString() {
        StoreRef storeRef = this.filePlan.getStoreRef();
        String storeType = storeRef.getProtocol();
        String storeId = storeRef.getIdentifier();
        String id = this.filePlan.getId();
        StringBuffer sb = new StringBuffer(32);
        sb.append(storeType);
        sb.append("/");
        sb.append(storeId);
        sb.append("/");
        sb.append(id);
        return sb.toString();
    }

    private String getFormattedUrlString(String authorityName) {
        return String.format(RM_CHILDREN_URL, this.getFormattedFilePlanString(), "SecurityOfficer", authorityName);
    }

    private TestWebScriptServer.Response postRequestSuccess(String url) throws UnsupportedEncodingException, IOException {
        return this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(url, new JSONObject().toString(), APPLICATION_JSON), 200);
    }

    private TestWebScriptServer.Response postRequestFailure(String url) throws UnsupportedEncodingException, IOException {
        return this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(url, new JSONObject().toString(), APPLICATION_JSON), 500);
    }

    private TestWebScriptServer.Response deleteRequestSuccess(String url) throws IOException {
        return this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(url), 200);
    }

    private TestWebScriptServer.Response deleteRequestFailure(String url) throws IOException {
        return this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(url), 500);
    }

    private void checkContent(TestWebScriptServer.Response response) throws UnsupportedEncodingException {
        String contentAsString = response.getContentAsString();
        RmAuthoritiesRestApiTest.assertNotNull((Object)contentAsString);
        RmAuthoritiesRestApiTest.assertTrue((boolean)contentAsString.contains("{}"));
    }
}

