/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.patch.v24;

import java.util.Collections;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.patch.v24.RMv24FilePlanContainerRuleInheritancePatch;
import org.alfresco.module.org_alfresco_module_rm.test.util.AlfMock;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class RMv24FilePlanContainerRuleInheritancePatchUnitTest {
    @Mock
    private NodeService mockedNodeService;
    @Mock
    private FilePlanService mockedFilePlanService;
    @InjectMocks
    private RMv24FilePlanContainerRuleInheritancePatch patch;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void noFilePlans() {
        Mockito.when((Object)this.mockedFilePlanService.getFilePlans()).thenReturn((Object)Collections.EMPTY_SET);
        this.patch.applyInternal();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.mockedNodeService});
    }

    @Test
    public void atLeastOneFilePlan() {
        NodeRef filePlan = AlfMock.generateNodeRef(this.mockedNodeService, RecordsManagementModel.TYPE_FILE_PLAN);
        NodeRef holdsContainer = AlfMock.generateNodeRef(this.mockedNodeService);
        NodeRef transferContainer = AlfMock.generateNodeRef(this.mockedNodeService);
        NodeRef unfiledRecordsContainer = AlfMock.generateNodeRef(this.mockedNodeService);
        Mockito.when((Object)this.mockedFilePlanService.getFilePlans()).thenReturn(Collections.singleton(filePlan));
        Mockito.when((Object)this.mockedFilePlanService.getHoldContainer(filePlan)).thenReturn((Object)holdsContainer);
        Mockito.when((Object)this.mockedFilePlanService.getTransferContainer(filePlan)).thenReturn((Object)transferContainer);
        Mockito.when((Object)this.mockedFilePlanService.getUnfiledContainer(filePlan)).thenReturn((Object)unfiledRecordsContainer);
        this.patch.applyInternal();
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).addAspect(holdsContainer, RuleModel.ASPECT_IGNORE_INHERITED_RULES, null);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).addAspect(transferContainer, RuleModel.ASPECT_IGNORE_INHERITED_RULES, null);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).addAspect(unfiledRecordsContainer, RuleModel.ASPECT_IGNORE_INHERITED_RULES, null);
    }
}

