/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.requests.gscore.api;

import org.alfresco.rest.core.RMRestWrapper;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.rm.community.model.hold.BulkBodyCancel;
import org.alfresco.rest.rm.community.model.hold.Hold;
import org.alfresco.rest.rm.community.model.hold.HoldBulkOperation;
import org.alfresco.rest.rm.community.model.hold.HoldBulkOperationEntry;
import org.alfresco.rest.rm.community.model.hold.HoldBulkStatus;
import org.alfresco.rest.rm.community.model.hold.HoldBulkStatusCollection;
import org.alfresco.rest.rm.community.model.hold.HoldChild;
import org.alfresco.rest.rm.community.model.hold.HoldChildCollection;
import org.alfresco.rest.rm.community.model.hold.HoldDeletionReason;
import org.alfresco.rest.rm.community.requests.RMModelRequest;
import org.alfresco.rest.rm.community.util.ParameterCheck;
import org.alfresco.rest.rm.community.util.PojoUtility;
import org.springframework.http.HttpMethod;

public class HoldsAPI
extends RMModelRequest {
    public HoldsAPI(RMRestWrapper rmRestWrapper) {
        super(rmRestWrapper);
    }

    public Hold getHold(String holdId, String parameters) {
        ParameterCheck.mandatoryString("holdId", holdId);
        return this.getRmRestWrapper().processModel(Hold.class, RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)"holds/{holdId}?{parameters}", (String[])new String[]{holdId, parameters}));
    }

    public Hold getHold(String holdId) {
        ParameterCheck.mandatoryString("holdId", holdId);
        return this.getHold(holdId, "");
    }

    public Hold updateHold(Hold holdModel, String holdId, String parameters) {
        ParameterCheck.mandatoryObject("holdModel", (Object)holdModel);
        ParameterCheck.mandatoryString("holdId", holdId);
        return this.getRmRestWrapper().processModel(Hold.class, RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)PojoUtility.toJson((Object)holdModel), (String)"holds/{holdId}?{parameters}", (String[])new String[]{holdId, parameters}));
    }

    public Hold updateHold(Hold holdModel, String holdId) {
        ParameterCheck.mandatoryObject("holdModel", (Object)holdModel);
        ParameterCheck.mandatoryString("holdId", holdId);
        return this.updateHold(holdModel, holdId, "");
    }

    public void deleteHold(String holdId) {
        ParameterCheck.mandatoryString("holdId", holdId);
        this.getRmRestWrapper().processEmptyModel(RestRequest.simpleRequest((HttpMethod)HttpMethod.DELETE, (String)"holds/{holdId}", (String[])new String[]{holdId}));
    }

    public HoldDeletionReason deleteHoldWithReason(HoldDeletionReason reason, String holdId) {
        ParameterCheck.mandatoryObject("reason", (Object)reason);
        ParameterCheck.mandatoryString("holdId", holdId);
        return this.getRmRestWrapper().processModel(HoldDeletionReason.class, RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)PojoUtility.toJson((Object)reason), (String)"holds/{holdId}/delete", (String[])new String[]{holdId}));
    }

    public HoldChild addChildToHold(HoldChild holdChild, String holdId, String parameters) {
        ParameterCheck.mandatoryObject("holdId", holdId);
        return this.getRmRestWrapper().processModel(HoldChild.class, RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)PojoUtility.toJson((Object)holdChild), (String)"holds/{holdId}/children", (String[])new String[]{holdId, parameters}));
    }

    public HoldChild addChildToHold(HoldChild holdChild, String holdId) {
        return this.addChildToHold(holdChild, holdId, "");
    }

    public HoldChildCollection getChildren(String holdId, String parameters) {
        ParameterCheck.mandatoryString("holdId", holdId);
        return this.getRmRestWrapper().processModels(HoldChildCollection.class, RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)"holds/{holdId}/children", (String[])new String[]{holdId, parameters}));
    }

    public HoldChildCollection getChildren(String holdId) {
        return this.getChildren(holdId, "");
    }

    public void deleteHoldChild(String holdId, String holdChildId, String parameters) {
        ParameterCheck.mandatoryString("holdId", holdId);
        ParameterCheck.mandatoryString("holdChildId", holdChildId);
        this.getRmRestWrapper().processEmptyModel(RestRequest.simpleRequest((HttpMethod)HttpMethod.DELETE, (String)"holds/{holdId}/children/{holdChildId}", (String[])new String[]{holdId, holdChildId, parameters}));
    }

    public void deleteHoldChild(String holdId, String holdChildId) {
        this.deleteHoldChild(holdId, holdChildId, "");
    }

    public HoldBulkOperationEntry startBulkProcess(HoldBulkOperation holdBulkOperation, String hold, String parameters) {
        ParameterCheck.mandatoryObject("holdBulkOperation", (Object)holdBulkOperation);
        ParameterCheck.mandatoryString("hold", hold);
        return this.getRmRestWrapper().processModel(HoldBulkOperationEntry.class, RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)PojoUtility.toJson((Object)holdBulkOperation), (String)"holds/{hold}/bulk", (String[])new String[]{hold, parameters}));
    }

    public HoldBulkOperationEntry startBulkProcess(HoldBulkOperation holdBulkOperation, String hold) {
        return this.startBulkProcess(holdBulkOperation, hold, "");
    }

    public HoldBulkStatus getBulkStatus(String holdId, String holdBulkStatusId, String parameters) {
        ParameterCheck.mandatoryString("holdId", holdId);
        ParameterCheck.mandatoryString("holdBulkStatusId", holdBulkStatusId);
        return this.getRmRestWrapper().processModel(HoldBulkStatus.class, RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)"holds/{holdId}/bulk-statuses/{holdBulkStatusId}", (String[])new String[]{holdId, holdBulkStatusId, parameters}));
    }

    public HoldBulkStatus getBulkStatus(String holdId, String holdBulkStatusId) {
        return this.getBulkStatus(holdId, holdBulkStatusId, "");
    }

    public HoldBulkStatusCollection getBulkStatuses(String holdId, String parameters) {
        ParameterCheck.mandatoryString("holdId", holdId);
        return this.getRmRestWrapper().processModels(HoldBulkStatusCollection.class, RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)"holds/{holdId}/bulk-statuses", (String[])new String[]{holdId, parameters}));
    }

    public HoldBulkStatusCollection getBulkStatuses(String holdId) {
        return this.getBulkStatuses(holdId, "");
    }

    public void cancelBulkOperation(String holdId, String bulkStatusId, BulkBodyCancel bulkBodyCancel, String parameters) {
        ParameterCheck.mandatoryString("holdId", holdId);
        ParameterCheck.mandatoryString("bulkStatusId", bulkStatusId);
        ParameterCheck.mandatoryObject("bulkBodyCancel", bulkBodyCancel);
        this.getRmRestWrapper().processEmptyModel(RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)PojoUtility.toJson(bulkBodyCancel), (String)"holds/{holdId}/bulk-statuses/{bulkStatusId}/cancel", (String[])new String[]{holdId, bulkStatusId, parameters}));
    }

    public void cancelBulkOperation(String holdId, String bulkStatusId, BulkBodyCancel bulkBodyCancel) {
        ParameterCheck.mandatoryString("holdId", holdId);
        ParameterCheck.mandatoryString("bulkStatusId", bulkStatusId);
        ParameterCheck.mandatoryObject("bulkBodyCancel", bulkBodyCancel);
        this.cancelBulkOperation(holdId, bulkStatusId, bulkBodyCancel, "");
    }
}

