/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.core;

import io.restassured.builder.RequestSpecBuilder;
import lombok.Generated;
import org.alfresco.rest.core.RMRestProperties;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestHtmlResponse;
import org.alfresco.rest.requests.coreAPI.RestCoreAPI;
import org.alfresco.rest.requests.search.SearchAPI;
import org.alfresco.rest.rm.community.requests.gscore.GSCoreAPI;
import org.alfresco.utility.model.StatusModel;
import org.alfresco.utility.model.UserModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class RMRestWrapper {
    @Autowired
    private RestWrapper restWrapper;
    @Autowired
    private RMRestProperties rmRestProperties;

    public GSCoreAPI withGSCoreAPI() {
        return new GSCoreAPI(this, this.getRmRestProperties());
    }

    public RestWrapper getRestWrapper() {
        return this.restWrapper;
    }

    public void authenticateUser(UserModel userModel) {
        this.restWrapper.authenticateUser(userModel);
    }

    public RestErrorModel assertLastError() {
        return this.restWrapper.assertLastError();
    }

    public <T> T processModels(Class<T> classz, RestRequest simpleRequest) {
        return (T)this.restWrapper.processModels(classz, simpleRequest);
    }

    public <T> T processModel(Class<T> classz, RestRequest restRequest) {
        return (T)this.restWrapper.processModel(classz, restRequest);
    }

    public void processEmptyModel(RestRequest simpleRequest) {
        this.restWrapper.processEmptyModel(simpleRequest);
    }

    public StatusModel getLastStatus() {
        return this.restWrapper.getLastStatus();
    }

    public String getStatusCode() {
        return this.restWrapper.getStatusCode();
    }

    public void setStatusCode(String statusCode) {
        this.restWrapper.setStatusCode(statusCode);
    }

    public void assertStatusCodeIs(HttpStatus statusCode) {
        this.restWrapper.assertStatusCodeIs(statusCode);
    }

    public String getParameters() {
        return this.restWrapper.getParameters();
    }

    public UserModel getTestUser() {
        return this.restWrapper.getTestUser();
    }

    public RestCoreAPI withCoreAPI() {
        return this.restWrapper.withCoreAPI();
    }

    public SearchAPI withSearchAPI() {
        return this.restWrapper.withSearchAPI();
    }

    public RequestSpecBuilder configureRequestSpec() {
        return this.restWrapper.configureRequestSpec();
    }

    public RestHtmlResponse processHtmlResponse(RestRequest simpleRequest) {
        return this.restWrapper.processHtmlResponse(simpleRequest);
    }

    @Generated
    public RMRestProperties getRmRestProperties() {
        return this.rmRestProperties;
    }
}

