/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.smoke;

import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.recordcategory.RetentionPeriodProperty;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.v0.RecordFoldersAPI;
import org.alfresco.rest.v0.service.DispositionScheduleService;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.report.log.Step;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class FoldersDispositionScheduleTests
extends BaseRMRestTest {
    private RecordCategory Category1;
    @Autowired
    private DispositionScheduleService dispositionScheduleService;
    @Autowired
    private RecordFoldersAPI recordFoldersAPI;
    private final String TEST_PREFIX = CommonTestUtils.generateTestPrefix(FoldersDispositionScheduleTests.class);
    private final String folderDisposition = this.TEST_PREFIX + "RM-2937 folder ghosting";
    private final String electronicRecord = "RM-2937 electronic 2 record";
    private final String nonElectronicRecord = "RM-2937 non-electronic record";

    @BeforeClass(alwaysRun=true)
    private void setUp() {
        Step.STEP((String)"Create the RM site if doesn't exist");
        this.createRMSiteIfNotExists();
        Step.STEP((String)"Create record category");
        this.Category1 = this.createRootCategory(RandomData.getRandomName((String)"Title"));
    }

    @Test
    @AlfrescoTest(jira="RM-2937")
    public void foldersDispositionScheduleWithGhosting() {
        this.dispositionScheduleService.createCategoryRetentionSchedule(this.Category1.getName(), Boolean.valueOf(false));
        this.dispositionScheduleService.addCutOffAfterPeriodStep(this.Category1.getName(), "day|2", RetentionPeriodProperty.CREATED_DATE);
        this.dispositionScheduleService.addDestroyWithGhostingImmediatelyAfterCutOff(this.Category1.getName());
        RecordCategoryChild FOLDER_DESTROY = this.createFolder(this.getAdminUser(), this.Category1.getId(), this.folderDisposition);
        Record elRecord = this.createElectronicRecord(FOLDER_DESTROY.getId(), "RM-2937 electronic 2 record");
        Record nonElRecord = this.createNonElectronicRecord(FOLDER_DESTROY.getId(), "RM-2937 non-electronic record");
        this.completeRecord(elRecord.getId());
        this.completeRecord(nonElRecord.getId());
        this.recordFoldersAPI.postFolderAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.editDispositionDateJson(), FOLDER_DESTROY.getName());
        this.recordFoldersAPI.postFolderAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), new JSONObject().put("name", (Object)"cutoff"), FOLDER_DESTROY.getName());
        this.recordFoldersAPI.postFolderAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), new JSONObject().put("name", (Object)"destroy"), FOLDER_DESTROY.getName());
    }

    @AfterMethod(alwaysRun=true)
    private void deletePreconditions() {
        this.deleteRecordCategory(this.Category1.getId());
    }
}

