/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.requests.gscore.api;

import org.alfresco.rest.core.RMRestWrapper;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChildCollection;
import org.alfresco.rest.rm.community.requests.RMModelRequest;
import org.alfresco.rest.rm.community.util.ParameterCheck;
import org.alfresco.rest.rm.community.util.PojoUtility;
import org.springframework.http.HttpMethod;

public class RecordCategoryAPI
extends RMModelRequest {
    public RecordCategoryAPI(RMRestWrapper rmRestWrapper) {
        super(rmRestWrapper);
    }

    public void deleteRecordCategory(String recordCategoryId) {
        ParameterCheck.mandatoryString("recordCategoryId", recordCategoryId);
        this.getRmRestWrapper().processEmptyModel(RestRequest.simpleRequest((HttpMethod)HttpMethod.DELETE, (String)"record-categories/{recordCategoryId}", (String[])new String[]{recordCategoryId}));
    }

    public RecordCategory getRecordCategory(String recordCategoryId) {
        ParameterCheck.mandatoryString("recordCategoryId", recordCategoryId);
        return this.getRecordCategory(recordCategoryId, "");
    }

    public RecordCategory getRecordCategory(String recordCategoryId, String parameters) {
        ParameterCheck.mandatoryString("recordCategoryId", recordCategoryId);
        return this.getRmRestWrapper().processModel(RecordCategory.class, RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)"record-categories/{recordCategoryId}?{parameters}", (String[])new String[]{recordCategoryId, parameters}));
    }

    public RecordCategory updateRecordCategory(RecordCategory recordCategoryModel, String recordCategoryId) {
        ParameterCheck.mandatoryObject("recordCategoryModel", (Object)recordCategoryModel);
        ParameterCheck.mandatoryString("recordCategoryId", recordCategoryId);
        return this.updateRecordCategory(recordCategoryModel, recordCategoryId, "");
    }

    public RecordCategory updateRecordCategory(RecordCategory recordCategoryModel, String recordCategoryId, String parameters) {
        ParameterCheck.mandatoryObject("recordCategoryModel", (Object)recordCategoryModel);
        ParameterCheck.mandatoryString("recordCategoryId", recordCategoryId);
        return this.getRmRestWrapper().processModel(RecordCategory.class, RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)PojoUtility.toJson((Object)recordCategoryModel), (String)"record-categories/{recordCategoryId}?{parameters}", (String[])new String[]{recordCategoryId, parameters}));
    }

    public RecordCategoryChildCollection getRecordCategoryChildren(String recordCategoryId) {
        ParameterCheck.mandatoryString("recordCategoryId", recordCategoryId);
        return this.getRecordCategoryChildren(recordCategoryId, "");
    }

    public RecordCategoryChildCollection getRecordCategoryChildren(String recordCategoryId, String parameters) {
        ParameterCheck.mandatoryString("recordCategoryId", recordCategoryId);
        return this.getRmRestWrapper().processModels(RecordCategoryChildCollection.class, RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)"record-categories/{recordCategoryId}/children?{parameters}", (String[])new String[]{recordCategoryId, parameters}));
    }

    public RecordCategoryChild createRecordCategoryChild(RecordCategoryChild recordCategoryChildModel, String recordCategoryId) {
        ParameterCheck.mandatoryObject("recordCategoryChildModel", (Object)recordCategoryChildModel);
        ParameterCheck.mandatoryString("recordCategoryId", recordCategoryId);
        return this.createRecordCategoryChild(recordCategoryChildModel, recordCategoryId, "");
    }

    public RecordCategoryChild createRecordCategoryChild(RecordCategoryChild recordCategoryChildModel, String recordCategoryId, String parameters) {
        ParameterCheck.mandatoryObject("filePlanComponentProperties", (Object)recordCategoryChildModel);
        ParameterCheck.mandatoryString("recordCategoryId", recordCategoryId);
        return this.getRmRestWrapper().processModel(RecordCategoryChild.class, RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)PojoUtility.toJson((Object)recordCategoryChildModel), (String)"record-categories/{recordCategoryId}/children?{parameters}", (String[])new String[]{recordCategoryId, parameters}));
    }
}

