/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.smoke;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.time.Instant;
import java.util.ArrayList;
import org.alfresco.rest.core.v0.RMEvents;
import org.alfresco.rest.model.RestNodeBodyMoveCopyModel;
import org.alfresco.rest.model.RestNodeModel;
import org.alfresco.rest.requests.Node;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.fileplan.FilePlan;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.recordcategory.RetentionPeriodProperty;
import org.alfresco.rest.rm.community.model.user.UserRoles;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.v0.LinksAPI;
import org.alfresco.rest.v0.RMRolesAndActionsAPI;
import org.alfresco.rest.v0.RecordFoldersAPI;
import org.alfresco.rest.v0.RecordsAPI;
import org.alfresco.rest.v0.service.DispositionScheduleService;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DispositionScheduleLinkedRecordsTest
extends BaseRMRestTest {
    @Autowired
    private RMRolesAndActionsAPI rmRolesAndActionsAPI;
    @Autowired
    private DispositionScheduleService dispositionScheduleService;
    @Autowired
    private LinksAPI linksAPI;
    @Autowired
    private RecordsAPI recordsAPI;
    @Autowired
    private RecordFoldersAPI recordFoldersAPI;
    private static final String TEST_PREFIX = CommonTestUtils.generateTestPrefix(DispositionScheduleLinkedRecordsTest.class);
    private static final String CATEGORY_RM_3077 = TEST_PREFIX + "RM-3077_manager_sees_me";
    private static final String COPY_CATEGORY_RM_3077 = "Copy_of_" + CATEGORY_RM_3077;
    private static final String FOLDER_RM_3077 = "RM-3077_folder_" + CATEGORY_RM_3077;
    private static final String COPY_FOLDER_RM_3077 = "Copy_of_" + FOLDER_RM_3077;
    private static final String FIRST_CATEGORY_RM_3060 = TEST_PREFIX + "RM-3060_category_record";
    private static final String SECOND_CATEGORY_RM_3060 = "Copy_of_" + FIRST_CATEGORY_RM_3060;
    private static final String FIRST_FOLDER_RM_3060 = TEST_PREFIX + "RM-3060_folder";
    private static final String SECOND_FOLDER_RM_3060 = TEST_PREFIX + "RM-3060_disposition_on_Record_Level";
    private static final String ELECTRONIC_RECORD_RM_3060 = TEST_PREFIX + "RM-3060_electronic_1_record";
    private static final String NON_ELECTRONIC_RECORD_RM_3060 = TEST_PREFIX + "RM-3060_non-electronic_record";
    private static final String FIRST_CATEGORY_RM_1622 = TEST_PREFIX + "RM-1622_category_record";
    private static final String SECOND_CATEGORY_RM_1622 = "Copy_of_" + FIRST_CATEGORY_RM_1622;
    private static final String FIRST_FOLDER_RM_1622 = TEST_PREFIX + "RM-1622_folder";
    private static final String ELECTRONIC_RECORD_RM_1622 = TEST_PREFIX + "RM-1622_electronic_1_record";
    private static final String SECOND_FOLDER_RM_1622 = TEST_PREFIX + "RM-1622_disposition_on_Record_Level";
    private static final String TRANSFER_LOCATION = TEST_PREFIX + "RM-3060_transferred_records";
    public static final String TRANSFER_TYPE = "rma:transferred";
    private FilePlan filePlanModel;
    private UserModel rmAdmin;

    @BeforeClass(alwaysRun=true)
    public void setupDispositionScheduleLinkedRecordsTest() {
        this.createRMSiteIfNotExists();
        this.filePlanModel = this.getRestAPIFactory().getFilePlansAPI().getFilePlan("-filePlan-");
        this.rmAdmin = this.getDataUser().createRandomTestUser();
        this.rmRolesAndActionsAPI.assignRoleToUser(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), this.rmAdmin.getUsername(), UserRoles.ROLE_RM_ADMIN.roleId);
        UserModel rmManager = this.getDataUser().createRandomTestUser();
        this.rmRolesAndActionsAPI.assignRoleToUser(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), rmManager.getUsername(), UserRoles.ROLE_RM_MANAGER.roleId);
    }

    @Test(enabled=false)
    @AlfrescoTest(jira="RM-1622")
    public void dispositionScheduleLinkedRecords() throws UnsupportedEncodingException {
        Step.STEP((String)"Create record category");
        RecordCategory category1 = this.createRootCategory(CATEGORY_RM_3077);
        this.dispositionScheduleService.createCategoryRetentionSchedule(category1.getName(), Boolean.valueOf(false));
        this.dispositionScheduleService.addCutOffAfterPeriodStep(category1.getName(), "day|2", RetentionPeriodProperty.CREATED_DATE);
        String copyCategoryId = this.copyCategory(this.getAdminUser(), category1.getId(), COPY_CATEGORY_RM_3077);
        RecordCategoryChild catFolder = this.createRecordFolder(category1.getId(), FOLDER_RM_3077);
        this.createRecordFolder(copyCategoryId, COPY_FOLDER_RM_3077);
        String electronicRecord = "RM-2801 electronic record";
        Record elRecord = this.createElectronicRecord(catFolder.getId(), electronicRecord);
        String elRecordFullName = this.recordsAPI.getRecordFullName(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), catFolder.getName(), electronicRecord);
        String nonElectronicRecord = "RM-2801 non-electronic record";
        Record nonElRecord = this.createNonElectronicRecord(catFolder.getId(), nonElectronicRecord);
        String nonElRecordFullName = this.recordsAPI.getRecordFullName(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), catFolder.getName(), nonElectronicRecord);
        ArrayList<CallSite> recordLists = new ArrayList<CallSite>();
        recordLists.add((CallSite)((Object)("workspace://SpacesStore/" + elRecord.getId())));
        recordLists.add((CallSite)((Object)("workspace://SpacesStore/" + nonElRecord.getId())));
        this.linksAPI.linkRecord(this.getDataUser().getAdminUser().getUsername(), this.getDataUser().getAdminUser().getPassword(), 200, COPY_CATEGORY_RM_3077 + "/" + COPY_FOLDER_RM_3077, recordLists);
        this.recordsAPI.completeRecord(this.rmAdmin.getUsername(), this.rmAdmin.getPassword(), elRecordFullName);
        this.recordsAPI.completeRecord(this.rmAdmin.getUsername(), this.rmAdmin.getPassword(), nonElRecordFullName);
        this.recordFoldersAPI.postFolderAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.editDispositionDateJson(), catFolder.getName());
        this.recordFoldersAPI.postFolderAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), new JSONObject().put("name", (Object)"cutoff"), catFolder.getName());
        Node electronicNode = this.getNode(elRecord.getId());
        Assert.assertTrue((String)("The content of " + electronicRecord + " is available"), (boolean)StringUtils.isEmpty((CharSequence)electronicNode.getNodeContent().getResponse().getBody().asString()));
        AssertJUnit.assertNull((String)"The properties are present even after cutting off the record.", (Object)elRecord.getProperties().getTitle());
        this.deleteRecordCategory(category1.getId());
        this.deleteRecordCategory(copyCategoryId);
    }

    @Test(enabled=false)
    @AlfrescoTest(jira="RM-3060")
    public void sameDispositionScheduleLinkedRecords() throws UnsupportedEncodingException {
        RecordCategory recordCategory = this.getRestAPIFactory().getFilePlansAPI(this.rmAdmin).createRootRecordCategory(RecordCategory.builder().name(FIRST_CATEGORY_RM_3060).build(), "-filePlan-");
        this.dispositionScheduleService.createCategoryRetentionSchedule(FIRST_CATEGORY_RM_3060, Boolean.valueOf(true));
        this.dispositionScheduleService.addCutOffAfterPeriodStep(FIRST_CATEGORY_RM_3060, "week|1", RetentionPeriodProperty.DATE_FILED);
        this.dispositionScheduleService.addTransferAfterEventStep(FIRST_CATEGORY_RM_3060, TRANSFER_LOCATION, RMEvents.CASE_CLOSED.getEventName());
        this.dispositionScheduleService.addDestroyWithoutGhostingAfterPeriodStep(FIRST_CATEGORY_RM_3060, "week|1", RetentionPeriodProperty.CUT_OFF_DATE);
        String categorySecondId = this.copyCategory(this.getAdminUser(), recordCategory.getId(), SECOND_CATEGORY_RM_3060);
        RecordCategoryChild firstFolderRecordCategoryChild = this.createRecordFolder(recordCategory.getId(), FIRST_FOLDER_RM_3060);
        Record firstElectronicRecord = this.createElectronicRecord(firstFolderRecordCategoryChild.getId(), ELECTRONIC_RECORD_RM_3060);
        String elRecordFullName = this.recordsAPI.getRecordFullName(this.getDataUser().getAdminUser().getUsername(), this.getDataUser().getAdminUser().getPassword(), FIRST_FOLDER_RM_3060, ELECTRONIC_RECORD_RM_3060);
        String elRecordNameNodeRef = this.recordsAPI.getRecordNodeRef(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), elRecordFullName, "/" + FIRST_CATEGORY_RM_3060 + "/" + FIRST_FOLDER_RM_3060);
        this.recordsAPI.completeRecord(this.getDataUser().getAdminUser().getUsername(), this.getDataUser().getAdminUser().getPassword(), elRecordFullName);
        RecordCategoryChild secondFolderRecordCategoryChild = this.createRecordFolder(categorySecondId, SECOND_FOLDER_RM_3060);
        Record secondNonElectronicRecord = this.createNonElectronicRecord(secondFolderRecordCategoryChild.getId(), NON_ELECTRONIC_RECORD_RM_3060);
        ArrayList<CallSite> recordLists = new ArrayList<CallSite>();
        recordLists.add((CallSite)((Object)("workspace://SpacesStore/" + secondNonElectronicRecord.getId())));
        this.linksAPI.linkRecord(this.getDataUser().getAdminUser().getUsername(), this.getDataUser().getAdminUser().getPassword(), 200, SECOND_CATEGORY_RM_3060 + "/" + SECOND_FOLDER_RM_3060, recordLists);
        String nonElRecordFullName = this.recordsAPI.getRecordFullName(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), SECOND_FOLDER_RM_3060, secondNonElectronicRecord.getName());
        String nonElRecordNameNodeRef = this.recordsAPI.getRecordNodeRef(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), nonElRecordFullName, "/" + SECOND_CATEGORY_RM_3060 + "/" + SECOND_FOLDER_RM_3060);
        this.recordsAPI.completeRecord(this.getDataUser().getAdminUser().getUsername(), this.getDataUser().getAdminUser().getPassword(), nonElRecordFullName);
        this.recordFoldersAPI.postRecordAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.editDispositionDateJson(), nonElRecordNameNodeRef);
        this.recordFoldersAPI.postRecordAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), new JSONObject().put("name", (Object)"cutoff"), nonElRecordNameNodeRef);
        AssertJUnit.assertTrue((String)("The file " + NON_ELECTRONIC_RECORD_RM_3060 + " has not been successfully cut off."), (boolean)this.getRestAPIFactory().getRecordsAPI().getRecord(secondNonElectronicRecord.getId()).getAspectNames().contains("rma:cutOff"));
        recordLists.clear();
        recordLists.add((CallSite)((Object)("workspace://SpacesStore/" + secondNonElectronicRecord.getId())));
        this.linksAPI.linkRecord(this.getDataUser().getAdminUser().getUsername(), this.getDataUser().getAdminUser().getPassword(), 200, SECOND_CATEGORY_RM_3060 + "/" + SECOND_FOLDER_RM_3060, recordLists);
        this.recordFoldersAPI.postRecordAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.editDispositionDateJson(), elRecordNameNodeRef);
        this.recordFoldersAPI.postRecordAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), new JSONObject().put("name", (Object)"cutoff"), elRecordNameNodeRef);
        AssertJUnit.assertTrue((String)("The file " + ELECTRONIC_RECORD_RM_3060 + " has not been successfully cut off."), (boolean)this.getRestAPIFactory().getRecordsAPI().getRecord(firstElectronicRecord.getId()).getAspectNames().contains("rma:cutOff"));
        this.rmRolesAndActionsAPI.completeEvent(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), elRecordFullName, RMEvents.CASE_CLOSED, Instant.now());
        this.rmRolesAndActionsAPI.completeEvent(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), nonElRecordFullName, RMEvents.CASE_CLOSED, Instant.now());
        HttpResponse nonElRecordNameHttpResponse = this.recordFoldersAPI.postRecordAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), new JSONObject().put("name", (Object)"transfer"), this.recordsAPI.getRecordNodeRef(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), nonElRecordFullName, "/" + SECOND_CATEGORY_RM_3060 + "/" + SECOND_FOLDER_RM_3060));
        String nonElRecordNameTransferId = this.getTransferId(nonElRecordNameHttpResponse, nonElRecordNameNodeRef);
        this.recordFoldersAPI.postRecordAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), new JSONObject().put("name", (Object)"transferComplete"), nonElRecordNameTransferId);
        HttpResponse elRecordNameHttpResponse = this.recordFoldersAPI.postRecordAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), new JSONObject().put("name", (Object)"transfer"), this.recordsAPI.getRecordNodeRef(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), elRecordFullName, "/" + FIRST_CATEGORY_RM_3060 + "/" + FIRST_FOLDER_RM_3060));
        String elRecordNameTransferId = this.getTransferId(elRecordNameHttpResponse, elRecordNameNodeRef);
        this.recordFoldersAPI.postRecordAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), new JSONObject().put("name", (Object)"transferComplete"), elRecordNameTransferId);
        AssertJUnit.assertTrue((String)("The file " + ELECTRONIC_RECORD_RM_3060 + " has not been successfully transferred"), (boolean)this.getRestAPIFactory().getRecordsAPI().getRecord(firstElectronicRecord.getId()).getAspectNames().contains(TRANSFER_TYPE));
        AssertJUnit.assertTrue((String)("The file " + NON_ELECTRONIC_RECORD_RM_3060 + " has not been successfully transferred."), (boolean)this.getRestAPIFactory().getRecordsAPI().getRecord(secondNonElectronicRecord.getId()).getAspectNames().contains(TRANSFER_TYPE));
        this.recordFoldersAPI.postRecordAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.editDispositionDateJson(), nonElRecordNameNodeRef);
        this.recordFoldersAPI.postRecordAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.editDispositionDateJson(), elRecordNameNodeRef);
        this.recordFoldersAPI.postRecordAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), new JSONObject().put("name", (Object)"destroy"), nonElRecordNameNodeRef);
        this.recordFoldersAPI.postRecordAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), new JSONObject().put("name", (Object)"destroy"), elRecordNameNodeRef);
        Assert.assertNull((String)("The file " + NON_ELECTRONIC_RECORD_RM_3060 + " has not been successfully destroyed."), (Object)secondNonElectronicRecord.getContent());
        Assert.assertNull((String)("The file " + ELECTRONIC_RECORD_RM_3060 + " has not been successfully destroyed."), (Object)firstElectronicRecord.getContent());
        this.deleteRecordCategory(recordCategory.getId());
        this.deleteRecordCategory(categorySecondId);
    }

    private String copyCategory(UserModel user, String categoryId, String copyName) {
        RestNodeModel restNodeModel;
        RepoTestModel repoTestModel = new RepoTestModel(this){};
        repoTestModel.setNodeRef(categoryId);
        RestNodeBodyMoveCopyModel copyDestinationInfo = new RestNodeBodyMoveCopyModel();
        copyDestinationInfo.setTargetParentId(this.filePlanModel.getId());
        copyDestinationInfo.setName(copyName);
        try {
            restNodeModel = this.getRestAPIFactory().getNodeAPI(user, repoTestModel).copy(copyDestinationInfo);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem copying category.", e);
        }
        return restNodeModel.getId();
    }

    private Node getNode(String recordId) {
        RepoTestModel repoTestModel = new RepoTestModel(this){};
        repoTestModel.setNodeRef(recordId);
        return this.getRestAPIFactory().getNodeAPI(repoTestModel);
    }

    private String getTransferId(HttpResponse httpResponse, String nodeRef) {
        String responseString;
        HttpEntity entity = httpResponse.getEntity();
        try {
            responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject result = new JSONObject(responseString);
        return result.getJSONObject("results").get(nodeRef).toString();
    }

    @Test
    @AlfrescoTest(jira="RM-1622")
    public void sameLevelDispositionScheduleStepsPeriodsCalculation() throws Exception {
        RecordCategory catsameLevel1 = this.getRestAPIFactory().getFilePlansAPI(this.rmAdmin).createRootRecordCategory(RecordCategory.builder().name(FIRST_CATEGORY_RM_1622).build(), "-filePlan-");
        RecordCategory catsameLevel2 = this.getRestAPIFactory().getFilePlansAPI(this.rmAdmin).createRootRecordCategory(RecordCategory.builder().name(SECOND_CATEGORY_RM_1622).build(), "-filePlan-");
        this.dispositionScheduleService.createCategoryRetentionSchedule(FIRST_CATEGORY_RM_1622, Boolean.valueOf(true));
        this.dispositionScheduleService.addCutOffAfterPeriodStep(FIRST_CATEGORY_RM_1622, "day|1", RetentionPeriodProperty.DATE_FILED);
        RecordCategoryChild firstFolderRecordCategoryChild = this.createRecordFolder(catsameLevel1.getId(), FIRST_FOLDER_RM_1622);
        Record firstElectronicRecord = this.createElectronicRecord(firstFolderRecordCategoryChild.getId(), ELECTRONIC_RECORD_RM_1622);
        String elRecordFullName = this.recordsAPI.getRecordFullName(this.getDataUser().getAdminUser().getUsername(), this.getDataUser().getAdminUser().getPassword(), FIRST_FOLDER_RM_1622, ELECTRONIC_RECORD_RM_1622);
        this.recordsAPI.getRecordNodeRef(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), elRecordFullName, "/" + FIRST_CATEGORY_RM_1622 + "/" + FIRST_FOLDER_RM_1622);
        this.recordsAPI.completeRecord(this.getDataUser().getAdminUser().getUsername(), this.getDataUser().getAdminUser().getPassword(), elRecordFullName);
        this.createRecordFolder(catsameLevel2.getId(), SECOND_FOLDER_RM_1622);
        String elRecordNameNodeRefs = this.recordsAPI.getRecordNodeRef(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), elRecordFullName, "/" + FIRST_CATEGORY_RM_1622 + "/" + FIRST_FOLDER_RM_1622);
        ArrayList<CallSite> recordLists = new ArrayList<CallSite>();
        recordLists.add((CallSite)((Object)("workspace://SpacesStore/" + firstElectronicRecord.getId())));
        this.linksAPI.linkRecord(this.getDataUser().getAdminUser().getUsername(), this.getDataUser().getAdminUser().getPassword(), 200, SECOND_CATEGORY_RM_1622 + "/" + SECOND_FOLDER_RM_1622, recordLists);
        this.recordFoldersAPI.postRecordAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.editDispositionDateJson(), elRecordNameNodeRefs);
    }

    @Test(dependsOnMethods={"sameLevelDispositionScheduleStepsPeriodsCalculation"})
    public void deleteLongestPeriodTestPrecondition() {
        this.getRestAPIFactory().getRMSiteAPI().deleteRMSite();
        this.assertStatusCode(HttpStatus.NO_CONTENT);
    }
}

