/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.audit;

import java.util.List;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.audit.AuditEvents;
import org.alfresco.rest.v0.service.RMAuditService;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@AlfrescoTest(jira="RM-5234")
public class AuditLoginEventsTests
extends BaseRMRestTest {
    @Autowired
    private RMAuditService rmAuditService;

    @Test
    public void filterByLoginUnsuccessful() throws Exception {
        this.rmAuditService.clearAuditLog();
        this.restClient.authenticateUser(new UserModel(this.getAdminUser().getUsername(), "InvalidPassword"));
        this.restClient.withCoreAPI().getSites();
        Step.STEP((String)"Get the list of audit entries for the login unsuccessful event.");
        List auditEntries = this.rmAuditService.getAuditEntriesFilteredByEvent(this.getAdminUser(), AuditEvents.LOGIN_UNSUCCESSFUL);
        Step.STEP((String)"Check the audit log contains only the entries for the login unsuccessful event.");
        AssertJUnit.assertTrue((String)("The list of events is not filtered by " + AuditEvents.LOGIN_UNSUCCESSFUL.event), (boolean)auditEntries.stream().allMatch(auditEntry -> auditEntry.getEvent().equals(AuditEvents.LOGIN_UNSUCCESSFUL.eventDisplayName)));
    }

    @Test
    public void filterByLoginSuccessful() throws Exception {
        this.restClient.authenticateUser(this.getAdminUser());
        this.restClient.withCoreAPI().getSites();
        Step.STEP((String)"Get the list of audit entries for the login successful event.");
        List auditEntries = this.rmAuditService.getAuditEntriesFilteredByEvent(this.getAdminUser(), AuditEvents.LOGIN_SUCCESSFUL);
        Step.STEP((String)"Check the audit log contains only the entries for the login successful event.");
        AssertJUnit.assertTrue((String)("The list of events is not filtered by " + AuditEvents.LOGIN_SUCCESSFUL.event), (boolean)auditEntries.stream().allMatch(auditEntry -> auditEntry.getEvent().equals(AuditEvents.LOGIN_SUCCESSFUL.eventDisplayName)));
    }
}

