/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.requests.gscore.api;

import com.google.gson.JsonObject;
import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import org.alfresco.dataprep.AlfrescoHttpClient;
import org.alfresco.dataprep.AlfrescoHttpClientFactory;
import org.alfresco.rest.core.RMRestProperties;
import org.alfresco.rest.core.RMRestWrapper;
import org.alfresco.rest.rm.community.model.user.UserPermissions;
import org.alfresco.rest.rm.community.requests.RMModelRequest;
import org.alfresco.utility.model.UserModel;
import org.jglue.fluentjson.JsonArrayBuilder;
import org.jglue.fluentjson.JsonBuilderFactory;
import org.jglue.fluentjson.JsonObjectBuilder;
import org.springframework.http.HttpStatus;

public class RMUserAPI
extends RMModelRequest {
    public RMUserAPI(RMRestWrapper rmRestWrapper) {
        super(rmRestWrapper);
    }

    private AlfrescoHttpClient getAlfrescoHttpClient() {
        RMRestProperties properties = this.getRmRestWrapper().getRmRestProperties();
        AlfrescoHttpClientFactory factory = new AlfrescoHttpClientFactory();
        factory.setHost(properties.getServer());
        factory.setPort(Integer.parseInt(properties.getPort()));
        factory.setScheme(properties.getScheme());
        return factory.getObject();
    }

    public void assignRoleToUser(String userName, String userRole) {
        UserModel adminUser = this.getRmRestWrapper().getTestUser();
        AlfrescoHttpClient client = this.getAlfrescoHttpClient();
        RequestSpecification spec = new RequestSpecBuilder().setBaseUri(client.getApiUrl()).setBasePath("/").build();
        Response response = (Response)((Response)((Response)((RequestSpecification)RestAssured.given().spec(spec).log().all()).pathParam("role", (Object)userRole).pathParam("authority", (Object)userName).param("alf_ticket", new Object[]{client.getAlfTicket(adminUser.getUsername(), adminUser.getPassword())}).when().post("/rm/roles/{role}/authorities/{authority}", new Object[0])).prettyPeek()).andReturn();
        this.getRmRestWrapper().setStatusCode(Integer.toString(response.getStatusCode()));
    }

    public void addUserPermission(String filePlanComponentId, UserModel user, UserPermissions permission) {
        UserModel adminUser = this.getRmRestWrapper().getTestUser();
        AlfrescoHttpClient client = this.getAlfrescoHttpClient();
        JsonObject bodyJson = (JsonObject)((JsonArrayBuilder)JsonBuilderFactory.buildObject().addArray("permissions").addObject().add("authority", user.getUsername()).add("role", permission.permissionId).end()).getJson();
        RequestSpecification spec = new RequestSpecBuilder().setBaseUri(client.getApiUrl()).setBasePath("/").build();
        Response response = (Response)((Response)((Response)((RequestSpecification)RestAssured.given().spec(spec).auth().basic(adminUser.getUsername(), adminUser.getPassword()).contentType(ContentType.JSON).body(bodyJson.toString()).pathParam("nodeId", (Object)filePlanComponentId).log().all()).when().post("/node/workspace/SpacesStore/{nodeId}/rmpermissions", new Object[0])).prettyPeek()).andReturn();
        this.getRmRestWrapper().setStatusCode(Integer.toString(response.getStatusCode()));
    }

    public void setUserPermissionInheritance(String filePlanComponentId, Boolean isInherited) {
        UserModel adminUser = this.getRmRestWrapper().getTestUser();
        AlfrescoHttpClient client = this.getAlfrescoHttpClient();
        JsonObject bodyJson = (JsonObject)((JsonObjectBuilder)JsonBuilderFactory.buildObject().addArray("permissions").end()).add("isInherited", isInherited).getJson();
        RequestSpecification spec = new RequestSpecBuilder().setBaseUri(client.getApiUrl()).setBasePath("/").build();
        Response response = (Response)((Response)((Response)((RequestSpecification)RestAssured.given().spec(spec).auth().basic(adminUser.getUsername(), adminUser.getPassword()).contentType(ContentType.JSON).body(bodyJson.toString()).pathParam("nodeId", (Object)filePlanComponentId).log().all()).when().post("/node/workspace/SpacesStore/{nodeId}/rmpermissions", new Object[0])).prettyPeek()).andReturn();
        this.getRmRestWrapper().setStatusCode(Integer.toString(response.getStatusCode()));
    }

    public boolean createUser(String userName, String userPassword, String userEmail) {
        UserModel adminUser = this.getRmRestWrapper().getTestUser();
        AlfrescoHttpClient client = this.getAlfrescoHttpClient();
        JsonObject body = (JsonObject)JsonBuilderFactory.buildObject().add("userName", userName).add("firstName", userName).add("lastName", userName).add("password", userPassword).add("email", userEmail).getJson();
        RequestSpecification spec = new RequestSpecBuilder().setBaseUri(client.getApiUrl()).setBasePath("/").setAuth(RestAssured.basic((String)adminUser.getUsername(), (String)adminUser.getPassword())).setContentType(ContentType.JSON).setBody(body.toString()).build();
        Response response = (Response)((Response)((Response)((RequestSpecification)RestAssured.given().spec(spec).log().all()).when().post("people", new Object[0])).prettyPeek()).andReturn();
        return response.getStatusCode() == HttpStatus.OK.value();
    }
}

