/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.smoke;

import java.util.Collections;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.base.TestData;
import org.alfresco.rest.rm.community.model.record.RecordContent;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.rules.ActionsOnRule;
import org.alfresco.rest.rm.community.model.rules.RuleDefinition;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainer;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainerChild;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainerChildProperties;
import org.alfresco.rest.rm.community.smoke.CreateCategoriesTests;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.v0.RMRolesAndActionsAPI;
import org.alfresco.rest.v0.RulesAPI;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.annotations.Test;

public class UnfiledRecordsRuleTests
extends BaseRMRestTest {
    @Autowired
    private RMRolesAndActionsAPI rmRolesAndActionsAPI;
    private final String TEST_PREFIX = CommonTestUtils.generateTestPrefix(CreateCategoriesTests.class);
    private final String RM_ADMIN = this.TEST_PREFIX + "rm_admin";
    private RecordCategory Category2;
    private RecordCategoryChild Folder2;
    @Autowired
    private RulesAPI rulesAPI;

    @Test
    @AlfrescoTest(jira="RM-2794")
    public void unfiledRecordsRule() {
        Step.STEP((String)"Create the RM site if doesn't exist");
        this.createRMSiteIfNotExists();
        Step.STEP((String)"Create RM Admin user");
        this.rmRolesAndActionsAPI.createUserAndAssignToRole(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.RM_ADMIN, this.getAdminUser().getPassword(), "Administrator");
        Step.STEP((String)"Create record categories and record folders");
        this.Category2 = this.createRootCategory(RandomData.getRandomName((String)"recordCategory"));
        this.Folder2 = this.createFolder(this.Category2.getId(), RandomData.getRandomName((String)"recordFolder"));
        Step.STEP((String)"Get the unfiled records container");
        UnfiledContainer container = this.getRestAPIFactory().getUnfiledContainersAPI().getUnfiledContainer("-unfiled-");
        this.assertStatusCode(HttpStatus.OK);
        RuleDefinition ruleDefinition = RuleDefinition.createNewRule().title("name").description("description").applyToChildren(true).actions(Collections.singletonList(ActionsOnRule.FILE_TO.getActionValue()));
        this.rulesAPI.createRule(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), "workspace/SpacesStore/" + container.getId(), ruleDefinition);
        UnfiledContainerChild electronicRecord = UnfiledContainerChild.builder().name(TestData.ELECTRONIC_RECORD_NAME).nodeType("cm:content").content(RecordContent.builder().mimeType("text/plain").build()).build();
        this.assertStatusCode(HttpStatus.OK);
        UnfiledContainerChild nonelectronicRecord = UnfiledContainerChild.builder().properties(UnfiledContainerChildProperties.builder().description(TestData.NONELECTRONIC_RECORD_NAME).title("Title").build()).name(TestData.NONELECTRONIC_RECORD_NAME).nodeType("rma:nonElectronicDocument").build();
        this.assertStatusCode(HttpStatus.OK);
        this.rulesAPI.deleteAllRulesOnContainer(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), "workspace/SpacesStore/" + container.getId());
        this.deleteRecordCategory(this.Category2.getId());
        this.assertStatusCode(HttpStatus.NO_CONTENT);
    }
}

