/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.audit;

import java.util.List;
import java.util.Optional;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.recordfolder.RecordFolder;
import org.alfresco.rest.rm.community.utils.FilePlanComponentsUtil;
import org.alfresco.rest.v0.RMAuditAPI;
import org.alfresco.rest.v0.RMRolesAndActionsAPI;
import org.alfresco.rest.v0.RecordFoldersAPI;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.UserModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.test.util.AssertionErrors;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class RecordFolderAuditLogTest
extends BaseRMRestTest {
    private Optional<UserModel> rmAdmin;
    @Autowired
    private RMRolesAndActionsAPI rmRolesAndActionsAPI;
    @Autowired
    private RMAuditAPI auditLog;
    @Autowired
    private RecordFoldersAPI recordFoldersAPI;
    private RecordCategory category1;
    private RecordCategoryChild recordFolder1;
    public static final String TITLE = "Title";
    public static final String DESCRIPTION = "Description";

    @BeforeClass(alwaysRun=true)
    public void recordFolderAuditLogSetup() {
        this.createRMSiteIfNotExists();
        this.rmAdmin = Optional.ofNullable(this.getDataUser().createRandomTestUser());
        this.rmRolesAndActionsAPI.assignRoleToUser(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), this.rmAdmin.get().getUsername(), "Administrator");
    }

    @Test(description="Audit log for empty record folder")
    @AlfrescoTest(jira="RM-4303")
    public void recordFolderAudit() {
        this.category1 = this.createRootCategory(TITLE, DESCRIPTION);
        this.recordFolder1 = this.createFolder(this.category1.getId(), TITLE);
        List auditEntries = this.auditLog.getRMAuditLogAll(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), 100);
        AssertionErrors.assertTrue((String)"Created Object Event is not present.", (boolean)auditEntries.stream().anyMatch(x -> x.getEvent().startsWith("Created Object")));
        AssertionErrors.assertTrue((String)"Updated metadata Event is not present.", (boolean)auditEntries.stream().anyMatch(x -> x.getEvent().startsWith("Updated Metadata")));
    }

    @Test(dependsOnMethods={"recordFolderAudit"}, description="Viewing record folder audit log is itself an auditable event")
    @AlfrescoTest(jira="RM-4303")
    public void recordFolderAuditIsEvent() {
        List auditEntries = this.auditLog.getRMAuditLogAll(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), 100);
        AssertionErrors.assertTrue((String)"Audit View Event is not present.", (boolean)auditEntries.stream().anyMatch(x -> x.getEvent().startsWith("Audit View")));
    }

    @Test(dependsOnMethods={"recordFolderAuditIsEvent"}, description="Record folder rename is an edit metadata event")
    @AlfrescoTest(jira="RM-4303")
    public void renameRecordFolder() {
        this.auditLog.clearAuditLog(this.rmAdmin.get().getUsername(), this.rmAdmin.get().getPassword());
        RecordFolder renameRecordFolder = FilePlanComponentsUtil.createRecordFolderModel(this.category1.getId(), "edited");
        this.getRestAPIFactory().getRecordFolderAPI().updateRecordFolder(renameRecordFolder, this.recordFolder1.getId());
        this.assertStatusCode(HttpStatus.OK);
        List auditEntries = this.auditLog.getRMAuditLogAll(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), 100);
        AssertionErrors.assertTrue((String)"Updated metadata Event is not present.", (boolean)auditEntries.stream().anyMatch(x -> x.getEvent().startsWith("Updated Metadata")));
    }

    @Test(dependsOnMethods={"recordFolderAudit"}, description="Close and reopen folder")
    @AlfrescoTest(jira="RM-4303")
    public void closeReopenFolder() {
        this.recordFoldersAPI.closeRecordFolder(this.rmAdmin.get().getUsername(), this.rmAdmin.get().getPassword(), this.recordFolder1.getName());
        try {
            Utility.sleep((int)1000, (int)30000, () -> {
                List auditEntries = this.auditLog.getRMAuditLogAll(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), 100);
                AssertionErrors.assertTrue((String)"Folder Close Record Event is not present.", (boolean)auditEntries.stream().anyMatch(x -> x.getEvent().startsWith("Close Record Folder")));
            });
        }
        catch (InterruptedException e) {
            Assert.fail((String)"InterruptedException received while waiting for results.");
        }
        this.recordFoldersAPI.reOpenRecordFolder(this.rmAdmin.get().getUsername(), this.rmAdmin.get().getPassword(), this.recordFolder1.getName());
        try {
            Utility.sleep((int)1000, (int)30000, () -> {
                List auditEntries = this.auditLog.getRMAuditLogAll(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), 100);
                AssertionErrors.assertTrue((String)"Reopen Record Event is not present.", (boolean)auditEntries.stream().anyMatch(x -> x.getEvent().startsWith("Open Record Folder")));
            });
        }
        catch (InterruptedException e) {
            Assert.fail((String)"InterruptedException received while waiting for results.");
        }
    }

    @AfterMethod
    private void closeAuditLog() {
        this.auditLog.clearAuditLog(this.rmAdmin.get().getUsername(), this.rmAdmin.get().getPassword());
    }

    @AfterClass(alwaysRun=true)
    public void recordFolderAuditLogCleanup() {
        this.deleteRecordFolder(this.recordFolder1.getId());
        this.deleteRecordCategory(this.category1.getId());
        ((DataUser)this.dataUser.usingAdmin()).deleteUser(new UserModel(this.rmAdmin.get().getUsername(), this.rmAdmin.get().getPassword()));
    }
}

