/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.records;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.v0.RecordsAPI;
import org.alfresco.utility.Utility;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.json.JSONObject;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.test.util.AssertionErrors;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class InplaceRecordSearchTests
extends BaseRMRestTest {
    private UserModel siteCollaborator;
    private UserModel siteConsumer;
    private UserModel nonSiteMember;
    private SiteModel privateSite;
    private Record uploadedDocRecordbyCollabUser;
    private FileModel uploadedDocbyCollabUser;
    @Autowired
    private RecordsAPI recordsAPI;

    @BeforeClass(alwaysRun=true)
    public void preConditions() {
        Step.STEP((String)"Create RM Site");
        this.createRMSiteIfNotExists();
        this.privateSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        this.siteCollaborator = this.getDataUser().createRandomTestUser();
        this.getDataUser().addUserToSite(this.siteCollaborator, this.privateSite, UserRole.SiteCollaborator);
        this.siteConsumer = this.getDataUser().createRandomTestUser();
        this.getDataUser().addUserToSite(this.siteConsumer, this.privateSite, UserRole.SiteConsumer);
        this.nonSiteMember = this.getDataUser().createRandomTestUser();
    }

    @Test
    public void searchForInplaceRecord() {
        String fileName = "File" + RandomData.getRandomAlphanumeric();
        this.uploadedDocbyCollabUser = ((DataContent)this.dataContent.usingSite(this.privateSite)).usingUser(this.siteCollaborator).createContent(new FileModel(fileName, FileType.fromName((String)(fileName + "." + CMISUtil.DocumentType.TEXT_PLAIN.extention))));
        Assert.assertNotNull((Object)this.uploadedDocbyCollabUser.getNodeRef());
        this.uploadedDocRecordbyCollabUser = this.getRestAPIFactory().getFilesAPI(this.siteCollaborator).declareAsRecord(this.uploadedDocbyCollabUser.getNodeRefWithoutVersion());
        this.assertStatusCode(HttpStatus.CREATED);
        Assert.assertNotNull((Object)this.uploadedDocRecordbyCollabUser.getId());
        Step.STEP((String)"Allow the Document to be index for it to be available");
        try {
            Utility.sleep((int)1000, (int)40000, () -> {
                JSONObject siteConsumerSearchJson = this.getSearchApi().liveSearchForDocuments(this.siteConsumer.getUsername(), this.siteConsumer.getPassword(), this.uploadedDocbyCollabUser.getName());
                AssertionErrors.assertTrue((String)"Site Consumer not able to find the document.", (siteConsumerSearchJson.getJSONArray("items").length() != 0 ? 1 : 0) != 0);
            });
        }
        catch (InterruptedException e) {
            org.testng.Assert.fail((String)"InterruptedException received while waiting for results.");
        }
        try {
            Utility.sleep((int)1000, (int)40000, () -> {
                JSONObject siteCollaboratorSearchJson = this.getSearchApi().liveSearchForDocuments(this.siteCollaborator.getUsername(), this.siteCollaborator.getPassword(), this.uploadedDocbyCollabUser.getName());
                AssertionErrors.assertTrue((String)"Site Collaborator not able to find the document.", (siteCollaboratorSearchJson.getJSONArray("items").length() != 0 ? 1 : 0) != 0);
            });
        }
        catch (InterruptedException e) {
            org.testng.Assert.fail((String)"InterruptedException received while waiting for results.");
        }
        JSONObject nonSiteMemberSearchJson = this.getSearchApi().liveSearchForDocuments(this.nonSiteMember.getUsername(), this.nonSiteMember.getPassword(), this.uploadedDocbyCollabUser.getName());
        AssertionErrors.assertTrue((String)"Non Site Member is able to access restricted document.", (boolean)nonSiteMemberSearchJson.getJSONArray("items").isEmpty());
    }

    @Test(dependsOnMethods={"searchForInplaceRecord"})
    public void usersCantFindRecordAfterHide() {
        this.recordsAPI.hideRecord(this.siteCollaborator.getUsername(), this.siteCollaborator.getPassword(), this.uploadedDocRecordbyCollabUser.getId());
        JSONObject siteCollaboratorSearchJson = this.getSearchApi().liveSearchForDocuments(this.siteCollaborator.getUsername(), this.siteCollaborator.getPassword(), this.uploadedDocbyCollabUser.getName());
        AssertionErrors.assertTrue((String)"Site Collaborator able to find the document after it is hidden.", (boolean)siteCollaboratorSearchJson.getJSONArray("items").isEmpty());
    }

    @AfterClass
    public void tearDown() {
        ((DataSite)this.dataSite.usingAdmin()).deleteSite(this.privateSite);
        this.dataUser.deleteUser(this.siteCollaborator);
        this.dataUser.deleteUser(this.siteConsumer);
        this.dataUser.deleteUser(this.nonSiteMember);
    }
}

