/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.site;

import org.alfresco.dataprep.SiteService;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.site.RMSite;
import org.alfresco.rest.rm.community.model.site.RMSiteCompliance;
import org.alfresco.rest.rm.community.requests.gscore.api.RMSiteAPI;
import org.alfresco.rest.rm.community.utils.RMSiteUtil;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RMSiteTests
extends BaseRMRestTest {
    @Test(description="Create RM site with Standard Compliance as admin user", priority=2)
    public void createRMSiteAsAdminUser() {
        RMSiteAPI rmSiteAPI = this.getRestAPIFactory().getRMSiteAPI();
        if (rmSiteAPI.existsRMSite()) {
            rmSiteAPI.deleteRMSite();
        }
        RMSite rmSiteResponse = rmSiteAPI.createRMSite(RMSiteUtil.createStandardRMSiteModel());
        this.assertStatusCode(HttpStatus.CREATED);
        Assert.assertEquals((String)rmSiteResponse.getId(), (String)"rm");
        Assert.assertEquals((String)rmSiteResponse.getTitle(), (String)"Records Management");
        Assert.assertEquals((String)rmSiteResponse.getDescription(), (String)"Records Management Site");
        Assert.assertEquals((Object)rmSiteResponse.getCompliance(), (Object)RMSiteCompliance.STANDARD);
        Assert.assertEquals((Object)rmSiteResponse.getVisibility(), (Object)SiteService.Visibility.PUBLIC);
        Assert.assertEquals((String)rmSiteResponse.getRole(), (String)UserRole.SiteManager.toString());
    }

    @Test(description="Create RM site when site already exist with admin user", priority=3)
    public void createRMSiteWhenSiteExists() {
        this.createRMSiteIfNotExists();
        String newTitle = "Records ManagementcreateRMSiteWhenSiteExists";
        String newDescription = "Records Management SitecreateRMSiteWhenSiteExists";
        RMSite rmSiteModel = RMSiteUtil.createRMSiteModel(RMSiteCompliance.STANDARD, newTitle, newDescription);
        this.getRestAPIFactory().getRMSiteAPI().createRMSite(rmSiteModel);
        this.assertStatusCode(HttpStatus.CONFLICT);
    }

    @Test(description="Delete RM site as admin user")
    public void deleteRMSite() {
        this.createRMSiteIfNotExists();
        this.getRestAPIFactory().getRMSiteAPI().deleteRMSite();
        this.assertStatusCode(HttpStatus.NO_CONTENT);
    }

    @Test(description="GET the RM site as admin user", priority=3)
    public void getRMSite() {
        RMSiteAPI rmSiteAPI = this.getRestAPIFactory().getRMSiteAPI();
        if (!rmSiteAPI.existsRMSite()) {
            this.assertStatusCode(HttpStatus.NOT_FOUND);
            this.createRMSiteIfNotExists();
        } else {
            RMSite rmSiteModel = rmSiteAPI.getSite();
            this.assertStatusCode(HttpStatus.OK);
            Assert.assertEquals((String)rmSiteModel.getId(), (String)"rm");
            Assert.assertEquals((String)rmSiteModel.getDescription(), (String)"Records Management Site");
            Assert.assertEquals((Object)rmSiteModel.getCompliance(), (Object)RMSiteCompliance.STANDARD);
            Assert.assertEquals((Object)rmSiteModel.getVisibility(), (Object)SiteService.Visibility.PUBLIC);
        }
    }

    @Test(description="Create RM site with DOD compliance as an another admin user", priority=1)
    @Bug(id="RM-4289")
    public void createRMSiteAsAnotherAdminUser() {
        RMSiteAPI rmSiteAPI = this.getRestAPIFactory().getRMSiteAPI();
        if (rmSiteAPI.existsRMSite()) {
            rmSiteAPI.deleteRMSite();
        }
        this.getRestAPIFactory().getRMUserAPI().createUser("another_admin", "password", "default@alfresco.com");
        RMSite rmSiteModel = this.getRestAPIFactory().getRMSiteAPI(new UserModel("another_admin", "password")).createRMSite(RMSiteUtil.createDOD5015RMSiteModel());
        this.assertStatusCode(HttpStatus.CREATED);
        Assert.assertEquals((String)rmSiteModel.getId(), (String)"rm");
        Assert.assertEquals((String)rmSiteModel.getTitle(), (String)"Records Management");
        Assert.assertEquals((String)rmSiteModel.getDescription(), (String)"Records Management Site");
        Assert.assertEquals((Object)rmSiteModel.getCompliance(), (Object)RMSiteCompliance.DOD5015);
        Assert.assertEquals((Object)rmSiteModel.getVisibility(), (Object)SiteService.Visibility.PUBLIC);
        Assert.assertEquals((String)rmSiteModel.getRole(), (String)UserRole.SiteManager.toString());
    }

    @Test(priority=3)
    public void updateRMSiteDetails() {
        String NEW_TITLE = "Records Management" + RandomData.getRandomAlphanumeric();
        String NEW_DESCRIPTION = "Records Management Site" + RandomData.getRandomAlphanumeric();
        this.createRMSiteIfNotExists();
        RMSite rmSiteToUpdate = RMSite.builder().title(NEW_TITLE).description(NEW_DESCRIPTION).build();
        this.getRestAPIFactory().getRMSiteAPI(this.getDataUser().createRandomTestUser("testUser")).updateRMSite(rmSiteToUpdate);
        this.assertStatusCode(HttpStatus.FORBIDDEN);
        RMSite rmSiteModel = this.getRestAPIFactory().getRMSiteAPI().updateRMSite(rmSiteToUpdate);
        this.assertStatusCode(HttpStatus.OK);
        Assert.assertEquals((String)rmSiteModel.getId(), (String)"rm");
        Assert.assertEquals((String)rmSiteModel.getTitle(), (String)NEW_TITLE);
        Assert.assertEquals((String)rmSiteModel.getDescription(), (String)NEW_DESCRIPTION);
        Assert.assertNotNull((Object)rmSiteModel.getCompliance());
        Assert.assertEquals((Object)rmSiteModel.getVisibility(), (Object)SiteService.Visibility.PUBLIC);
    }

    @Test(priority=3)
    public void updateRMSiteComplianceAsAdmin() {
        this.createRMSiteIfNotExists();
        RMSite rmSiteToUpdate = RMSite.builder().compliance(RMSiteCompliance.DOD5015).build();
        this.getRestAPIFactory().getRMSiteAPI().updateRMSite(rmSiteToUpdate);
        this.assertStatusCode(HttpStatus.BAD_REQUEST);
    }
}

