/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.hold;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.dataprep.ContentActions;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.hold.AddToHoldsV1Tests;
import org.alfresco.rest.rm.community.model.hold.BulkBodyCancel;
import org.alfresco.rest.rm.community.model.hold.Hold;
import org.alfresco.rest.rm.community.model.hold.HoldBulkOperation;
import org.alfresco.rest.rm.community.model.hold.HoldBulkOperationEntry;
import org.alfresco.rest.rm.community.model.hold.HoldBulkStatus;
import org.alfresco.rest.rm.community.model.hold.HoldBulkStatusCollection;
import org.alfresco.rest.rm.community.model.hold.HoldBulkStatusEntry;
import org.alfresco.rest.rm.community.model.hold.HoldChild;
import org.alfresco.rest.rm.community.model.hold.HoldChildEntry;
import org.alfresco.rest.rm.community.model.user.UserPermissions;
import org.alfresco.rest.rm.community.model.user.UserRoles;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.search.RestRequestQueryModel;
import org.alfresco.rest.search.SearchRequest;
import org.alfresco.rest.v0.service.RoleService;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AddToHoldsBulkV1Tests
extends BaseRMRestTest {
    private static final String ACCESS_DENIED_ERROR_MESSAGE = "Access Denied.  You do not have the appropriate permissions to perform this operation.";
    private static final int NUMBER_OF_FILES = 5;
    private final List<FileModel> addedFiles = new ArrayList<FileModel>();
    private final List<UserModel> users = new ArrayList<UserModel>();
    private final List<Hold> holds = new ArrayList<Hold>();
    private Hold hold;
    private Hold hold2;
    private Hold hold3;
    private FolderModel rootFolder;
    private HoldBulkOperation holdBulkOperation;
    @Autowired
    private RoleService roleService;
    @Autowired
    private ContentActions contentActions;

    @BeforeClass(alwaysRun=true)
    public void preconditionForAddContentToHold() {
        Step.STEP((String)"Create a hold.");
        this.hold = this.getRestAPIFactory().getFilePlansAPI(this.getAdminUser()).createHold(Hold.builder().name("HOLD" + CommonTestUtils.generateTestPrefix(AddToHoldsV1Tests.class)).description("Generalized hold case for tests").reason("Active content to be reviewed for the CASE McDermott, FINRA ").build(), "-filePlan-");
        this.holds.add(this.hold);
        Step.STEP((String)"Create test files.");
        this.testSite = ((DataSite)this.dataSite.usingAdmin()).createPublicRandomSite();
        this.rootFolder = ((DataContent)this.dataContent.usingAdmin().usingSite(this.testSite)).createFolder();
        FolderModel folder1 = ((DataContent)this.dataContent.usingAdmin().usingResource((ContentModel)this.rootFolder)).createFolder();
        FolderModel folder2 = ((DataContent)this.dataContent.usingAdmin().usingResource((ContentModel)folder1)).createFolder();
        for (int i = 0; i < 5; ++i) {
            FileModel documentHeld = ((DataContent)this.dataContent.usingAdmin().usingResource((ContentModel)(i % 2 == 0 ? folder1 : folder2))).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
            this.addedFiles.add(documentHeld);
        }
        RestRequestQueryModel queryReq = this.getContentFromSiteQuery(this.testSite.getId());
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setQuery(queryReq);
        Step.STEP((String)"Wait until all files are searchable.");
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> this.getRestAPIFactory().getSearchAPI(null).search(searchRequest).getPagination().getTotalItems() == 5);
        RestRequestQueryModel ancestorReq = this.getContentFromFolderAndAllSubfoldersQuery(this.rootFolder.getNodeRefWithoutVersion());
        SearchRequest ancestorSearchRequest = new SearchRequest();
        ancestorSearchRequest.setQuery(ancestorReq);
        Step.STEP((String)"Wait until paths are indexed.");
        Awaitility.await().atMost(120L, TimeUnit.SECONDS).until(() -> this.getRestAPIFactory().getSearchAPI(null).search(ancestorSearchRequest).getPagination().getTotalItems() == 5);
        this.holdBulkOperation = HoldBulkOperation.builder().query(queryReq).op(HoldBulkOperation.HoldBulkOperationType.ADD).build();
    }

    @Test
    public void addContentFromTestSiteToHoldUsingBulkAPI() {
        UserModel userAddHoldPermission = this.roleService.createUserWithSiteRoleRMRoleAndPermission(this.testSite, UserRole.SiteCollaborator, this.hold.getId(), UserRoles.ROLE_RM_MANAGER, UserPermissions.PERMISSION_FILING);
        this.users.add(userAddHoldPermission);
        Step.STEP((String)"Add content from the site to the hold using the bulk API.");
        HoldBulkOperationEntry bulkOperationEntry = this.getRestAPIFactory().getHoldsAPI(userAddHoldPermission).startBulkProcess(this.holdBulkOperation, this.hold.getId());
        this.assertStatusCode(HttpStatus.ACCEPTED);
        Assert.assertEquals((long)5L, (long)bulkOperationEntry.getTotalItems());
        Step.STEP((String)"Wait until all files are added to the hold.");
        Awaitility.await().atMost(20L, TimeUnit.SECONDS).until(() -> this.getRestAPIFactory().getHoldsAPI(this.getAdminUser()).getChildren(this.hold.getId()).getEntries().size() == 5);
        List<String> holdChildrenNodeRefs = this.getRestAPIFactory().getHoldsAPI(userAddHoldPermission).getChildren(this.hold.getId()).getEntries().stream().map(HoldChildEntry::getEntry).map(HoldChild::getId).toList();
        Assert.assertEquals(this.addedFiles.stream().map(RepoTestModel::getNodeRefWithoutVersion).sorted().toList(), holdChildrenNodeRefs.stream().sorted().toList());
        Step.STEP((String)"Check the bulk status.");
        HoldBulkStatus holdBulkStatus = this.getRestAPIFactory().getHoldsAPI(userAddHoldPermission).getBulkStatus(this.hold.getId(), bulkOperationEntry.getBulkStatusId());
        this.assertBulkProcessStatus(holdBulkStatus, 5L, 0, null, this.holdBulkOperation);
        Step.STEP((String)"Check the bulk statuses.");
        HoldBulkStatusCollection holdBulkStatusCollection = this.getRestAPIFactory().getHoldsAPI(userAddHoldPermission).getBulkStatuses(this.hold.getId());
        Assert.assertEquals(Arrays.asList(holdBulkStatus), holdBulkStatusCollection.getEntries().stream().map(HoldBulkStatusEntry::getEntry).toList());
    }

    @Test
    public void addContentFromFolderAndAllSubfoldersToHoldUsingBulkAPI() {
        this.hold3 = this.getRestAPIFactory().getFilePlansAPI(this.getAdminUser()).createHold(Hold.builder().name("HOLD" + CommonTestUtils.generateTestPrefix(AddToHoldsV1Tests.class)).description("Generalized hold case for tests").reason("Active content to be reviewed for the CASE McDermott, FINRA ").build(), "-filePlan-");
        this.holds.add(this.hold3);
        UserModel userAddHoldPermission = this.roleService.createUserWithSiteRoleRMRoleAndPermission(this.testSite, UserRole.SiteCollaborator, this.hold3.getId(), UserRoles.ROLE_RM_MANAGER, UserPermissions.PERMISSION_FILING);
        this.users.add(userAddHoldPermission);
        Step.STEP((String)"Add content from the site to the hold using the bulk API.");
        HoldBulkOperation bulkOperation = HoldBulkOperation.builder().query(this.getContentFromFolderAndAllSubfoldersQuery(this.rootFolder.getNodeRefWithoutVersion())).op(HoldBulkOperation.HoldBulkOperationType.ADD).build();
        HoldBulkOperationEntry bulkOperationEntry = this.getRestAPIFactory().getHoldsAPI(userAddHoldPermission).startBulkProcess(bulkOperation, this.hold3.getId());
        this.assertStatusCode(HttpStatus.ACCEPTED);
        Assert.assertEquals((long)5L, (long)bulkOperationEntry.getTotalItems());
        Step.STEP((String)"Wait until all files are added to the hold.");
        Awaitility.await().atMost(20L, TimeUnit.SECONDS).until(() -> this.getRestAPIFactory().getHoldsAPI(this.getAdminUser()).getChildren(this.hold3.getId()).getEntries().size() == 5);
        List<String> holdChildrenNodeRefs = this.getRestAPIFactory().getHoldsAPI(userAddHoldPermission).getChildren(this.hold3.getId()).getEntries().stream().map(HoldChildEntry::getEntry).map(HoldChild::getId).toList();
        Assert.assertEquals(this.addedFiles.stream().map(RepoTestModel::getNodeRefWithoutVersion).sorted().toList(), holdChildrenNodeRefs.stream().sorted().toList());
        Step.STEP((String)"Check the bulk status.");
        HoldBulkStatus holdBulkStatus = this.getRestAPIFactory().getHoldsAPI(userAddHoldPermission).getBulkStatus(this.hold3.getId(), bulkOperationEntry.getBulkStatusId());
        this.assertBulkProcessStatus(holdBulkStatus, 5L, 0, null, bulkOperation);
        Step.STEP((String)"Check the bulk statuses.");
        HoldBulkStatusCollection holdBulkStatusCollection = this.getRestAPIFactory().getHoldsAPI(userAddHoldPermission).getBulkStatuses(this.hold3.getId());
        Assert.assertEquals(List.of(holdBulkStatus), holdBulkStatusCollection.getEntries().stream().map(HoldBulkStatusEntry::getEntry).toList());
    }

    @Test
    public void testBulkProcessWithUserWithoutAddToHoldCapability() {
        UserModel userWithoutAddToHoldCapability = this.roleService.createUserWithSiteRoleRMRoleAndPermission(this.testSite, UserRole.SiteCollaborator, this.hold.getId(), UserRoles.ROLE_RM_POWER_USER, UserPermissions.PERMISSION_FILING);
        this.users.add(userWithoutAddToHoldCapability);
        Step.STEP((String)"Add content from the site to the hold using the bulk API.");
        this.getRestAPIFactory().getHoldsAPI(userWithoutAddToHoldCapability).startBulkProcess(this.holdBulkOperation, this.hold.getId());
        Step.STEP((String)"Verify the response status code and the error message.");
        this.assertStatusCode(HttpStatus.FORBIDDEN);
        this.getRestAPIFactory().getRmRestWrapper().assertLastError().containsSummary(ACCESS_DENIED_ERROR_MESSAGE);
    }

    @Test
    public void testBulkProcessWithUserWithoutFilingPermissionOnAHold() {
        UserModel userWithoutPermission = this.roleService.createUserWithSiteRoleRMRoleAndPermission(this.testSite, UserRole.SiteCollaborator, this.hold.getId(), UserRoles.ROLE_RM_MANAGER, UserPermissions.PERMISSION_READ_RECORDS);
        this.users.add(userWithoutPermission);
        Step.STEP((String)"Add content from the site to the hold using the bulk API.");
        this.getRestAPIFactory().getHoldsAPI(userWithoutPermission).startBulkProcess(this.holdBulkOperation, this.hold.getId());
        Step.STEP((String)"Verify the response status code and the error message.");
        this.assertStatusCode(HttpStatus.FORBIDDEN);
        this.getRestAPIFactory().getRmRestWrapper().assertLastError().containsSummary(ACCESS_DENIED_ERROR_MESSAGE);
    }

    @Test
    public void testBulkProcessWithUserWithoutWritePermissionOnTheContent() {
        UserModel userWithoutPermission = this.roleService.createUserWithSiteRoleRMRoleAndPermission(this.testSite, UserRole.SiteConsumer, this.hold.getId(), UserRoles.ROLE_RM_MANAGER, UserPermissions.PERMISSION_FILING);
        this.users.add(userWithoutPermission);
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setQuery(this.holdBulkOperation.getQuery());
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> this.getRestAPIFactory().getSearchAPI(userWithoutPermission).search(searchRequest).getPagination().getTotalItems() == 5);
        Step.STEP((String)"Add content from the site to the hold using the bulk API.");
        HoldBulkOperationEntry bulkOperationEntry = this.getRestAPIFactory().getHoldsAPI(userWithoutPermission).startBulkProcess(this.holdBulkOperation, this.hold.getId());
        Step.STEP((String)"Verify the response.");
        this.assertStatusCode(HttpStatus.ACCEPTED);
        Awaitility.await().atMost(20L, TimeUnit.SECONDS).until(() -> Objects.equals(this.getRestAPIFactory().getHoldsAPI(userWithoutPermission).getBulkStatus(this.hold.getId(), bulkOperationEntry.getBulkStatusId()).getStatus(), "DONE"));
        HoldBulkStatus holdBulkStatus = this.getRestAPIFactory().getHoldsAPI(userWithoutPermission).getBulkStatus(this.hold.getId(), bulkOperationEntry.getBulkStatusId());
        this.assertBulkProcessStatus(holdBulkStatus, 5L, 5, ACCESS_DENIED_ERROR_MESSAGE, this.holdBulkOperation);
    }

    @Test
    public void testBulkProcessWithUserWithoutWritePermissionOnOneFile() {
        this.hold2 = this.getRestAPIFactory().getFilePlansAPI(this.getAdminUser()).createHold(Hold.builder().name("HOLD" + CommonTestUtils.generateTestPrefix(AddToHoldsV1Tests.class)).description("Generalized hold case for tests").reason("Active content to be reviewed for the CASE McDermott, FINRA ").build(), "-filePlan-");
        this.holds.add(this.hold2);
        UserModel userAddHoldPermission = this.roleService.createUserWithSiteRoleRMRoleAndPermission(this.testSite, UserRole.SiteCollaborator, this.hold2.getId(), UserRoles.ROLE_RM_MANAGER, UserPermissions.PERMISSION_FILING);
        this.users.add(userAddHoldPermission);
        this.contentActions.setPermissionForUser(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.testSite.getId(), this.addedFiles.get(0).getName(), userAddHoldPermission.getUsername(), UserRole.SiteConsumer.getRoleId(), false);
        Step.STEP((String)"Add content from the site to the hold using the bulk API.");
        HoldBulkOperationEntry bulkOperationEntry = this.getRestAPIFactory().getHoldsAPI(userAddHoldPermission).startBulkProcess(this.holdBulkOperation, this.hold2.getId());
        this.assertStatusCode(HttpStatus.ACCEPTED);
        Assert.assertEquals((long)5L, (long)bulkOperationEntry.getTotalItems());
        Step.STEP((String)"Wait until all files are added to the hold.");
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> this.getRestAPIFactory().getHoldsAPI(this.getAdminUser()).getChildren(this.hold2.getId()).getEntries().size() == 4);
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> this.getRestAPIFactory().getHoldsAPI(userAddHoldPermission).getBulkStatus(this.hold2.getId(), bulkOperationEntry.getBulkStatusId()).getProcessedItems() == 5L);
        List<String> holdChildrenNodeRefs = this.getRestAPIFactory().getHoldsAPI(userAddHoldPermission).getChildren(this.hold2.getId()).getEntries().stream().map(HoldChildEntry::getEntry).map(HoldChild::getId).toList();
        Assert.assertEquals(this.addedFiles.stream().skip(1L).map(RepoTestModel::getNodeRefWithoutVersion).sorted().toList(), holdChildrenNodeRefs.stream().sorted().toList());
        Step.STEP((String)"Check the bulk status.");
        HoldBulkStatus holdBulkStatus = this.getRestAPIFactory().getHoldsAPI(userAddHoldPermission).getBulkStatus(this.hold2.getId(), bulkOperationEntry.getBulkStatusId());
        this.assertBulkProcessStatus(holdBulkStatus, 5L, 1, ACCESS_DENIED_ERROR_MESSAGE, this.holdBulkOperation);
        Step.STEP((String)"Check the bulk statuses.");
        HoldBulkStatusCollection holdBulkStatusCollection = this.getRestAPIFactory().getHoldsAPI(userAddHoldPermission).getBulkStatuses(this.hold2.getId());
        Assert.assertEquals(List.of(holdBulkStatus), holdBulkStatusCollection.getEntries().stream().map(HoldBulkStatusEntry::getEntry).toList());
        this.contentActions.setPermissionForUser(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.testSite.getId(), this.addedFiles.get(0).getName(), userAddHoldPermission.getUsername(), UserRole.SiteCollaborator.getRoleId(), true);
    }

    @Test
    public void testBulkProcessAsUnauthenticatedUser() {
        Step.STEP((String)"Start bulk process as unauthenticated user");
        this.getRestAPIFactory().getHoldsAPI(new UserModel(this.getAdminUser().getUsername(), "wrongPassword")).startBulkProcess(this.holdBulkOperation, this.hold.getId());
        Step.STEP((String)"Verify the response status code.");
        this.assertStatusCode(HttpStatus.UNAUTHORIZED);
    }

    @Test
    public void testBulkProcessForNonExistentHold() {
        Step.STEP((String)"Start bulk process for non existent hold");
        this.getRestAPIFactory().getHoldsAPI(this.getAdminUser()).startBulkProcess(this.holdBulkOperation, "nonExistentHoldId");
        Step.STEP((String)"Verify the response status code.");
        this.assertStatusCode(HttpStatus.NOT_FOUND);
    }

    @Test
    public void testGetBulkStatusesForInvalidOperation() {
        Step.STEP((String)"Start bulk process for non existent hold");
        HoldBulkOperation invalidHoldBulkOperation = HoldBulkOperation.builder().op(null).query(this.holdBulkOperation.getQuery()).build();
        this.getRestAPIFactory().getHoldsAPI(this.getAdminUser()).startBulkProcess(invalidHoldBulkOperation, this.hold.getId());
        Step.STEP((String)"Verify the response status code.");
        this.assertStatusCode(HttpStatus.BAD_REQUEST);
    }

    @Test
    public void testGetBulkStatusForNonExistentHold() {
        Step.STEP((String)"Start bulk process for non existent hold");
        this.getRestAPIFactory().getHoldsAPI(this.getAdminUser()).getBulkStatus("nonExistentHoldId", "nonExistenBulkStatusId");
        Step.STEP((String)"Verify the response status code.");
        this.assertStatusCode(HttpStatus.NOT_FOUND);
    }

    @Test
    public void testGetBulkStatusForNonExistentBulkStatus() {
        Step.STEP((String)"Start bulk process for non bulk status");
        this.getRestAPIFactory().getHoldsAPI(this.getAdminUser()).getBulkStatus(this.hold.getId(), "nonExistenBulkStatusId");
        Step.STEP((String)"Verify the response status code.");
        this.assertStatusCode(HttpStatus.NOT_FOUND);
    }

    @Test
    public void testGetBulkStatusesForNonExistentHold() {
        Step.STEP((String)"Start bulk process for non existent hold");
        this.getRestAPIFactory().getHoldsAPI(this.getAdminUser()).getBulkStatuses("nonExistentHoldId");
        Step.STEP((String)"Verify the response status code.");
        this.assertStatusCode(HttpStatus.NOT_FOUND);
    }

    @Test
    public void testExceedingBulkOperationLimit() {
        RestRequestQueryModel queryReq = new RestRequestQueryModel();
        queryReq.setQuery("TYPE:content");
        queryReq.setLanguage("afts");
        HoldBulkOperation exceedLimitOp = HoldBulkOperation.builder().query(queryReq).op(HoldBulkOperation.HoldBulkOperationType.ADD).build();
        Step.STEP((String)"Start bulk process to exceed the limit");
        this.getRestAPIFactory().getHoldsAPI(this.getAdminUser()).startBulkProcess(exceedLimitOp, this.hold.getId());
        Step.STEP((String)"Verify the response status code.");
        this.assertStatusCode(HttpStatus.BAD_REQUEST);
    }

    @Test
    public void testBulkProcessCancellationWithAllowedUser() {
        Hold hold4 = this.getRestAPIFactory().getFilePlansAPI(this.getAdminUser()).createHold(Hold.builder().name("HOLD" + CommonTestUtils.generateTestPrefix(AddToHoldsV1Tests.class)).description("Generalized hold case for tests").reason("Active content to be reviewed for the CASE McDermott, FINRA ").build(), "-filePlan-");
        this.holds.add(hold4);
        UserModel userAddHoldPermission = this.roleService.createUserWithSiteRoleRMRoleAndPermission(this.testSite, UserRole.SiteCollaborator, hold4.getId(), UserRoles.ROLE_RM_MANAGER, UserPermissions.PERMISSION_FILING);
        this.users.add(userAddHoldPermission);
        Step.STEP((String)"Add content from the site to the hold using the bulk API.");
        HoldBulkOperationEntry bulkOperationEntry = this.getRestAPIFactory().getHoldsAPI(userAddHoldPermission).startBulkProcess(this.holdBulkOperation, hold4.getId());
        this.assertStatusCode(HttpStatus.ACCEPTED);
        Assert.assertEquals((long)5L, (long)bulkOperationEntry.getTotalItems());
        Step.STEP((String)"Cancel the bulk operation.");
        this.getRestAPIFactory().getHoldsAPI(userAddHoldPermission).cancelBulkOperation(hold4.getId(), bulkOperationEntry.getBulkStatusId(), new BulkBodyCancel());
        this.assertStatusCode(HttpStatus.OK);
    }

    @Test
    public void testBulkProcessCancellationWithUserWithoutAddToHoldCapability() {
        Hold hold5 = this.getRestAPIFactory().getFilePlansAPI(this.getAdminUser()).createHold(Hold.builder().name("HOLD" + CommonTestUtils.generateTestPrefix(AddToHoldsV1Tests.class)).description("Generalized hold case for tests").reason("Active content to be reviewed for the CASE McDermott, FINRA ").build(), "-filePlan-");
        this.holds.add(hold5);
        UserModel userAddHoldPermission = this.roleService.createUserWithSiteRoleRMRoleAndPermission(this.testSite, UserRole.SiteCollaborator, hold5.getId(), UserRoles.ROLE_RM_MANAGER, UserPermissions.PERMISSION_FILING);
        this.users.add(userAddHoldPermission);
        Step.STEP((String)"Add content from the site to the hold using the bulk API.");
        HoldBulkOperationEntry bulkOperationEntry = this.getRestAPIFactory().getHoldsAPI(userAddHoldPermission).startBulkProcess(this.holdBulkOperation, hold5.getId());
        this.assertStatusCode(HttpStatus.ACCEPTED);
        Assert.assertEquals((long)5L, (long)bulkOperationEntry.getTotalItems());
        UserModel userWithoutAddToHoldCapability = this.roleService.createUserWithSiteRoleRMRoleAndPermission(this.testSite, UserRole.SiteCollaborator, hold5.getId(), UserRoles.ROLE_RM_POWER_USER, UserPermissions.PERMISSION_FILING);
        this.users.add(userWithoutAddToHoldCapability);
        Step.STEP((String)"Cancel the bulk operation.");
        this.getRestAPIFactory().getHoldsAPI(userWithoutAddToHoldCapability).cancelBulkOperation(hold5.getId(), bulkOperationEntry.getBulkStatusId(), new BulkBodyCancel());
        Step.STEP((String)"Verify the response status code and the error message.");
        this.assertStatusCode(HttpStatus.FORBIDDEN);
        this.getRestAPIFactory().getRmRestWrapper().assertLastError().containsSummary(ACCESS_DENIED_ERROR_MESSAGE);
    }

    private void assertBulkProcessStatus(HoldBulkStatus holdBulkStatus, long expectedProcessedItems, int expectedErrorsCount, String expectedErrorMessage, HoldBulkOperation holdBulkOperation) {
        Assert.assertEquals((Object)"DONE", (Object)holdBulkStatus.getStatus());
        Assert.assertEquals((long)expectedProcessedItems, (long)holdBulkStatus.getTotalItems());
        Assert.assertEquals((long)expectedProcessedItems, (long)holdBulkStatus.getProcessedItems());
        Assert.assertEquals((long)expectedErrorsCount, (long)holdBulkStatus.getErrorsCount());
        Assert.assertEquals((Object)holdBulkStatus.getHoldBulkOperation(), (Object)holdBulkOperation);
        Assert.assertNotNull((Object)holdBulkStatus.getStartTime());
        Assert.assertNotNull((Object)holdBulkStatus.getEndTime());
        if (expectedErrorMessage != null) {
            Assert.assertTrue((boolean)holdBulkStatus.getLastError().contains(expectedErrorMessage));
        }
    }

    private RestRequestQueryModel getContentFromSiteQuery(String siteId) {
        RestRequestQueryModel queryReq = new RestRequestQueryModel();
        queryReq.setQuery("SITE:\"" + siteId + "\" and TYPE:content");
        queryReq.setLanguage("afts");
        return queryReq;
    }

    private RestRequestQueryModel getContentFromFolderAndAllSubfoldersQuery(String folderId) {
        RestRequestQueryModel queryReq = new RestRequestQueryModel();
        queryReq.setQuery("ANCESTOR:\"workspace://SpacesStore/" + folderId + "\" and TYPE:content");
        queryReq.setLanguage("afts");
        return queryReq;
    }

    @AfterClass(alwaysRun=true)
    public void cleanupAddToHoldsBulkV1Tests() {
        ((DataSite)this.dataSite.usingAdmin()).deleteSite(this.testSite);
        this.users.forEach(user -> ((DataUser)this.getDataUser().usingAdmin()).deleteUser(user));
        this.holds.forEach(hold -> this.getRestAPIFactory().getHoldsAPI(this.getAdminUser()).deleteHold(hold.getId()));
    }
}

